/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller;

import com.vi2k.ghastthekiller.commands.CheckJEVersion;
import com.vi2k.ghastthekiller.commands.KillAllGhastTheKiller;
import com.vi2k.ghastthekiller.commands.KillGhastTheKiller;
import com.vi2k.ghastthekiller.commands.SetBoardState;
import com.vi2k.ghastthekiller.commands.SpawnGhastTheKiller;
import com.vi2k.ghastthekiller.commands.TabComplete;
import com.vi2k.ghastthekiller.commands.UpdateBoard;
import com.vi2k.ghastthekiller.events.EntityListener;
import com.vi2k.ghastthekiller.events.InventoryListener;
import com.vi2k.ghastthekiller.events.PlayerListener;
import com.vi2k.ghastthekiller.events.VehicleListener;
import com.vi2k.ghastthekiller.managers.ActionBarManager;
import com.vi2k.ghastthekiller.managers.BetterBypassManager;
import com.vi2k.ghastthekiller.managers.BoardManager;
import com.vi2k.ghastthekiller.managers.OnboardingEnemyEntityManager;
import com.vi2k.ghastthekiller.managers.PluginVersionManager;
import com.vi2k.ghastthekiller.managers.RandomChestManager;
import com.vi2k.ghastthekiller.managers.ScreenTextManager;
import com.vi2k.ghastthekiller.models.scheduler.Scheduler;
import com.vi2k.ghastthekiller.settings.GhastTheKillerSettings;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import shadow.io.papermc.paperlib.PaperLib;

public class GhastTheKiller
extends JavaPlugin {
    private ActionBarManager actionBarManager = new ActionBarManager();
    private ScreenTextManager screenTextManager = new ScreenTextManager();
    private BoardManager boardManager = new BoardManager();
    private BetterBypassManager betterBypassManager;
    private OnboardingEnemyEntityManager onBoardingEnemyManager = new OnboardingEnemyEntityManager();
    private RandomChestManager randomChestManager = new RandomChestManager();
    private Scheduler.Task mobMovementTask;
    private Scheduler.Task eSecTask;
    private Scheduler.Task viBetterBypassTask;
    private World jeWorld;
    private GhastTheKillerSettings settings;

    public Logger getLogger() {
        return super.getLogger();
    }

    public void onEnable() {
        PluginVersionManager pluginVersionManager = new PluginVersionManager(this);
        if (!pluginVersionManager.initialize()) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("GhastTheKillerPlugin activated! Any bugs? Report to github/lesongvi");
        PaperLib.suggestPaper((Plugin)this);
        this.saveDefaultConfig();
        this.settings = GhastTheKillerSettings.getInstance();
        this.settings.loadConfig();
        EntityListener entityListener = new EntityListener();
        PlayerListener playerListener = new PlayerListener();
        VehicleListener vehicleListener = new VehicleListener();
        InventoryListener inventoryListener = new InventoryListener();
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)entityListener, (Plugin)this);
        pluginManager.registerEvents((Listener)playerListener, (Plugin)this);
        pluginManager.registerEvents((Listener)vehicleListener, (Plugin)this);
        pluginManager.registerEvents((Listener)inventoryListener, (Plugin)this);
        PluginCommand spawnGhastTheKiller = this.getCommand("je-boss");
        PluginCommand killGhastTheKiller = this.getCommand("je-killboss");
        PluginCommand killAllGhastTheKiller = this.getCommand("je-killallboss");
        PluginCommand updateBoard = this.getCommand("je-updatestkboard");
        PluginCommand setBoardState = this.getCommand("je-setstkboardstate");
        PluginCommand checkJESkriptVersion = this.getCommand("je-checkskversion");
        if (spawnGhastTheKiller != null) {
            spawnGhastTheKiller.setExecutor((CommandExecutor)new SpawnGhastTheKiller(this));
            spawnGhastTheKiller.setTabCompleter((TabCompleter)new TabComplete());
        }
        if (killGhastTheKiller != null) {
            killGhastTheKiller.setExecutor((CommandExecutor)new KillGhastTheKiller(this));
            killGhastTheKiller.setTabCompleter((TabCompleter)new TabComplete());
        }
        if (killAllGhastTheKiller != null) {
            killAllGhastTheKiller.setExecutor((CommandExecutor)new KillAllGhastTheKiller(this));
            killAllGhastTheKiller.setTabCompleter((TabCompleter)new TabComplete());
        }
        if (updateBoard != null) {
            updateBoard.setExecutor((CommandExecutor)new UpdateBoard(this));
            updateBoard.setTabCompleter((TabCompleter)new TabComplete());
        }
        if (setBoardState != null) {
            setBoardState.setExecutor((CommandExecutor)new SetBoardState(this));
            setBoardState.setTabCompleter((TabCompleter)new TabComplete());
        }
        if (checkJESkriptVersion != null) {
            checkJESkriptVersion.setExecutor((CommandExecutor)new CheckJEVersion(this));
            checkJESkriptVersion.setTabCompleter((TabCompleter)new TabComplete());
        }
        this.initEverySecondTaskRunner();
        this.jeWorld = Bukkit.getWorld((String)"pixel");
        this.betterBypassManager = new BetterBypassManager(this);
        if (this.settings.getHarderBypass()) {
            this.betterBypassManager.init(() -> this.startBetterBypassTask());
        }
    }

    public void onDisable() {
        this.getLogger().info("GhastTheKillerPlugin deactivated! Not happy? Don't report to github/lesongvi :)");
        if (this.mobMovementTask != null) {
            this.mobMovementTask.cancel();
        }
        if (this.eSecTask != null) {
            this.eSecTask.cancel();
        }
        if (this.viBetterBypassTask != null) {
            this.viBetterBypassTask.cancel();
            this.betterBypassManager.resetState();
        }
    }

    public ScreenTextManager getScreenTextManager() {
        return this.screenTextManager;
    }

    public ActionBarManager getActionBarManager() {
        return this.actionBarManager;
    }

    public RandomChestManager getRandomChestManager() {
        return this.randomChestManager;
    }

    public void handleMobMovements() {
        this.mobMovementTask = Scheduler.runTimer(() -> this.onBoardingEnemyManager.action(), 0L, 1L);
    }

    public void stopControlMobMovement() {
        if (this.mobMovementTask == null) {
            return;
        }
        this.mobMovementTask.cancel();
    }

    public BoardManager getBoardManager() {
        return this.boardManager;
    }

    public void setBoardState(Integer state, Player player) {
        this.boardManager.setBoardState(state, player);
    }

    private void initEverySecondTaskRunner() {
        this.eSecTask = Scheduler.runTimer(() -> {
            this.actionBarManager.action();
            this.screenTextManager.action();
        }, 0L, 20L);
    }

    private void startBetterBypassTask() {
        this.viBetterBypassTask = Scheduler.runTimer(() -> this.betterBypassManager.action(), 1L, 1L);
    }

    public static GhastTheKiller getInstance() {
        return (GhastTheKiller)GhastTheKiller.getPlugin(GhastTheKiller.class);
    }

    public World getWorld() {
        return this.jeWorld;
    }

    public OnboardingEnemyEntityManager getOnBoardingEnemyEntityManager() {
        return this.onBoardingEnemyManager;
    }
}

