/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.commands;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.managers.SkriptVersionManager;
import com.vi2k.ghastthekiller.models.versionmanager.SkriptUpgradeDetail;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CheckJEVersion
implements CommandExecutor {
    private GhastTheKiller plugin;

    public CheckJEVersion(GhastTheKiller plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player) && !(sender instanceof ConsoleCommandSender)) {
            return false;
        }
        if (args.length != 1) {
            return false;
        }
        String skriptVersion = args[0];
        SkriptVersionManager skriptVersionManager = new SkriptVersionManager(this.plugin, skriptVersion);
        skriptVersionManager.checkVersion();
        SkriptUpgradeDetail skriptUpgradeDetail = skriptVersionManager.getUpgradeDetail();
        if (skriptUpgradeDetail == null) {
            TextComponent message = Component.text((String)"Failed to check the latest version of JE Skript!", (TextColor)NamedTextColor.RED);
            sender.sendMessage((Component)message);
            return false;
        }
        if (skriptUpgradeDetail.isUpdateRequired()) {
            TextComponent message = Component.text((String)"You must update JE Skript to keep using it!", (TextColor)NamedTextColor.RED);
            sender.sendMessage((Component)message);
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "skript disable " + skriptUpgradeDetail.getSkriptName());
            return false;
        }
        if (skriptUpgradeDetail.isUpdateAvailable()) {
            TextComponent message = Component.text((String)skriptUpgradeDetail.getUpdateWarning(), (TextColor)NamedTextColor.YELLOW);
            sender.sendMessage((Component)message);
        }
        return true;
    }
}

