/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.commands;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.commands.SpawnGhastTheKiller;
import com.vi2k.ghastthekiller.constants.EntityConstant;
import com.vi2k.ghastthekiller.managers.OnboardingEnemyEntityManager;
import com.vi2k.ghastthekiller.models.GhastTheKillerMetadata;
import com.vi2k.ghastthekiller.models.OnBoardingEnemyEntity;
import com.vi2k.ghastthekiller.models.scheduler.Scheduler;
import com.vi2k.ghastthekiller.settings.GhastTheKillerSettings;
import com.vi2k.ghastthekiller.utils.CornerBossUtil;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;

public class KillGhastTheKiller
implements CommandExecutor {
    private GhastTheKiller plugin;
    private OnboardingEnemyEntityManager onBoardingEnemyEntityManager;

    public KillGhastTheKiller(GhastTheKiller plugin) {
        this.plugin = plugin;
        this.onBoardingEnemyEntityManager = this.plugin.getOnBoardingEnemyEntityManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 4) {
            sender.sendMessage("There must be 4 arguments");
            return false;
        }
        if (sender instanceof Player || sender instanceof ConsoleCommandSender) {
            OnBoardingEnemyEntity onBoardingEnemyEntity;
            boolean isUUIDAlreadyInList;
            Integer removeAfter = Integer.parseInt(args[0]);
            EntityConstant.ALLOWED_ENTITY entity = EntityConstant.ALLOWED_ENTITY.valueOf(args[1]);
            String donorName = args[2];
            UUID entityUUID = UUID.fromString(args[3]);
            if (this.onBoardingEnemyEntityManager.isThereNoEntityOnBoarding()) {
                this.plugin.stopControlMobMovement();
            }
            if (isUUIDAlreadyInList = (onBoardingEnemyEntity = this.onBoardingEnemyEntityManager.getOnBoardingEnemyEntity(entity)).getEntityUUIDs().keySet().contains(entityUUID)) {
                Mob enemyEntity = (Mob)Bukkit.getEntity((UUID)entityUUID);
                if (enemyEntity != null) {
                    enemyEntity.damage(1000.0);
                    if (enemyEntity.getType() == EntityType.ELDER_GUARDIAN) {
                        ArrayList<Mob> cornerBosses = CornerBossUtil.getNearbyCornerBosses(enemyEntity);
                        for (Mob cornerBoss : cornerBosses) {
                            cornerBoss.remove();
                        }
                    }
                }
                this.onBoardingEnemyEntityManager.removeEntityFromOnBoardingEnemyEntity(entity, entityUUID);
            }
            if (this.onBoardingEnemyEntityManager.isThereNoEntityOnBoarding()) {
                World world = Bukkit.getWorld((String)"pixel");
                world.setTime((long)GhastTheKillerSettings.getInstance().getConstantDayTime().intValue());
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.stopSound(GhastTheKillerSettings.getInstance().getBossHuntingSound().getSoundID());
                }
            }
            Scheduler.runLater(() -> {
                boolean isGhastMetadataQueueEmpty = this.onBoardingEnemyEntityManager.isGhastMetadataQueueEmpty();
                if (!isGhastMetadataQueueEmpty) {
                    GhastTheKillerMetadata ghastMetadata = this.onBoardingEnemyEntityManager.dequeueFirstEnemyEntityMetadata();
                    String[] newArgs = new String[]{ghastMetadata.getRemoveAfter().toString(), ghastMetadata.getDonorName(), ghastMetadata.getEntity().name(), ghastMetadata.getTargetName()};
                    SpawnGhastTheKiller spawnGhastTheKiller = new SpawnGhastTheKiller(this.plugin);
                    spawnGhastTheKiller.onCommand(sender, command, label, newArgs);
                }
            }, 40L);
        }
        return true;
    }
}

