/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.commands;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.helpers.PlayerHelper;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class SetBoardState
implements CommandExecutor {
    private GhastTheKiller plugin;

    public SetBoardState(GhastTheKiller plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player) && !(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("You must be a player or console to use this command");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("You must provide 2 arguments");
            return false;
        }
        try {
            Integer state = Integer.parseInt(args[0]);
            UUID playerUUID = UUID.fromString(args[1]);
            Player player = PlayerHelper.getPlayerByUUID(playerUUID);
            if (!PlayerHelper.isValidPlayer(player)) {
                sender.sendMessage("You must provide valid player name");
                return false;
            }
            this.plugin.setBoardState(state, player);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("You must provide valid argument(s)");
            return false;
        }
        return true;
    }
}

