/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.commands;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.commands.KillGhastTheKiller;
import com.vi2k.ghastthekiller.constants.EntityConstant;
import com.vi2k.ghastthekiller.constants.TimeConstant;
import com.vi2k.ghastthekiller.managers.OnboardingEnemyEntityManager;
import com.vi2k.ghastthekiller.managers.ScreenTextManager;
import com.vi2k.ghastthekiller.models.GhastTheKillerMetadata;
import com.vi2k.ghastthekiller.models.scheduler.Scheduler;
import com.vi2k.ghastthekiller.settings.GhastTheKillerSettings;
import com.vi2k.ghastthekiller.utils.CornerBossUtil;
import com.vi2k.ghastthekiller.utils.PlayerUtil;
import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SpawnGhastTheKiller
implements CommandExecutor {
    private GhastTheKiller plugin;
    private OnboardingEnemyEntityManager onBoardingEnemyEntityManager;
    private ScreenTextManager screenTextManager;

    public SpawnGhastTheKiller(GhastTheKiller plugin) {
        this.plugin = plugin;
        this.onBoardingEnemyEntityManager = this.plugin.getOnBoardingEnemyEntityManager();
        this.screenTextManager = this.plugin.getScreenTextManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player || sender instanceof ConsoleCommandSender) {
            EntityType entityType;
            if (!this.isArgsValid(args)) {
                sender.sendMessage("You must provide time and donor name and target name");
                return false;
            }
            Player player = PlayerUtil.getPlayerEntity(sender, args.length == 4 ? args[3] : sender.getName());
            if (player == null) {
                sender.sendMessage("You must provide valid target player name");
                return false;
            }
            try {
                entityType = EntityType.valueOf((String)args[2]);
                if (!this.validateAllowedEntity(entityType.name())) {
                    throw new IllegalArgumentException("Invalid entity type");
                }
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("You must provide valid entity type");
                return false;
            }
            String entityName = args[2];
            EntityConstant.ALLOWED_ENTITY allowedEntity = EntityConstant.ALLOWED_ENTITY.valueOf(entityName);
            Integer removeAfter = Integer.parseInt(args[0]);
            String donorName = args[1];
            if (removeAfter == 0) {
                removeAfter = this.onBoardingEnemyEntityManager.getConfiguredSpawnTime(allowedEntity);
            }
            GhastTheKillerMetadata metadata = new GhastTheKillerMetadata(removeAfter, donorName, player.getName(), allowedEntity);
            if (this.onBoardingEnemyEntityManager.isMaxQuantityReached(allowedEntity)) {
                player.sendMessage("Boss " + entityName + " is added to the queue and will be spawned later.");
                this.onBoardingEnemyEntityManager.addEnemyEntityMetadataToQueue(metadata);
            } else {
                UUID enemyEntityUUID;
                player.sendMessage("Boss " + entityName + " will be spawned now");
                TextComponent bossCustomName = Component.text((String)donorName);
                World world = Bukkit.getWorld((String)"pixel");
                Integer playerY = player.getLocation().getBlockY();
                if (entityType == EntityType.PHANTOM || entityType == EntityType.VEX) {
                    playerY = playerY + 10;
                }
                Location[] path = new Location[]{new Location(world, -282.0, (double)playerY.intValue(), 242.0)};
                assert (world != null);
                if (entityType == EntityType.ELDER_GUARDIAN) {
                    ArrayList<Location> cornerBossLocations = CornerBossUtil.calculateCornerBossSpawnLocationList();
                    enemyEntity = CornerBossUtil.spawnAndSetupCornerBoss(world, cornerBossLocations.get(0), entityType, (Component)bossCustomName, player);
                    for (int i = 1; i < cornerBossLocations.size(); ++i) {
                        Location location = cornerBossLocations.get(i);
                        CornerBossUtil.spawnAndSetupCornerBoss(world, location, entityType, (Component)bossCustomName, player);
                    }
                    enemyEntityUUID = enemyEntity.getUniqueId();
                    player.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, removeAfter * 20, 0, false, false));
                } else {
                    enemyEntity = (Mob)world.spawnEntity(path[0], entityType);
                    enemyEntity.setTarget((LivingEntity)player);
                    enemyEntityUUID = enemyEntity.getUniqueId();
                    if (entityType == EntityType.WITHER) {
                        enemyEntity.customName((Component)Component.text((String)""));
                        enemyEntity.setCustomNameVisible(false);
                    } else {
                        enemyEntity.customName((Component)bossCustomName);
                        enemyEntity.setCustomNameVisible(true);
                    }
                    if (entityType == EntityType.PHANTOM || entityType == EntityType.VEX) {
                        enemyEntity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(10.0);
                    }
                    enemyEntity.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(500.0);
                }
                if (this.onBoardingEnemyEntityManager.isThereNoEntityOnBoarding()) {
                    world.setTime((long)GhastTheKillerSettings.getInstance().getConstantNightTime().intValue());
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        onlinePlayer.playSound(player.getLocation(), GhastTheKillerSettings.getInstance().getBossHuntingSound().getSoundID(), GhastTheKillerSettings.getInstance().getBossHuntingSound().getVolume().floatValue(), GhastTheKillerSettings.getInstance().getBossHuntingSound().getVolume().floatValue());
                    }
                    this.plugin.handleMobMovements();
                }
                this.onBoardingEnemyEntityManager.addOnBoardingEnemyEntityQuantity(allowedEntity, enemyEntityUUID, (Entity)player);
                Integer finalRemoveAfter = removeAfter;
                TextComponent title = Component.text((String)"ALERT!", (TextColor)NamedTextColor.RED);
                Component subtitle = this.subtitleProcessor(donorName, entityName, finalRemoveAfter);
                this.screenTextManager.addMessage(player, (Component)title, subtitle, TimeConstant.SCREEN_TEXT_MESSAGE_DURATION);
                Scheduler.runLater(() -> {
                    String[] newArgs = new String[]{metadata.getRemoveAfter().toString(), entityName, metadata.getDonorName(), enemyEntityUUID.toString()};
                    KillGhastTheKiller killGhastTheKiller = new KillGhastTheKiller(this.plugin);
                    killGhastTheKiller.onCommand(sender, command, label, newArgs);
                }, (long)removeAfter.intValue() * 20L);
            }
        }
        return true;
    }

    private Component subtitleProcessor(String donorName, String entityName, Integer timeLeft) {
        Object newDonorName = donorName;
        String newEntityName = entityName;
        String newTimeLeft = timeLeft.toString();
        typeOfDisplaySubtitle typeOfDisplaySubtitle2 = this.getTypeOfDisplaySubtitle(donorName);
        Component template = switch (typeOfDisplaySubtitle2) {
            case typeOfDisplaySubtitle.TIME -> EntityConstant.REPLACABLE_BOSS_APPEAR_MESSAGE;
            case typeOfDisplaySubtitle.NOTIME -> EntityConstant.REPLACABLE_NO_TIME_BOSS_APPEAR_MESSAGE;
            default -> {
                newDonorName = donorName.substring(0, 13) + "...";
                yield EntityConstant.REPLACABLE_NO_TIME_BOSS_APPEAR_MESSAGE;
            }
        };
        TextReplacementConfig donorNameReplacementConfig = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<DONOR_NAME>").replacement((ComponentLike)Component.text((String)newDonorName, (TextColor)NamedTextColor.YELLOW)).build();
        TextReplacementConfig entityNameReplacementConfig = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<BOSS_NAME>").replacement((ComponentLike)Component.text((String)newEntityName, (TextColor)NamedTextColor.YELLOW)).build();
        TextReplacementConfig timeLeftReplacementConfig = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<TIME_LEFT>").replacement((ComponentLike)Component.text((String)newTimeLeft, (TextColor)NamedTextColor.YELLOW)).build();
        Component subtitle = template.replaceText(donorNameReplacementConfig).replaceText(entityNameReplacementConfig).replaceText(timeLeftReplacementConfig);
        return subtitle;
    }

    private typeOfDisplaySubtitle getTypeOfDisplaySubtitle(String donorName) {
        if (donorName.length() <= 8) {
            return typeOfDisplaySubtitle.TIME;
        }
        if (donorName.length() <= 16) {
            return typeOfDisplaySubtitle.NOTIME;
        }
        return typeOfDisplaySubtitle.SHORTNAME;
    }

    private boolean isArgsValid(String[] args) {
        return args.length >= 3;
    }

    private boolean validateAllowedEntity(String entity) {
        return EntityConstant.ALLOWED_ENTITY.valueOf(entity) != null;
    }

    private static enum typeOfDisplaySubtitle {
        NOTIME,
        SHORTNAME,
        TIME;

    }
}

