/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.commands;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.helpers.PlayerHelper;
import com.vi2k.ghastthekiller.managers.BoardManager;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UpdateBoard
implements CommandExecutor {
    private GhastTheKiller plugin;
    private BoardManager boardManager;

    public UpdateBoard(GhastTheKiller plugin) {
        this.plugin = plugin;
        this.boardManager = this.plugin.getBoardManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            if (args.length != 6) {
                sender.sendMessage("You must provide 6 arguments");
                return false;
            }
            try {
                UUID playerUUID = UUID.fromString(args[0]);
                Integer goals = Integer.parseInt(args[1]);
                Integer maxGoals = Integer.parseInt(args[2]);
                Integer wins = Integer.parseInt(args[3]);
                Integer maxWins = Integer.parseInt(args[4]);
                Integer numberOfEnemy = Integer.parseInt(args[5]);
                Player player = PlayerHelper.getPlayerByUUID(playerUUID);
                if (!PlayerHelper.isValidPlayer(player)) {
                    sender.sendMessage("You must provide valid player name");
                    return false;
                }
                this.boardManager.updateScoreboard(player, goals, maxGoals, wins, maxWins, numberOfEnemy);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("You must provide valid argument(s)");
                return false;
            }
        }
        return true;
    }
}

