/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.events;

import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityListener
implements Listener {
    @EventHandler
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Entity entity = event.getEntity();
        if (damager instanceof Fireball && !(entity instanceof Player)) {
            event.setCancelled(true);
        }
        if (event.getDamager() instanceof Ravager && event.getEntity() instanceof Player) {
            double originalDamage = event.getDamage();
            double reducedDamage = originalDamage * 0.3;
            event.setDamage(reducedDamage);
        }
    }

    @EventHandler
    public void onEntityExplode(ExplosionPrimeEvent event) {
        if (event.getEntity() instanceof Fireball) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityDamageEvent(EntityDamageEvent event) {
        if ((event.getEntityType().equals((Object)EntityType.ZOMBIE) || event.getEntityType().equals((Object)EntityType.SKELETON) || event.getEntityType().equals((Object)EntityType.BLAZE)) && event.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE)) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        if (event.getEntity() instanceof Zombie || event.getEntity() instanceof Skeleton || event.getEntity() instanceof Blaze) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.getEntity() instanceof Mob && !(event.getTarget() instanceof Player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityExplodeEvent(EntityExplodeEvent e) {
        Iterator iterator = e.blockList().iterator();
        if (iterator.hasNext()) {
            Block b = (Block)iterator.next();
            Location loc = b.getLocation();
            e.setCancelled(true);
            e.getLocation().getWorld().spawnParticle(Particle.EXPLOSION_HUGE, loc, 0);
            e.getLocation().getWorld().playSound(e.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
            for (Player p : e.getLocation().getWorld().getPlayers()) {
                if (!(p.getLocation().distance(loc) <= 5.0)) continue;
                p.setVelocity(p.getLocation().toVector().subtract(loc.toVector()).multiply(5));
            }
            return;
        }
    }
}

