/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.events;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.helpers.RandomHelper;
import com.vi2k.ghastthekiller.helpers.TimeHelper;
import com.vi2k.ghastthekiller.managers.RandomChestManager;
import com.vi2k.ghastthekiller.models.chest.ChestData;
import com.vi2k.ghastthekiller.models.settings.RandomChest;
import com.vi2k.ghastthekiller.settings.GhastTheKillerSettings;
import com.vi2k.ghastthekiller.utils.ArrayUtil;
import com.vi2k.ghastthekiller.utils.ChestUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryListener
implements Listener {
    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Inventory inventory = event.getInventory();
        GhastTheKiller plugin = GhastTheKiller.getInstance();
        RandomChestManager randomChestManager = plugin.getRandomChestManager();
        if (inventory.getType().toString().equalsIgnoreCase("chest") || inventory.getType().toString().equalsIgnoreCase("trapped_chest")) {
            String chestIdentifier = inventory.getLocation().toString();
            for (ChestData openedChest : randomChestManager.getOpenedChests()) {
                if (!openedChest.getChestIdentifier().equalsIgnoreCase(chestIdentifier)) continue;
                Integer unixTimeOfChest = openedChest.getLastCheckOpenTime();
                Integer currentTime = TimeHelper.getUnixTimestamp();
                Integer difference = currentTime - unixTimeOfChest;
                if (difference > openedChest.getResetTime()) {
                    ArrayList<ChestData> newChestData = randomChestManager.getOpenedChests();
                    newChestData.remove(openedChest);
                    randomChestManager.setOpenedChests(newChestData);
                    break;
                }
                inventory.clear();
                for (ItemStack itemStack : openedChest.getItems()) {
                    if (itemStack == null) continue;
                    inventory.addItem(new ItemStack[]{itemStack});
                }
                return;
            }
            RandomChest[] randomChest = GhastTheKillerSettings.getInstance().getRandomChests();
            inventory.clear();
            Material chestType = inventory.getType().toString().equalsIgnoreCase("trapped_chest") ? Material.TRAPPED_CHEST : Material.CHEST;
            RandomChest chest = ChestUtil.getRandomChestByChestType(randomChest, chestType);
            Integer min = chest.getMin();
            Integer max = chest.getMax();
            Integer random = RandomHelper.randomInt(min, max);
            ArrayList<String> items = chest.getItems();
            ArrayUtil.shuffleArrayList(items);
            for (int i = 0; i < random; ++i) {
                ItemStack itemStack = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)items.get(i))));
                inventory.addItem(new ItemStack[]{itemStack});
            }
            ChestData chestData = new ChestData(chestIdentifier, TimeHelper.getUnixTimestamp(), inventory.getContents(), chest.getResetTime());
            randomChestManager.addOpenedChests(chestData);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getClickedInventory();
        GhastTheKiller plugin = GhastTheKiller.getInstance();
        RandomChestManager randomChestManager = plugin.getRandomChestManager();
        ItemStack clickedItem = event.getCurrentItem();
        if (inventory == null || clickedItem == null) {
            return;
        }
        if (inventory.getType().toString().equalsIgnoreCase("chest") || inventory.getType().toString().equalsIgnoreCase("trapped_chest")) {
            String chestIdentifier = inventory.getLocation().toString();
            for (ChestData openedChest : randomChestManager.getOpenedChests()) {
                if (!openedChest.getChestIdentifier().equalsIgnoreCase(chestIdentifier)) continue;
                ChestData chestData = openedChest;
                chestData.setLastCheckOpenTime(TimeHelper.getUnixTimestamp());
                chestData.setItems(inventory.getContents());
                ArrayList<ChestData> newChestData = randomChestManager.getOpenedChests();
                newChestData.remove(openedChest);
                newChestData.add(chestData);
                randomChestManager.setOpenedChests(newChestData);
                return;
            }
        }
    }
}

