/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.events;

import com.vi2k.ghastthekiller.models.settings.MinecartHitDamage;
import com.vi2k.ghastthekiller.models.settings.SoundSetting;
import com.vi2k.ghastthekiller.settings.GhastTheKillerSettings;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;

public class VehicleListener
implements Listener {
    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)event.getVehicle();
        Material materialUnderMinecart = minecart.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType();
        if (materialUnderMinecart == Material.RAIL) {
            minecart.setMaxSpeed(GhastTheKillerSettings.getInstance().getMinecartSpeed().doubleValue());
            Vector velocity = minecart.getVelocity();
            velocity.multiply(GhastTheKillerSettings.getInstance().getMinecartSpeed().doubleValue());
            minecart.setVelocity(velocity);
        }
    }

    @EventHandler
    public void onVehicleEntityCollisionEvent(VehicleEntityCollisionEvent event) {
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        try {
            Minecart minecart = (Minecart)event.getVehicle();
            Entity minecartDriver = null;
            for (Entity nearByEntity : minecart.getNearbyEntities(0.5, 0.5, 0.5)) {
                if (nearByEntity.getVehicle() == null || !(nearByEntity.getVehicle() instanceof Minecart)) continue;
                minecartDriver = nearByEntity;
            }
            if (minecartDriver == null) {
                return;
            }
            for (Entity nearByEntity : minecart.getNearbyEntities(0.1, 0.1, 0.1)) {
                MinecartHitDamage[] minecartHitDamagesConf;
                if (!(nearByEntity instanceof Player)) continue;
                Player player = (Player)nearByEntity;
                VehicleListener.pushPlayerBehindOnCollision(minecart, player);
                for (MinecartHitDamage minecartHitDamage : minecartHitDamagesConf = GhastTheKillerSettings.getInstance().getMinecartHitDamages()) {
                    if (minecartDriver.getType() != minecartHitDamage.getEntityType() && minecartHitDamage.getEntityType() != null) continue;
                    player.damage(minecartHitDamage.getDamage().doubleValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setCancelled(true);
    }

    public static void pushPlayerBehindOnCollision(Minecart minecart, Player player) {
        Location collisionLoc = minecart.getLocation();
        Vector toPlayer = player.getLocation().subtract(collisionLoc).toVector().normalize();
        Vector direction = minecart.getVelocity().normalize();
        if (direction.dot(toPlayer) > 0.0) {
            player.setVelocity(direction.multiply(GhastTheKillerSettings.getInstance().getMinecartHitSpeedFactor().doubleValue()));
            SoundSetting minecartHitSoundSetting = GhastTheKillerSettings.getInstance().getMinecartHitSound();
            float volume = (float)minecartHitSoundSetting.getVolume().doubleValue();
            float pitch = (float)minecartHitSoundSetting.getPitch().doubleValue();
            collisionLoc.getWorld().playSound(collisionLoc, minecartHitSoundSetting.getSoundID(), volume, pitch);
        }
    }
}

