/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.managers;

import com.vi2k.ghastthekiller.helpers.TimeHelper;
import com.vi2k.ghastthekiller.models.actionbar.ActionBarMessage;
import java.util.ArrayDeque;
import java.util.Deque;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class ActionBarManager {
    private ArrayDeque<ActionBarMessage> pendingMessages;
    private ActionBarMessage currentMessage;

    public ActionBarManager() {
        this.pendingMessages = new ArrayDeque();
        this.currentMessage = null;
    }

    public ActionBarManager(ArrayDeque<ActionBarMessage> pendingMessages, ActionBarMessage currentMessage) {
        this.pendingMessages = pendingMessages;
        this.currentMessage = currentMessage;
    }

    public Deque<ActionBarMessage> getPendingMessages() {
        return this.pendingMessages;
    }

    public void addMessage(Player player, Component message, Integer duration) {
        ActionBarMessage actionBarMessage = new ActionBarMessage(player, message, duration);
        this.pendingMessages.add(actionBarMessage);
    }

    public ActionBarMessage pollMessage() {
        return this.pendingMessages.poll();
    }

    public void clearPendingMessages() {
        this.pendingMessages.clear();
    }

    public void clearCurrentMessage() {
        this.currentMessage = null;
    }

    public Integer getPendingMessagesSize() {
        return this.pendingMessages.size();
    }

    public void clearAll() {
        this.clearPendingMessages();
        this.clearCurrentMessage();
    }

    public void action() {
        if (this.currentMessage == null) {
            if (this.getPendingMessagesSize() > 0) {
                ActionBarMessage actionBarMessage;
                this.currentMessage = actionBarMessage = this.pollMessage();
            }
        } else {
            Integer duration = this.currentMessage.getDuration();
            Integer unixTimestamp = this.currentMessage.getUnixTimestamp();
            Integer currentUnixTimestamp = TimeHelper.getUnixTimestamp();
            if (currentUnixTimestamp - unixTimestamp >= duration) {
                this.currentMessage = null;
            } else {
                Player player = this.currentMessage.getPlayer();
                Component message = this.currentMessage.getMessage();
                player.sendActionBar(message);
            }
        }
    }
}

