/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.managers;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.constants.LocationConstant;
import com.vi2k.ghastthekiller.helpers.MathHelper;
import com.vi2k.ghastthekiller.helpers.PlayerHelper;
import com.vi2k.ghastthekiller.interfaces.OnInitializedCb;
import com.vi2k.ghastthekiller.settings.GhastTheKillerSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class BetterBypassManager {
    private GhastTheKiller plugin;
    private World jeWorld;
    private int[] ticks = new int[]{0};
    private double[] newMaxY = new double[]{0.0};
    private double[] newMinY = new double[]{0.0};
    private Map<FallingBlock, BlockData> originalBlockData = new HashMap<FallingBlock, BlockData>();
    private Map<String, Map<Material, Location>> originalBlockLocations = new HashMap<String, Map<Material, Location>>();
    private Map<FallingBlock, Double> biases = new HashMap<FallingBlock, Double>();
    private Map<String, Map<Location, Double>> fallingBlockLocations = new HashMap<String, Map<Location, Double>>();
    private LocationConstant jeLocationConstConstant = new LocationConstant();
    private MathHelper mathHelper = new MathHelper();
    private PlayerHelper playerHelper = new PlayerHelper();

    public BetterBypassManager(GhastTheKiller plugin) {
        this.plugin = plugin;
        this.jeWorld = this.plugin.getWorld();
    }

    public void action() {
        BetterBypassManager betterBypassManager = this;
        if (betterBypassManager.playerHelper.isServerEmpty()) {
            return;
        }
        Location hideLoc = new Location(this.jeWorld, 0.0, 0.0, 0.0);
        for (FallingBlock fallingBlock : this.originalBlockData.keySet()) {
            fallingBlock.setTicksLived(1);
            Location blockLoc = fallingBlock.getLocation();
            String fallingBlockId = fallingBlock.getUniqueId().toString();
            Map<Location, Double> blockLocations = this.fallingBlockLocations.get(fallingBlockId);
            if (blockLocations != null) {
                blockLoc = blockLocations.keySet().iterator().next();
            }
            BoundingBox blockBoundingBox = new BoundingBox(blockLoc.getX() - 0.7, blockLoc.getY() + 0.0, blockLoc.getZ() - 0.7, blockLoc.getX() + 0.7, blockLoc.getY() + 2.0, blockLoc.getZ() + 0.7);
            double bias = this.biases.get(fallingBlock);
            double speedFactor = GhastTheKillerSettings.getInstance().getHarderBypassSpeedFactor();
            double newY = Math.sin(((double)this.ticks[0] * speedFactor % 62.83185307179586 + bias - 1.5707963267948966) / 10.0) * 0.32 / 2.0;
            if (newY > this.newMaxY[0]) {
                this.newMaxY[0] = newY;
            }
            if (newY < this.newMinY[0]) {
                this.newMinY[0] = newY;
            }
            Location blockLocNow = blockLoc.clone().add(0.0, 0.0, 0.0);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (blockBoundingBox.overlaps(player.getBoundingBox())) {
                    if (this.fallingBlockLocations.containsKey(fallingBlockId)) continue;
                    if (blockLocNow.getY() % 1.0 != 0.0 && blockLocNow.getY() - (double)NumberConversions.floor((double)blockLocNow.getY()) > 0.5) {
                        if (blockLocNow.getY() > player.getLocation().getY()) {
                            blockLocNow.setY((double)NumberConversions.floor((double)player.getLocation().getY()));
                        } else {
                            blockLocNow.setY((double)(NumberConversions.floor((double)blockLocNow.getY()) + 1));
                        }
                    }
                    blockLocations = new HashMap<Location, Double>();
                    Block block = this.jeWorld.getBlockAt(blockLocNow);
                    fallingBlock.teleport(hideLoc);
                    block.setType(this.getConfigMaterial(fallingBlock.getBlockData().getMaterial()));
                    Location newBlockLoc = block.getLocation();
                    fallingBlock.setVelocity(new Vector(0, 0, 0));
                    blockLocations.put(newBlockLoc, newY);
                    this.fallingBlockLocations.put(fallingBlockId, blockLocations);
                    continue;
                }
                if (this.fallingBlockLocations.containsKey(fallingBlockId)) {
                    if (MathHelper.isDecimalPlaceGreaterThan(newY, 3, this.newMaxY[0])) {
                        Block block;
                        Location blockLocationP = this.fallingBlockLocations.get(fallingBlockId).keySet().iterator().next();
                        if (blockLocationP.getY() % 1.0 != 0.0) {
                            int blockNewY = NumberConversions.floor((double)blockLocationP.getY()) + 1;
                            blockLocationP.setY((double)blockNewY);
                        }
                        if (this.isMaterialInConfig((block = this.jeWorld.getBlockAt(blockLocationP)).getType())) {
                            block.setType(Material.AIR);
                        }
                        Map<Material, Location> originalBlockLocation = this.originalBlockLocations.get(fallingBlockId);
                        for (Map.Entry<Material, Location> entry : originalBlockLocation.entrySet()) {
                            Location location = entry.getValue();
                            fallingBlock.teleport(location);
                            fallingBlock.setVelocity(new Vector(0.0, newY, 0.0));
                            this.fallingBlockLocations.remove(fallingBlockId);
                        }
                        continue;
                    }
                }
                fallingBlock.setVelocity(new Vector(0.0, newY, 0.0));
            }
        }
        this.ticks[0] = this.ticks[0] + 1;
    }

    public void init(OnInitializedCb onInitializedCb) {
        int x = -292;
        while (true) {
            if (x > -273) break;
            int y = -51;
            while (true) {
                if (y > 303) break;
                int z = 232;
                while (true) {
                    if (z > 251) break;
                    Block block = this.jeWorld.getBlockAt(x, y, z);
                    Material blockMaterial = this.getConfigMaterial(block.getType());
                    if (block.getType() != Material.AIR && blockMaterial != null) {
                        Location blockLoc = block.getLocation();
                        BlockData blockData = block.getBlockData();
                        block.setType(Material.AIR);
                        FallingBlock fallingBlock = this.jeWorld.spawnFallingBlock(blockLoc.add(0.5, 0.0, 0.5), blockMaterial.createBlockData());
                        HashMap<Material, Location> blockLocations = new HashMap<Material, Location>();
                        blockLocations.put(blockMaterial, blockLoc);
                        this.originalBlockLocations.put(fallingBlock.getUniqueId().toString(), blockLocations);
                        fallingBlock.setGravity(false);
                        this.originalBlockData.put(fallingBlock, blockData);
                        this.biases.put(fallingBlock, Math.random() * 2.0 * Math.PI);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        onInitializedCb.onInitialized();
    }

    public void resetState() {
        for (Map.Entry<FallingBlock, BlockData> entry : this.originalBlockData.entrySet()) {
            FallingBlock fallingBlock = entry.getKey();
            fallingBlock.remove();
        }
        int x = -292;
        while (true) {
            if (x > -273) break;
            int y = -51;
            while (true) {
                if (y > 303) break;
                int z = 232;
                while (true) {
                    if (z > 251) break;
                    Block block = this.jeWorld.getBlockAt(x, y, z);
                    if (this.isMaterialInConfig(block.getBlockData().getMaterial())) {
                        block.setType(Material.AIR);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        for (Map.Entry<String, Map<Material, Location>> entry : this.originalBlockLocations.entrySet()) {
            for (Map.Entry<Material, Location> innerEntry : entry.getValue().entrySet()) {
                Material blockType = innerEntry.getKey();
                Location location = innerEntry.getValue();
                Block block = this.jeWorld.getBlockAt(location);
                block.setType(blockType);
            }
        }
    }

    private Material getConfigMaterial(Material material) {
        if (material == null) {
            return null;
        }
        ArrayList<String> configBlocks = GhastTheKillerSettings.getInstance().getHarderBypassBlocks();
        for (String configBlock : configBlocks) {
            if (!material.name().equalsIgnoreCase(configBlock)) continue;
            return Material.valueOf((String)configBlock);
        }
        return null;
    }

    private boolean isMaterialInConfig(Material material) {
        return GhastTheKillerSettings.getInstance().getHarderBypassBlocks().contains(material.name());
    }
}

