/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.managers;

import com.vi2k.ghastthekiller.settings.GhastTheKillerSettings;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class BoardManager {
    public void updateScoreboard(Player player, int goal, int maxGoal, int win, int maxWin, int enemyCount) {
        Scoreboard scoreboard;
        boolean isScoreboardExist = player.getScoreboard() != null && player.getScoreboard().getObjective("ghastthekiller") != null;
        ChatColor whiteColor = ChatColor.WHITE;
        ChatColor redColor = ChatColor.RED;
        ChatColor grayColor = ChatColor.GRAY;
        if (!isScoreboardExist) {
            Integer startScore;
            scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            TextComponent displayName = Component.text((String)"Ghast The Killer", (TextColor)NamedTextColor.RED);
            Criteria criteria = Criteria.create((String)"dummy");
            Objective objective = scoreboard.registerNewObjective("ghastthekiller", criteria, (Component)displayName);
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
            Team goalTeam = scoreboard.registerNewTeam("goalTeam");
            String teamKey = whiteColor.toString();
            goalTeam.addEntry(teamKey);
            Team winTeam = scoreboard.registerNewTeam("winTeam");
            String winTeamKey = redColor.toString();
            Team enemyTeam = scoreboard.registerNewTeam("enemyTeam");
            String enemyTeamKey = grayColor.toString();
            TextComponent prefix = Component.text((String)(grayColor + "\u00bb" + redColor + " Goal: " + whiteColor + goal), (TextColor)NamedTextColor.RED);
            TextComponent suffix = Component.text((String)(" / " + maxGoal), (TextColor)NamedTextColor.WHITE);
            goalTeam.prefix((Component)prefix);
            goalTeam.suffix((Component)suffix);
            winTeam.addEntry(winTeamKey);
            TextComponent winPrefix = Component.text((String)(grayColor + "\u00bb" + redColor + " Win: " + whiteColor + win), (TextColor)NamedTextColor.RED);
            TextComponent winSuffix = Component.text((String)(" / " + maxWin), (TextColor)NamedTextColor.WHITE);
            winTeam.prefix((Component)winPrefix);
            winTeam.suffix((Component)winSuffix);
            enemyTeam.addEntry(enemyTeamKey);
            TextComponent enemyPrefix = Component.text((String)(grayColor + "\u00bb" + redColor + " Enemy: "), (TextColor)NamedTextColor.RED);
            TextComponent enemySuffix = Component.text((String)("" + enemyCount), (TextColor)NamedTextColor.WHITE);
            enemyTeam.prefix((Component)enemyPrefix);
            enemyTeam.suffix((Component)enemySuffix);
            Component displayNameObjective = ((TextComponent)Component.text((String)"-- ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"Status Board", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)" --", (TextColor)NamedTextColor.GRAY));
            objective.displayName(displayNameObjective);
            Integer n = startScore = Integer.valueOf(GhastTheKillerSettings.getInstance().getHidePluginCreator() != false ? 4 : 6);
            startScore = startScore - 1;
            objective.getScore(whiteColor + " ").setScore(n.intValue());
            n = startScore;
            startScore = startScore - 1;
            objective.getScore(teamKey).setScore(n.intValue());
            n = startScore;
            startScore = startScore - 1;
            objective.getScore(winTeamKey).setScore(n.intValue());
            n = startScore;
            startScore = startScore - 1;
            objective.getScore(enemyTeamKey).setScore(n.intValue());
            n = startScore;
            startScore = startScore - 1;
            objective.getScore(" ").setScore(n.intValue());
            if (!GhastTheKillerSettings.getInstance().getHidePluginCreator().booleanValue()) {
                n = startScore;
                startScore = startScore - 1;
                objective.getScore(grayColor + "Plugin dev by").setScore(n.intValue());
                n = startScore;
                startScore = startScore - 1;
                objective.getScore(redColor + "@lesongvi").setScore(n.intValue());
            }
        } else {
            scoreboard = player.getScoreboard();
            Team goalTeam = scoreboard.getTeam("goalTeam");
            TextComponent prefix = Component.text((String)(grayColor + "\u00bb" + redColor + " Goal: " + whiteColor + goal), (TextColor)NamedTextColor.RED);
            goalTeam.prefix((Component)prefix);
            Team winTeam = scoreboard.getTeam("winTeam");
            TextComponent winPrefix = Component.text((String)(grayColor + "\u00bb" + redColor + " Win: " + whiteColor + win), (TextColor)NamedTextColor.RED);
            winTeam.prefix((Component)winPrefix);
            Team enemyTeam = scoreboard.getTeam("enemyTeam");
            TextComponent enemySuffix = Component.text((String)("" + enemyCount), (TextColor)NamedTextColor.WHITE);
            enemyTeam.suffix((Component)enemySuffix);
        }
        player.setScoreboard(scoreboard);
    }

    public void setBoardState(int state, Player player) {
        Scoreboard scoreboard = player.getScoreboard();
        Objective objective = scoreboard.getObjective("ghastthekiller");
        if (state == 0) {
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        } else if (state == 1) {
            objective.setDisplaySlot(DisplaySlot.PLAYER_LIST);
        } else if (state == 2) {
            objective.setDisplaySlot(DisplaySlot.BELOW_NAME);
        } else if (state == 3) {
            player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        }
    }
}

