/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.managers;

import com.vi2k.ghastthekiller.constants.EntityConstant;
import com.vi2k.ghastthekiller.helpers.TimeHelper;
import com.vi2k.ghastthekiller.models.GhastTheKillerMetadata;
import com.vi2k.ghastthekiller.models.OnBoardingEnemyEntity;
import com.vi2k.ghastthekiller.utils.CornerBossUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.Mob;
import org.bukkit.entity.SmallFireball;
import org.bukkit.util.Vector;

public class OnboardingEnemyEntityManager {
    private ArrayDeque<GhastTheKillerMetadata> enemyEntityMetadataQueue = new ArrayDeque();
    private TimeHelper timeHelper = new TimeHelper();
    private HashMap<EntityConstant.ALLOWED_ENTITY, OnBoardingEnemyEntity> onBoardingEnemyEntities = new HashMap<EntityConstant.ALLOWED_ENTITY, OnBoardingEnemyEntity>(){
        {
            this.put(EntityConstant.ALLOWED_ENTITY.PHANTOM, new OnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY.PHANTOM));
            this.put(EntityConstant.ALLOWED_ENTITY.VEX, new OnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY.VEX));
            this.put(EntityConstant.ALLOWED_ENTITY.WITHER, new OnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY.WITHER));
            this.put(EntityConstant.ALLOWED_ENTITY.GHAST, new OnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY.GHAST));
            this.put(EntityConstant.ALLOWED_ENTITY.BLAZE, new OnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY.BLAZE));
            this.put(EntityConstant.ALLOWED_ENTITY.ELDER_GUARDIAN, new OnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY.ELDER_GUARDIAN));
        }
    };

    public void action() {
        boolean isBlazeOnBoarding;
        boolean isGhastOnBoarding = this.onBoardingEnemyEntities.get((Object)EntityConstant.ALLOWED_ENTITY.GHAST).getQuantity() > 0;
        boolean bl = isBlazeOnBoarding = this.onBoardingEnemyEntities.get((Object)EntityConstant.ALLOWED_ENTITY.BLAZE).getQuantity() > 0;
        if (isGhastOnBoarding) {
            this.setFireballSpeed(LargeFireball.class, Ghast.class);
        }
        if (isBlazeOnBoarding) {
            this.setFireballSpeed(SmallFireball.class, Blaze.class);
        }
        for (OnBoardingEnemyEntity onBoardingEnemyEntity : this.onBoardingEnemyEntities.values()) {
            for (UUID entityUUID : onBoardingEnemyEntity.getEntityUUIDs().keySet()) {
                Mob mob = (Mob)Bukkit.getEntity((UUID)entityUUID);
                if (mob == null || mob.getType() == EntityType.VEX || mob.getType() == EntityType.PHANTOM) continue;
                Entity target = onBoardingEnemyEntity.getEntityUUIDs().get(entityUUID).getTarget();
                if (target == null) {
                    return;
                }
                if (target.isDead()) {
                    mob.setVelocity(new Vector(0, 0, 0));
                    return;
                }
                Integer targetY = target.getLocation().getBlockY() + 5;
                double currentX = mob.getLocation().getX();
                double currentY = mob.getLocation().getY();
                double currentZ = mob.getLocation().getZ();
                double newX = 0.0;
                double newY = 0.0;
                double newZ = 0.0;
                if (mob.getType() == EntityType.ELDER_GUARDIAN) {
                    mob.setVelocity(new Vector(0, 0, 0));
                    ArrayList<Mob> cornerBosses = CornerBossUtil.getNearbyCornerBosses(mob);
                    for (Mob cornerBoss : cornerBosses) {
                        if (cornerBoss.getUniqueId() == mob.getUniqueId()) continue;
                        cornerBoss.setVelocity(new Vector(0, 0, 0));
                    }
                    return;
                }
                if (mob.getType() == EntityType.GHAST) {
                    if (currentX > -262.0) {
                        newX = -1.0;
                    } else if (currentX < -303.0) {
                        newX = 1.0;
                    } else if (currentZ > 261.0) {
                        newZ = -1.0;
                    } else if (currentZ < 222.0) {
                        newZ = 1.0;
                    }
                }
                if (currentY > (double)targetY.intValue() || currentY > 307.0) {
                    newY = -1.0;
                } else if (currentY < (double)targetY.intValue()) {
                    newY = 1.0;
                }
                mob.setVelocity(new Vector(newX * 0.1, newY * 0.1, newZ * 0.1));
            }
        }
    }

    private <T extends Fireball, S extends Entity> void setFireballSpeed(Class<T> fireballClass, Class<S> shooterClass) {
        World world = Bukkit.getWorld((String)"pixel");
        Double fireballSpeed = 1.7;
        world.getEntitiesByClass(fireballClass).forEach(fireball -> {
            if (shooterClass.isInstance(fireball.getShooter())) {
                if (fireball.getVelocity().length() > 1.0) {
                    return;
                }
                Vector velocity = fireball.getVelocity();
                velocity.multiply(fireballSpeed.doubleValue());
                fireball.setVelocity(velocity);
                Location location = fireball.getLocation();
                Fireball[] fireballs = new Fireball[4];
                double[] rotations = new double[]{1.5707963267948966, 1.5707963267948966, -1.5707963267948966, -1.5707963267948966};
                boolean[] rotateAroundX = new boolean[]{true, false, false, true};
                for (int i = 0; i < fireballs.length; ++i) {
                    fireballs[i] = (Fireball)fireball.getWorld().spawn(location, fireballClass);
                    if (rotateAroundX[i]) {
                        fireballs[i].setVelocity(velocity.rotateAroundX(rotations[i]));
                    } else {
                        fireballs[i].setVelocity(velocity.rotateAroundY(rotations[i]));
                    }
                    fireballs[i].setVelocity(fireballs[i].getVelocity().multiply(fireballSpeed.doubleValue()));
                }
            }
        });
    }

    public Integer getOnBoardingEnemyEntityQuantity(EntityConstant.ALLOWED_ENTITY entity) {
        return this.onBoardingEnemyEntities.get((Object)entity).getQuantity();
    }

    public boolean isGhastMetadataQueueEmpty() {
        return this.enemyEntityMetadataQueue.isEmpty();
    }

    public void setEnemyEntityMetadataQueue(ArrayDeque<GhastTheKillerMetadata> enemyEntityMetadataQueue) {
        this.enemyEntityMetadataQueue = enemyEntityMetadataQueue;
    }

    public ArrayDeque<GhastTheKillerMetadata> getEnemyEntityMetadataQueue() {
        return new ArrayDeque<GhastTheKillerMetadata>(this.enemyEntityMetadataQueue);
    }

    public void addEnemyEntityMetadataToQueue(GhastTheKillerMetadata ghastMetadata) {
        this.enemyEntityMetadataQueue.add(ghastMetadata);
    }

    public void addOnBoardingEnemyEntityQuantity(EntityConstant.ALLOWED_ENTITY entity, UUID entityUUID, Entity target) {
        OnboardingEnemyEntityManager onboardingEnemyEntityManager = this;
        this.onBoardingEnemyEntities.get((Object)entity).addEntityUUID(entityUUID, onboardingEnemyEntityManager.timeHelper.getUnixTimestamp(), target);
    }

    public void removeEntityFromOnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY entity, UUID entityUUID) {
        this.onBoardingEnemyEntities.get((Object)entity).removeEntityUUID(entityUUID);
    }

    public OnBoardingEnemyEntity getOnBoardingEnemyEntity(EntityConstant.ALLOWED_ENTITY entity) {
        return this.onBoardingEnemyEntities.get((Object)entity);
    }

    public GhastTheKillerMetadata dequeueFirstEnemyEntityMetadata() {
        GhastTheKillerMetadata firstMetadata = this.enemyEntityMetadataQueue.getFirst();
        this.enemyEntityMetadataQueue.removeFirst();
        return firstMetadata;
    }

    public boolean isMaxQuantityReached(EntityConstant.ALLOWED_ENTITY entity) {
        return this.onBoardingEnemyEntities.get((Object)entity).getQuantity() >= EntityConstant.ALLOWED_ENTITY_INTEGER_ARRAY_HASH_MAP.get((Object)entity)[0];
    }

    public Integer getConfiguredSpawnTime(EntityConstant.ALLOWED_ENTITY entity) {
        return EntityConstant.ALLOWED_ENTITY_INTEGER_ARRAY_HASH_MAP.get((Object)entity)[1];
    }

    public boolean isThereNoEntityOnBoarding() {
        for (OnBoardingEnemyEntity onBoardingEnemyEntity : this.onBoardingEnemyEntities.values()) {
            if (onBoardingEnemyEntity.getQuantity() <= 0) continue;
            return false;
        }
        return true;
    }

    public Integer getGhastMetadataQueueSize() {
        return this.enemyEntityMetadataQueue.size();
    }
}

