/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.managers;

import com.vi2k.ghastthekiller.DTOs.PluginVersionManagerDTO;
import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.constants.VersionConstant;
import com.vi2k.ghastthekiller.managers.VersionManager;
import com.vi2k.ghastthekiller.mappers.PluginVersionManagerMapper;
import com.vi2k.ghastthekiller.models.versionmanager.PluginUpgradeDetail;
import com.vi2k.ghastthekiller.utils.HttpUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PluginVersionManager
extends VersionManager {
    private PluginUpgradeDetail pluginUpgradeDetail;
    private GhastTheKiller plugin;
    private PluginVersionManagerMapper pluginVersionManagerMapper;

    public PluginVersionManager(GhastTheKiller plugin) {
        this.plugin = plugin;
        this.pluginUpgradeDetail = new PluginUpgradeDetail();
        this.pluginUpgradeDetail.setCurrentVersion("1.0.3");
        this.pluginVersionManagerMapper = new PluginVersionManagerMapper();
    }

    @Override
    public String checkVersion() {
        if (this.pluginUpgradeDetail != null && this.pluginUpgradeDetail.getLatestVersion() != null) {
            return this.pluginUpgradeDetail.getLatestVersion();
        }
        try {
            PluginVersionManagerDTO pluginVersionManagerDTO = this.requestVersionManagerData();
            if (pluginVersionManagerDTO == null) {
                return null;
            }
            this.pluginUpgradeDetail = this.pluginVersionManagerMapper.mapToPluginUpgradeDetail(pluginVersionManagerDTO, "1.0.3");
            return this.pluginUpgradeDetail.getLatestVersion();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PluginVersionManagerDTO requestVersionManagerData() throws URISyntaxException, IOException {
        String requestUrl = VersionConstant.PLUGIN_VERSION_MANAGER_URL;
        String userAgent = "GhastTheKiller/1.0.3";
        if (!this.isVersionManagerOfVi2kHost(requestUrl)) {
            this.plugin.getLogger().warning("The version manager is not from vi2k.com. If you get any errors due to this, know that we are not responsible for it.");
        }
        String content = HttpUtils.sendGetRequest(requestUrl, userAgent);
        PluginVersionManagerDTO pluginVersionManagerDTO = new PluginVersionManagerDTO();
        if ((pluginVersionManagerDTO = pluginVersionManagerDTO.bind(content)) == null) {
            throw new IOException("Failed to parse version manager data.");
        }
        return pluginVersionManagerDTO;
    }

    public boolean initialize() {
        String latestVersion = this.checkVersion();
        if (latestVersion != null) {
            if (this.pluginUpgradeDetail.isUpdateRequired()) {
                this.plugin.getLogger().info("GhastTheKillerPlugin is disabled because it is outdated with minimum required version " + this.pluginUpgradeDetail.getMinRequiredVersion() + "! You must update to version " + latestVersion);
                TextReplacementConfig pluginDisabledDueToOutdatedVersion = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<MIN_REQUIRED_VERSION>").replacement((ComponentLike)Component.text((String)this.pluginUpgradeDetail.getMinRequiredVersion())).build();
                TextReplacementConfig pluginDisabledDueToOutdatedVersion2 = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<LATEST_VERSION>").replacement((ComponentLike)Component.text((String)latestVersion)).build();
                Component pluginDisabledMsg = VersionConstant.REPLACABLE_PLUGIN_DISABLED_MESSAGE.replaceText(pluginDisabledDueToOutdatedVersion).replaceText(pluginDisabledDueToOutdatedVersion2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.isOp()) continue;
                    player.sendMessage(pluginDisabledMsg);
                }
                return false;
            }
            if (this.pluginUpgradeDetail.isUpdateAvailable()) {
                this.plugin.getLogger().info("GhastTheKillerPlugin is outdated! Please update to version " + latestVersion);
                this.plugin.getLogger().info("Download: " + this.pluginUpgradeDetail.getDownloadUrl());
                this.plugin.getLogger().info("Update message: " + this.pluginUpgradeDetail.getUpdateWarningMessage());
                TextReplacementConfig pluginOutdated = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<LATEST_VERSION>").replacement((ComponentLike)Component.text((String)latestVersion)).build();
                TextReplacementConfig pluginDownloadLink = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<PLUGIN_DOWNLOAD_LINK>").replacement((ComponentLike)Component.text((String)this.pluginUpgradeDetail.getDownloadUrl())).build();
                TextReplacementConfig pluginDownloadLinkDisplayTxt = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<PLUGIN_DOWNLOAD_LINK_DISPLAY_TXT>").replacement((ComponentLike)Component.text((String)this.pluginUpgradeDetail.getDownloadUrl())).build();
                Component pluginOutdatedMsg = VersionConstant.REPLACABLE_PLUGIN_OUTDATED_MESSAGE.replaceText(pluginOutdated).replaceText(pluginDownloadLink).replaceText(pluginDownloadLinkDisplayTxt);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.isOp()) continue;
                    player.sendMessage(pluginOutdatedMsg);
                }
            } else {
                this.plugin.getLogger().info("GhastTheKillerPlugin is up-to-date!");
            }
        } else {
            this.plugin.getLogger().info("We cannot check for update. Please ensure you have internet connection. Using out-of-date version can cause unintended bugs. If you are sure that you are using the latest version, please ignore this message. If you are not sure, you should accept risk of using out-of-date version.");
        }
        return true;
    }

    public PluginUpgradeDetail getUpgradeDetail() {
        return this.pluginUpgradeDetail;
    }

    public void setUpgradeDetail(PluginUpgradeDetail pluginUpgradeDetail) {
        this.pluginUpgradeDetail = pluginUpgradeDetail;
    }
}

