/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.managers;

import com.vi2k.ghastthekiller.helpers.TimeHelper;
import com.vi2k.ghastthekiller.models.screentext.ScreenTextMessage;
import java.time.Duration;
import java.util.ArrayDeque;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.entity.Player;

public class ScreenTextManager {
    private ArrayDeque<ScreenTextMessage> pendingMessages;
    private ScreenTextMessage currentMessage;

    public ScreenTextManager() {
        this.pendingMessages = new ArrayDeque();
        this.currentMessage = null;
    }

    public ScreenTextManager(ArrayDeque<ScreenTextMessage> pendingMessages, ScreenTextMessage currentMessage) {
        this.pendingMessages = pendingMessages;
        this.currentMessage = currentMessage;
    }

    public ArrayDeque<ScreenTextMessage> getPendingMessages() {
        return this.pendingMessages;
    }

    public void addMessage(Player player, Component title, Component subtitle, Integer duration) {
        ScreenTextMessage actionBarMessage = new ScreenTextMessage(player, title, subtitle, duration);
        this.pendingMessages.add(actionBarMessage);
    }

    public ScreenTextMessage pollMessage() {
        return this.pendingMessages.poll();
    }

    public void clearPendingMessages() {
        this.pendingMessages.clear();
    }

    public void clearCurrentMessage() {
        this.currentMessage = null;
    }

    public Integer getPendingMessagesSize() {
        return this.pendingMessages.size();
    }

    public void clearAll() {
        this.clearPendingMessages();
        this.clearCurrentMessage();
    }

    public void action() {
        if (this.currentMessage == null) {
            if (this.getPendingMessagesSize() > 0) {
                ScreenTextMessage actionBarMessage;
                this.currentMessage = actionBarMessage = this.pollMessage();
            }
        } else {
            Integer duration = this.currentMessage.getDuration();
            Integer unixTimestamp = this.currentMessage.getUnixTimestamp();
            Integer currentUnixTimestamp = TimeHelper.getUnixTimestamp();
            if (currentUnixTimestamp - unixTimestamp >= duration) {
                this.currentMessage = null;
            } else {
                Player player = this.currentMessage.getPlayer();
                Title.Times times = Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(duration.intValue()), (Duration)Duration.ZERO);
                Title title = Title.title((Component)this.currentMessage.getTitle(), (Component)this.currentMessage.getSubtitle(), (Title.Times)times);
                player.showTitle(title);
            }
        }
    }
}

