/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.managers;

import com.vi2k.ghastthekiller.DTOs.SkriptVersionManagerDTO;
import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.constants.VersionConstant;
import com.vi2k.ghastthekiller.managers.VersionManager;
import com.vi2k.ghastthekiller.mappers.SkriptVersionManagerMapper;
import com.vi2k.ghastthekiller.models.versionmanager.SkriptUpgradeDetail;
import com.vi2k.ghastthekiller.utils.HttpUtils;
import java.io.IOException;
import java.net.URISyntaxException;

public class SkriptVersionManager
extends VersionManager {
    private SkriptUpgradeDetail skriptUpgradeDetail;
    private GhastTheKiller plugin;
    private SkriptVersionManagerMapper skriptVersionManagerMapper;

    public SkriptVersionManager(GhastTheKiller plugin, String yourCurrentVersion) {
        this.plugin = plugin;
        this.skriptUpgradeDetail = new SkriptUpgradeDetail();
        this.skriptUpgradeDetail.setYourCurrentVersion(yourCurrentVersion);
        this.skriptUpgradeDetail.setSkriptName("jump_escape");
        this.skriptVersionManagerMapper = new SkriptVersionManagerMapper();
    }

    @Override
    public String checkVersion() {
        if (this.skriptUpgradeDetail != null && this.skriptUpgradeDetail.getLatestVersion() != null) {
            return this.skriptUpgradeDetail.getLatestVersion();
        }
        try {
            SkriptVersionManagerDTO skriptVersionManagerDTO = this.requestVersionManagerData();
            if (skriptVersionManagerDTO == null) {
                return null;
            }
            this.skriptUpgradeDetail = this.skriptVersionManagerMapper.mapToSkriptUpgradeDetail(skriptVersionManagerDTO);
            return this.skriptUpgradeDetail.getLatestVersion();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SkriptVersionManagerDTO requestVersionManagerData() throws URISyntaxException, IOException {
        String requestUrl = VersionConstant.SKRIPT_VERSION_MANAGER_URL;
        String userAgent = "JESkript";
        if (!this.isVersionManagerOfVi2kHost(requestUrl = requestUrl.replace("<SKRIPT_NAME>", this.skriptUpgradeDetail.getSkriptName()).replace("<SKRIPT_VERSION>", this.skriptUpgradeDetail.getYourCurrentVersion()))) {
            this.plugin.getLogger().warning("Your version manager is not from vi2k.com. Currently, it's prohibited to use version manager from other hosts.! So we have to disable the GTK plugin.");
        }
        String content = HttpUtils.sendGetRequest(requestUrl, userAgent);
        SkriptVersionManagerDTO skriptVersionManagerDTO = new SkriptVersionManagerDTO();
        if ((skriptVersionManagerDTO = skriptVersionManagerDTO.bind(content)) == null) {
            throw new IOException("Failed to parse version manager data.");
        }
        return skriptVersionManagerDTO;
    }

    public SkriptUpgradeDetail getUpgradeDetail() {
        return this.skriptUpgradeDetail;
    }

    public void setUpgradeDetail(SkriptUpgradeDetail skriptUpgradeDetail) {
        this.skriptUpgradeDetail = skriptUpgradeDetail;
    }
}

