/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.models.versionmanager;

import com.vi2k.ghastthekiller.models.versionmanager.IUpgradeDetail;
import com.vi2k.ghastthekiller.models.versionmanager.VersionPart;

public class PluginUpgradeDetail
implements IUpgradeDetail {
    String currentVersion;
    String latestVersion;
    String downloadUrl;
    String releaseDate;
    String changeLog;
    String minRequiredVersion;
    String updateWarningMessage;

    public PluginUpgradeDetail() {
    }

    public PluginUpgradeDetail(String currentVersion, String latestVersion, String downloadUrl, String releaseDate, String changeLog, String minRequiredVersion, String updateWarningMessage) {
        this.currentVersion = currentVersion;
        this.latestVersion = latestVersion;
        this.downloadUrl = downloadUrl;
        this.releaseDate = releaseDate;
        this.changeLog = changeLog;
        this.minRequiredVersion = minRequiredVersion;
        this.updateWarningMessage = updateWarningMessage;
    }

    @Override
    public boolean isUpdateAvailable() {
        VersionPart currentVersionPart = new VersionPart(this.currentVersion);
        VersionPart latestVersionPart = new VersionPart(this.latestVersion);
        return latestVersionPart.isHigherThan(currentVersionPart.getVersion());
    }

    @Override
    public boolean isUpdateRequired() {
        VersionPart currentVersionPart = new VersionPart(this.currentVersion);
        VersionPart minRequiredVersionPart = new VersionPart(this.minRequiredVersion);
        return minRequiredVersionPart.isHigherThan(currentVersionPart.getVersion());
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public String getMinRequiredVersion() {
        return this.minRequiredVersion;
    }

    public String getUpdateWarningMessage() {
        return this.updateWarningMessage;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    public void setMinRequiredVersion(String minRequiredVersion) {
        this.minRequiredVersion = minRequiredVersion;
    }

    public void setUpdateWarningMessage(String updateWarningMessage) {
        this.updateWarningMessage = updateWarningMessage;
    }
}

