/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.models.versionmanager;

import com.vi2k.ghastthekiller.models.versionmanager.IUpgradeDetail;
import com.vi2k.ghastthekiller.models.versionmanager.VersionPart;

public class SkriptUpgradeDetail
implements IUpgradeDetail {
    private String skriptName;
    private String yourCurrentVersion;
    private String latestVersion;
    private String downloadLink;
    private String[] changeLog;
    private String error;
    private boolean updateAvailable;
    private String minimumVersion;
    private String updateWarning;

    public SkriptUpgradeDetail() {
    }

    public SkriptUpgradeDetail(String skriptName, String yourCurrentVersion, String latestVersion, String downloadLink, String[] changeLog, String error, boolean updateAvailable, String minimumVersion, String updateWarning) {
        this.skriptName = skriptName;
        this.yourCurrentVersion = yourCurrentVersion;
        this.latestVersion = latestVersion;
        this.downloadLink = downloadLink;
        this.changeLog = changeLog;
        this.error = error;
        this.updateAvailable = updateAvailable;
        this.minimumVersion = minimumVersion;
        this.updateWarning = updateWarning;
    }

    @Override
    public boolean isUpdateAvailable() {
        VersionPart currentVersionPart = new VersionPart(this.yourCurrentVersion);
        VersionPart latestVersionPart = new VersionPart(this.latestVersion);
        return latestVersionPart.isHigherThan(currentVersionPart.getVersion());
    }

    @Override
    public boolean isUpdateRequired() {
        VersionPart currentVersionPart = new VersionPart(this.yourCurrentVersion);
        VersionPart minRequiredVersionPart = new VersionPart(this.minimumVersion);
        return minRequiredVersionPart.isHigherThan(currentVersionPart.getVersion());
    }

    public String getSkriptName() {
        return this.skriptName;
    }

    public String getYourCurrentVersion() {
        return this.yourCurrentVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getDownloadLink() {
        return this.downloadLink;
    }

    public String[] getChangeLog() {
        return this.changeLog;
    }

    public String getError() {
        return this.error;
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    public String getUpdateWarning() {
        return this.updateWarning;
    }

    public void setSkriptName(String skriptName) {
        this.skriptName = skriptName;
    }

    public void setYourCurrentVersion(String yourCurrentVersion) {
        this.yourCurrentVersion = yourCurrentVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public void setDownloadLink(String downloadLink) {
        this.downloadLink = downloadLink;
    }

    public void setChangeLog(String[] changeLog) {
        this.changeLog = changeLog;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setUpdateAvailable(boolean updateAvailable) {
        this.updateAvailable = updateAvailable;
    }

    public void setMinimumVersion(String minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    public void setUpdateWarning(String updateWarning) {
        this.updateWarning = updateWarning;
    }
}

