/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.models.versionmanager;

public class VersionPart {
    private String version;
    private String preReleaseIdentifier;

    public VersionPart(String version) {
        String[] parts = this.splitVersionPart(version);
        this.version = parts[0];
        this.preReleaseIdentifier = this.getPRI(parts);
    }

    public String getVersion() {
        return this.version;
    }

    public String getPreReleaseIdentifier() {
        return this.preReleaseIdentifier;
    }

    public boolean isHigherThan(String compareVersionStr) {
        VersionPart currentVersionPart = new VersionPart(this.version);
        VersionPart compareVersionPart = new VersionPart(compareVersionStr);
        Double currentVersion = Double.parseDouble(currentVersionPart.getVersion().replace(".", "")) + this.calcWeightOfPRI(this.preReleaseIdentifier);
        Double compareVersion = Double.parseDouble(compareVersionPart.getVersion().replace(".", "")) + this.calcWeightOfPRI(compareVersionPart.getPreReleaseIdentifier());
        return currentVersion > compareVersion;
    }

    private Double calcWeightOfPRI(String pri) {
        switch (pri.toLowerCase()) {
            case "alpha": {
                return 0.1;
            }
            case "beta": {
                return 0.2;
            }
            case "rc": {
                return 0.3;
            }
        }
        return 0.4;
    }

    private String[] splitVersionPart(String version) {
        return version.split("-");
    }

    private String getPRI(String[] versionParts) {
        if (versionParts.length == 1) {
            return "stable";
        }
        return versionParts[1];
    }
}

