/*
 * Decompiled with CFR 0.152.
 */
package com.vi2k.ghastthekiller.settings;

import com.vi2k.ghastthekiller.GhastTheKiller;
import com.vi2k.ghastthekiller.constants.settings.DefaultSetting;
import com.vi2k.ghastthekiller.models.settings.BossSetting;
import com.vi2k.ghastthekiller.models.settings.MinecartHitDamage;
import com.vi2k.ghastthekiller.models.settings.RandomChest;
import com.vi2k.ghastthekiller.models.settings.SoundSetting;
import com.vi2k.ghastthekiller.utils.settings.SettingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;

public class GhastTheKillerSettings {
    private static final GhastTheKillerSettings instance = new GhastTheKillerSettings();
    private File file;
    private YamlConfiguration config;
    private SettingUtil settingUtil;
    private BossSetting ghastBoss;
    private BossSetting witherBoss;
    private BossSetting vexBoss;
    private BossSetting blazeBoss;
    private BossSetting phantomBoss;
    private SoundSetting bossHuntingSound;
    private SoundSetting countdownSound;
    private SoundSetting winSound;
    private Integer constantDayTime;
    private Integer constantNightTime;
    private boolean hidePluginCreator = false;
    private Double minecartSpeed = 1.0;
    private String pluginVersionManagerURL = "https://versionmanager.vi2k.com/plugins/ghastthekiller/version.json";
    private String skriptVersionManagerURL = "https://versionmanager.vi2k.com/skripts/<SKRIPT_NAME>/<SKRIPT_VERSION>/version.json";
    private RandomChest[] randomChests;
    private SoundSetting minecartHitSound;
    private Double minecartHitSpeedFactor;
    private MinecartHitDamage[] minecartHitDamages;
    private boolean harderBypass = true;
    private ArrayList<String> harderBypassBlocks;
    private double harderBypassSpeedFactor;

    public void loadConfig() {
        this.ghastBoss = new BossSetting(0, 0);
        this.witherBoss = new BossSetting(0, 0);
        this.vexBoss = new BossSetting(0, 0);
        this.blazeBoss = new BossSetting(0, 0);
        this.phantomBoss = new BossSetting(0, 0);
        this.file = new File(GhastTheKiller.getInstance().getDataFolder(), "config.yml");
        if (!this.file.exists()) {
            GhastTheKiller.getInstance().saveResource("config.yml", false);
        }
        this.config = new YamlConfiguration();
        try {
            this.config.options().parseComments(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.config.load(this.file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.settingUtil = new SettingUtil(this);
        this.constantDayTime = this.config.getInt("Time.Constant.Day");
        this.constantDayTime = this.settingUtil.getSetting("Time.Constant.Day", Integer.class, DefaultSetting.TIME_CONSTANT_DAY);
        this.constantNightTime = this.settingUtil.getSetting("Time.Constant.Night", Integer.class, DefaultSetting.TIME_CONSTANT_NIGHT);
        this.ghastBoss.setMaxQuantity(this.settingUtil.getSetting("Boss.Settings.Ghast.MaxQuantity", Integer.class, DefaultSetting.BOSS_SETTINGS_GHAST_MAX_QUANTITY));
        this.ghastBoss.setSpawnTime(this.settingUtil.getSetting("Boss.Settings.Ghast.SpawnTime", Integer.class, DefaultSetting.BOSS_SETTINGS_GHAST_SPAWN_TIME));
        this.witherBoss.setMaxQuantity(this.settingUtil.getSetting("Boss.Settings.Wither.MaxQuantity", Integer.class, DefaultSetting.BOSS_SETTINGS_WITHER_MAX_QUANTITY));
        this.witherBoss.setSpawnTime(this.settingUtil.getSetting("Boss.Settings.Wither.SpawnTime", Integer.class, DefaultSetting.BOSS_SETTINGS_WITHER_SPAWN_TIME));
        this.vexBoss.setMaxQuantity(this.settingUtil.getSetting("Boss.Settings.Vex.MaxQuantity", Integer.class, DefaultSetting.BOSS_SETTINGS_VEX_MAX_QUANTITY));
        this.vexBoss.setSpawnTime(this.settingUtil.getSetting("Boss.Settings.Vex.SpawnTime", Integer.class, DefaultSetting.BOSS_SETTINGS_VEX_SPAWN_TIME));
        this.blazeBoss.setMaxQuantity(this.settingUtil.getSetting("Boss.Settings.Blaze.MaxQuantity", Integer.class, DefaultSetting.BOSS_SETTINGS_BLAZE_MAX_QUANTITY));
        this.blazeBoss.setSpawnTime(this.settingUtil.getSetting("Boss.Settings.Blaze.SpawnTime", Integer.class, DefaultSetting.BOSS_SETTINGS_BLAZE_SPAWN_TIME));
        this.phantomBoss.setMaxQuantity(this.settingUtil.getSetting("Boss.Settings.Phantom.MaxQuantity", Integer.class, DefaultSetting.BOSS_SETTINGS_PHANTOM_MAX_QUANTITY));
        this.phantomBoss.setSpawnTime(this.settingUtil.getSetting("Boss.Settings.Phantom.SpawnTime", Integer.class, DefaultSetting.BOSS_SETTINGS_PHANTOM_SPAWN_TIME));
        this.bossHuntingSound = new SoundSetting(this.settingUtil.getSetting("Boss.Sound.Hunting.Sound", String.class, "minecraft:custom.biohazard_alert"), this.settingUtil.getSetting("Boss.Sound.Hunting.Volume", Double.class, DefaultSetting.BOSS_SOUND_HUNTING_VOLUME), this.settingUtil.getSetting("Boss.Sound.Hunting.Pitch", Double.class, DefaultSetting.BOSS_SOUND_HUNTING_PITCH));
        this.countdownSound = new SoundSetting(this.settingUtil.getSetting("Winning.Sound.Countdown.Sound", String.class, "minecraft:custom.countdown_ping"), this.settingUtil.getSetting("Winning.Sound.Countdown.Volume", Double.class, DefaultSetting.WINNING_SOUND_COUNTDOWN_VOLUME), this.settingUtil.getSetting("Winning.Sound.Countdown.Pitch", Double.class, DefaultSetting.WINNING_SOUND_COUNTDOWN_PITCH));
        this.winSound = new SoundSetting(this.settingUtil.getSetting("Winning.Sound.Win.Sound", String.class, "minecraft:custom.win_sound"), this.settingUtil.getSetting("Winning.Sound.Win.Volume", Double.class, DefaultSetting.WINNING_SOUND_WIN_VOLUME), this.settingUtil.getSetting("Winning.Sound.Win.Pitch", Double.class, DefaultSetting.WINNING_SOUND_WIN_PITCH));
        this.hidePluginCreator = this.settingUtil.getSetting("HidePluginCreator", Boolean.class, DefaultSetting.HIDE_PLUGIN_CREATOR);
        this.minecartSpeed = this.settingUtil.getSetting("Minecart.Speed", Double.class, DefaultSetting.MINECART_SPEED);
        this.randomChests = new RandomChest[]{new RandomChest(Material.CHEST, this.settingUtil.getSetting("RandomChest.Settings.Chest.Items", ArrayList.class, DefaultSetting.RANDOM_CHEST_SETTINGS_CHEST_ITEMS), this.settingUtil.getSetting("RandomChest.Settings.Chest.Random.Min", Integer.class, DefaultSetting.RANDOM_CHEST_SETTINGS_CHEST_RANDOM_MIN), this.settingUtil.getSetting("RandomChest.Settings.Chest.Random.Max", Integer.class, DefaultSetting.RANDOM_CHEST_SETTINGS_CHEST_RANDOM_MAX), this.settingUtil.getSetting("RandomChest.Settings.Chest.ResetTime", Integer.class, DefaultSetting.RANDOM_CHEST_SETTINGS_CHEST_RESET_TIME)), new RandomChest(Material.TRAPPED_CHEST, this.settingUtil.getSetting("RandomChest.Settings.Trapped_Chest.Items", ArrayList.class, DefaultSetting.RANDOM_CHEST_SETTINGS_TRAPPED_CHEST_ITEMS), this.settingUtil.getSetting("RandomChest.Settings.Trapped_Chest.Random.Min", Integer.class, DefaultSetting.RANDOM_CHEST_SETTINGS_TRAPPED_CHEST_RANDOM_MIN), this.settingUtil.getSetting("RandomChest.Settings.Trapped_Chest.Random.Max", Integer.class, DefaultSetting.RANDOM_CHEST_SETTINGS_TRAPPED_CHEST_RANDOM_MAX), this.settingUtil.getSetting("RandomChest.Settings.Trapped_Chest.ResetTime", Integer.class, DefaultSetting.RANDOM_CHEST_SETTINGS_TRAPPED_CHEST_RESET_TIME))};
        this.minecartHitSound = new SoundSetting(this.settingUtil.getSetting("Minecart.Sound.Hit.Sound", String.class, "minecraft:custom.hit_sound"), this.settingUtil.getSetting("Minecart.Sound.Hit.Volume", Double.class, DefaultSetting.MINECART_SOUND_HIT_VOLUME), this.settingUtil.getSetting("Minecart.Sound.Hit.Pitch", Double.class, DefaultSetting.MINECART_SOUND_HIT_PITCH));
        this.minecartHitSpeedFactor = this.settingUtil.getSetting("Minecart.Hit.SpeedFactor", Double.class, DefaultSetting.MINECART_HIT_SPEED_FACTOR);
        ArrayList<LinkedHashMap> minecartHitDamagesConf = this.settingUtil.getSetting("Minecart.Hit.Damage", ArrayList.class, DefaultSetting.MINECART_HIT_DAMAGES_CONF);
        this.minecartHitDamages = new MinecartHitDamage[minecartHitDamagesConf.size()];
        for (int i = 0; i < minecartHitDamagesConf.size(); ++i) {
            EntityType entityType;
            String entityTypeName = (String)minecartHitDamagesConf.get(i).keySet().toArray()[0];
            Double damage = (Double)minecartHitDamagesConf.get(i).get(entityTypeName);
            try {
                entityType = EntityType.valueOf((String)entityTypeName.toUpperCase());
            }
            catch (Exception ex) {
                entityType = null;
            }
            if (entityType == null && entityTypeName != "Default") continue;
            this.minecartHitDamages[i] = new MinecartHitDamage(entityType, damage);
        }
        this.harderBypass = this.settingUtil.getSetting("Harder_Bypass.Enabled", Boolean.class, true);
        this.harderBypassBlocks = this.settingUtil.getSetting("Harder_Bypass.Blocks", ArrayList.class, DefaultSetting.HARDER_BYPASS_BLOCKS);
        this.harderBypassSpeedFactor = this.settingUtil.getSetting("Harder_Bypass.SpeedFactor", Double.class, 2.0);
        this.save();
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
        this.save();
    }

    public static GhastTheKillerSettings getInstance() {
        return instance;
    }

    public Boolean getHidePluginCreator() {
        return this.hidePluginCreator;
    }

    public void setHidePluginCreator(Boolean hidePluginCreator) {
        this.hidePluginCreator = hidePluginCreator;
        this.set("HidePluginCreator", hidePluginCreator);
    }

    public Integer getConstantDayTime() {
        return this.constantDayTime;
    }

    public void setConstantDayTime(Integer constantDayTime) {
        this.constantDayTime = constantDayTime;
        this.set("Time.Constant.Day", constantDayTime);
    }

    public Integer getConstantNightTime() {
        return this.constantNightTime;
    }

    public void setConstantNightTime(Integer constantNightTime) {
        this.constantNightTime = constantNightTime;
        this.set("Time.Constant.Night", constantNightTime);
    }

    public BossSetting getGhastBoss() {
        return this.ghastBoss;
    }

    public void setGhastBoss(BossSetting ghastBoss) {
        this.ghastBoss = ghastBoss;
        this.set("Boss.Settings.Ghast.MaxQuantity", ghastBoss.getMaxQuantity());
        this.set("Boss.Settings.Ghast.SpawnTime", ghastBoss.getSpawnTime());
    }

    public BossSetting getWitherBoss() {
        return this.witherBoss;
    }

    public void setWitherBoss(BossSetting witherBoss) {
        this.witherBoss = witherBoss;
        this.set("Boss.Settings.Wither.MaxQuantity", witherBoss.getMaxQuantity());
        this.set("Boss.Settings.Wither.SpawnTime", witherBoss.getSpawnTime());
    }

    public BossSetting getVexBoss() {
        return this.vexBoss;
    }

    public void setVexBoss(BossSetting vexBoss) {
        this.vexBoss = vexBoss;
        this.set("Boss.Settings.Vex.MaxQuantity", vexBoss.getMaxQuantity());
        this.set("Boss.Settings.Vex.SpawnTime", vexBoss.getSpawnTime());
    }

    public BossSetting getPhantomBoss() {
        return this.phantomBoss;
    }

    public void setPhantomBoss(BossSetting phantomBoss) {
        this.phantomBoss = phantomBoss;
        this.set("Boss.Settings.Phantom.MaxQuantity", phantomBoss.getMaxQuantity());
        this.set("Boss.Settings.Phantom.SpawnTime", phantomBoss.getSpawnTime());
    }

    public BossSetting getBlazeBoss() {
        return this.blazeBoss;
    }

    public void setBlazeBoss(BossSetting blazeBoss) {
        this.blazeBoss = blazeBoss;
        this.set("Boss.Settings.Blaze.MaxQuantity", blazeBoss.getMaxQuantity());
        this.set("Boss.Settings.Blaze.SpawnTime", blazeBoss.getSpawnTime());
    }

    public SoundSetting getBossHuntingSound() {
        return this.bossHuntingSound;
    }

    public void setBossHuntingSound(SoundSetting bossHuntingSound) {
        this.bossHuntingSound = bossHuntingSound;
        this.set("Boss.Sound.Hunting.Sound", bossHuntingSound.getSoundID());
        this.set("Boss.Sound.Hunting.Volume", bossHuntingSound.getVolume());
        this.set("Boss.Sound.Hunting.Pitch", bossHuntingSound.getPitch());
    }

    public SoundSetting getCountdownSound() {
        return this.countdownSound;
    }

    public void setCountdownSound(SoundSetting countdownSound) {
        this.countdownSound = countdownSound;
        this.set("Winning.Sound.Countdown.Sound", countdownSound.getSoundID());
        this.set("Winning.Sound.Countdown.Volume", countdownSound.getVolume());
        this.set("Winning.Sound.Countdown.Pitch", countdownSound.getPitch());
    }

    public SoundSetting getWinSound() {
        return this.winSound;
    }

    public void setWinSound(SoundSetting winSound) {
        this.winSound = winSound;
        this.set("Winning.Sound.Win.Sound", winSound.getSoundID());
        this.set("Winning.Sound.Win.Volume", winSound.getVolume());
        this.set("Winning.Sound.Win.Pitch", winSound.getPitch());
    }

    public boolean isHidePluginCreator() {
        return this.hidePluginCreator;
    }

    public void setHidePluginCreator(boolean hidePluginCreator) {
        this.hidePluginCreator = hidePluginCreator;
        this.set("HidePluginCreator", hidePluginCreator);
    }

    public Double getMinecartSpeed() {
        return this.minecartSpeed;
    }

    public void setMinecartSpeed(Double minecartSpeed) {
        this.minecartSpeed = minecartSpeed;
        this.set("Minecart.Speed", minecartSpeed);
    }

    public String getPluginVersionManagerURL() {
        return this.pluginVersionManagerURL;
    }

    public String getSkriptVersionManagerURL() {
        return this.skriptVersionManagerURL;
    }

    public RandomChest[] getRandomChests() {
        return this.randomChests;
    }

    public void setRandomChests(RandomChest[] randomChests) {
        this.randomChests = randomChests;
        this.set("RandomChest.Settings.Chest.Items", randomChests[0].getItems());
        this.set("RandomChest.Settings.Chest.Random.Min", randomChests[0].getMin());
        this.set("RandomChest.Settings.Chest.Random.Max", randomChests[0].getMax());
        this.set("RandomChest.Settings.Chest.ResetTime", randomChests[0].getResetTime());
        this.set("RandomChest.Settings.Trapped_Chest.Items", randomChests[1].getItems());
        this.set("RandomChest.Settings.Trapped_Chest.Random.Min", randomChests[1].getMin());
        this.set("RandomChest.Settings.Trapped_Chest.Random.Max", randomChests[1].getMax());
        this.set("RandomChest.Settings.Trapped_Chest.ResetTime", randomChests[1].getResetTime());
    }

    public SoundSetting getMinecartHitSound() {
        return this.minecartHitSound;
    }

    public void setMinecartHitSound(SoundSetting minecartHitSound) {
        this.minecartHitSound = minecartHitSound;
        this.set("Minecart.Sound.Hit.Sound", minecartHitSound.getSoundID());
        this.set("Minecart.Sound.Hit.Volume", minecartHitSound.getVolume());
        this.set("Minecart.Sound.Hit.Pitch", minecartHitSound.getPitch());
    }

    public Double getMinecartHitSpeedFactor() {
        return this.minecartHitSpeedFactor;
    }

    public void setMinecartHitSpeedFactor(Double minecartHitSpeedFactor) {
        this.minecartHitSpeedFactor = minecartHitSpeedFactor;
        this.set("Minecart.Hit.SpeedFactor", minecartHitSpeedFactor);
    }

    public MinecartHitDamage[] getMinecartHitDamages() {
        return this.minecartHitDamages;
    }

    public void setMinecartHitDamages(MinecartHitDamage[] minecartHitDamages) {
        this.minecartHitDamages = minecartHitDamages;
        String[] minecartHitDamagesConf = new String[minecartHitDamages.length];
        for (int i = 0; i < minecartHitDamages.length; ++i) {
            minecartHitDamagesConf[i] = minecartHitDamages[i].getEntityType().name() + ":" + minecartHitDamages[i].getDamage();
        }
        this.set("Minecart.Hit.Damage", minecartHitDamagesConf);
    }

    public boolean getHarderBypass() {
        return this.harderBypass;
    }

    public void setHarderBypass(boolean harderBypass) {
        this.harderBypass = harderBypass;
        this.set("Harder_Bypass.Enabled", harderBypass);
    }

    public ArrayList<String> getHarderBypassBlocks() {
        return this.harderBypassBlocks;
    }

    public void setHarderBypassBlocks(ArrayList<String> harderBypassBlocks) {
        this.harderBypassBlocks = harderBypassBlocks;
        this.set("Harder_Bypass.Blocks", harderBypassBlocks);
    }

    public double getHarderBypassSpeedFactor() {
        return this.harderBypassSpeedFactor;
    }

    public void setHarderBypassSpeedFactor(double harderBypassSpeedFactor) {
        this.harderBypassSpeedFactor = harderBypassSpeedFactor;
        this.set("Harder_Bypass.SpeedFactor", harderBypassSpeedFactor);
    }
}

