/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor.standard;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedQueueExecutorThread;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedThreadedTaskQueue;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public final class PrioritisedThreadPool {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final PrioritisedThread[] threads;
    protected final TreeSet<PrioritisedPoolExecutorImpl> queues = new TreeSet<PrioritisedPoolExecutorImpl>(PrioritisedPoolExecutorImpl.comparator());
    protected final String name;
    protected final long queueMaxHoldTime;
    protected final ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> nonShutdownQueues = new ReferenceOpenHashSet();
    protected final ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> activeQueues = new ReferenceOpenHashSet();
    protected boolean shutdown;
    protected long schedulingIdGenerator;
    protected static final long DEFAULT_QUEUE_HOLD_TIME = 5000000L;

    public PrioritisedThreadPool(String name, int threads) {
        this(name, threads, null);
    }

    public PrioritisedThreadPool(String name, int threads, BiConsumer<Thread, Integer> threadModifier) {
        this(name, threads, threadModifier, 5000000L);
    }

    public PrioritisedThreadPool(String name, int threads, BiConsumer<Thread, Integer> threadModifier, long queueHoldTime) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Thread count must be > 0, not " + threads);
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.queueMaxHoldTime = queueHoldTime;
        this.threads = new PrioritisedThread[threads];
        for (int i2 = 0; i2 < threads; ++i2) {
            this.threads[i2] = new PrioritisedThread(this);
            this.threads[i2].setName("Prioritised thread for pool '" + name + "' #" + i2);
            this.threads[i2].setUncaughtExceptionHandler((thread, throwable) -> LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable));
            if (threadModifier != null) {
                threadModifier.accept(this.threads[i2], i2);
            }
            this.threads[i2].start();
        }
    }

    public Thread[] getThreads() {
        return (Thread[])Arrays.copyOf(this.threads, this.threads.length, Thread[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrioritisedPoolExecutor createExecutor(String name, int parallelism) {
        ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet = this.nonShutdownQueues;
        synchronized (referenceOpenHashSet) {
            if (this.shutdown) {
                throw new IllegalStateException("Queue is shutdown: " + this.toString());
            }
            PrioritisedPoolExecutorImpl ret = new PrioritisedPoolExecutorImpl(this, name, Math.min(Math.max(1, parallelism), this.threads.length));
            this.nonShutdownQueues.add((Object)ret);
            ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet2 = this.activeQueues;
            synchronized (referenceOpenHashSet2) {
                this.activeQueues.add((Object)ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt(boolean shutdownQueues) {
        PrioritisedThread[] prioritisedThreadArray = this.nonShutdownQueues;
        synchronized (this.nonShutdownQueues) {
            this.shutdown = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (shutdownQueues) {
                ArrayList<PrioritisedPoolExecutorImpl> queuesToShutdown;
                ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet = this.nonShutdownQueues;
                synchronized (referenceOpenHashSet) {
                    this.shutdown = true;
                    queuesToShutdown = new ArrayList<PrioritisedPoolExecutorImpl>((Collection<PrioritisedPoolExecutorImpl>)this.nonShutdownQueues);
                }
                for (PrioritisedPoolExecutorImpl queue : queuesToShutdown) {
                    queue.shutdown();
                }
            }
            for (PrioritisedThread thread : this.threads) {
                thread.halt(false);
            }
            return;
        }
    }

    public boolean join(long msToWait) {
        try {
            return this.join(msToWait, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean joinInterruptable(long msToWait) throws InterruptedException {
        return this.join(msToWait, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean join(long msToWait, boolean interruptable) throws InterruptedException {
        long nsToWait = msToWait * 1000000L;
        long start = System.nanoTime();
        long deadline = start + nsToWait;
        boolean interrupted = false;
        try {
            for (PrioritisedThread thread : this.threads) {
                while (thread.isAlive()) {
                    long current = System.nanoTime();
                    if (current >= deadline) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        thread.join(Math.max(1L, (deadline - current) / 1000000L));
                    }
                    catch (InterruptedException ex) {
                        if (interruptable) {
                            throw ex;
                        }
                        interrupted = true;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        ArrayList<PrioritisedPoolExecutorImpl> queuesToShutdown;
        ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet = this.nonShutdownQueues;
        synchronized (referenceOpenHashSet) {
            this.shutdown = true;
            queuesToShutdown = new ArrayList<PrioritisedPoolExecutorImpl>((Collection<PrioritisedPoolExecutorImpl>)this.nonShutdownQueues);
        }
        for (PrioritisedPoolExecutorImpl queue : queuesToShutdown) {
            queue.shutdown();
        }
        for (PrioritisedThread thread : this.threads) {
            thread.close(false, false);
        }
        if (wait) {
            ArrayList<PrioritisedPoolExecutorImpl> queues;
            ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet2 = this.activeQueues;
            synchronized (referenceOpenHashSet2) {
                queues = new ArrayList<PrioritisedPoolExecutorImpl>((Collection<PrioritisedPoolExecutorImpl>)this.activeQueues);
            }
            for (PrioritisedPoolExecutorImpl queue : queues) {
                queue.waitUntilAllExecuted();
            }
        }
    }

    protected static final class PrioritisedPoolExecutorImpl
    extends PrioritisedThreadedTaskQueue
    implements PrioritisedPoolExecutor {
        protected final PrioritisedThreadPool pool;
        protected final long[] priorityCounts = new long[PrioritisedExecutor.Priority.TOTAL_SCHEDULABLE_PRIORITIES];
        protected long schedulingId;
        protected int concurrentExecutors;
        protected PrioritisedExecutor.Priority scheduledPriority;
        protected final String name;
        protected final int maximumExecutors;
        protected boolean isQueued;
        private boolean isHalted;
        private long totalQueuedTasks = 0L;

        public PrioritisedPoolExecutorImpl(PrioritisedThreadPool pool, String name, int maximumExecutors) {
            this.pool = pool;
            this.name = name;
            this.maximumExecutors = maximumExecutors;
        }

        public static Comparator<PrioritisedPoolExecutorImpl> comparator() {
            return (p1, p2) -> {
                if (p1 == p2) {
                    return 0;
                }
                int priorityCompare = p1.scheduledPriority.ordinal() - p2.scheduledPriority.ordinal();
                if (priorityCompare != 0) {
                    return priorityCompare;
                }
                int executorCompare = p1.concurrentExecutors - p2.concurrentExecutors;
                if (executorCompare != 0) {
                    return executorCompare;
                }
                return Long.compare(p1.schedulingId, p2.schedulingId);
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void halt() {
            TreeSet<PrioritisedPoolExecutorImpl> queues;
            PrioritisedThreadPool pool = this.pool;
            TreeSet<PrioritisedPoolExecutorImpl> treeSet = queues = pool.queues;
            synchronized (treeSet) {
                if (this.isHalted) {
                    return;
                }
                this.isHalted = true;
                if (this.isQueued) {
                    queues.remove(this);
                    this.isQueued = false;
                }
            }
            treeSet = pool.nonShutdownQueues;
            synchronized (treeSet) {
                pool.nonShutdownQueues.remove((Object)this);
            }
            treeSet = pool.activeQueues;
            synchronized (treeSet) {
                pool.activeQueues.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActive() {
            TreeSet<PrioritisedPoolExecutorImpl> queues;
            PrioritisedThreadPool pool = this.pool;
            TreeSet<PrioritisedPoolExecutorImpl> treeSet = queues = pool.queues;
            synchronized (treeSet) {
                if (this.concurrentExecutors != 0) {
                    return true;
                }
                ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet = pool.activeQueues;
                synchronized (referenceOpenHashSet) {
                    if (pool.activeQueues.contains((Object)this)) {
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void priorityChange(PrioritisedThreadedTaskQueue.PrioritisedTask task, PrioritisedExecutor.Priority from, PrioritisedExecutor.Priority to) {
            int executorsWanted;
            TreeSet<PrioritisedPoolExecutorImpl> queues;
            int highest;
            long[] priorityCounts = this.priorityCounts;
            boolean shutdown = this.isShutdown();
            if (from == null && to == PrioritisedExecutor.Priority.COMPLETING) {
                throw new IllegalStateException("Cannot complete task without queueing it first");
            }
            boolean shouldNotifyTasks = from == null;
            PrioritisedExecutor.Priority scheduledPriority = this.scheduledPriority;
            if (from != null) {
                int n2 = from.priority;
                priorityCounts[n2] = priorityCounts[n2] - 1L;
            }
            if (to != PrioritisedExecutor.Priority.COMPLETING) {
                int n3 = to.priority;
                priorityCounts[n3] = priorityCounts[n3] + 1L;
            }
            long totalQueuedTasks = to == PrioritisedExecutor.Priority.COMPLETING ? --this.totalQueuedTasks : (from == null ? ++this.totalQueuedTasks : this.totalQueuedTasks);
            int lowestPriority = priorityCounts.length;
            for (highest = Math.min(to == PrioritisedExecutor.Priority.COMPLETING ? PrioritisedExecutor.Priority.IDLE.priority : to.priority, scheduledPriority == null ? PrioritisedExecutor.Priority.IDLE.priority : scheduledPriority.priority); highest < lowestPriority; ++highest) {
                long count = priorityCounts[highest];
                if (count < 0L) {
                    throw new IllegalStateException("Priority " + highest + " has " + count + " scheduled tasks");
                }
                if (count != 0L) break;
            }
            PrioritisedExecutor.Priority newPriority = highest == lowestPriority ? null : (shutdown ? PrioritisedExecutor.Priority.getPriority(Math.min(highest, PrioritisedExecutor.Priority.HIGHEST.priority)) : PrioritisedExecutor.Priority.getPriority(highest));
            boolean shouldNotifyHighPriority = false;
            PrioritisedThreadPool pool = this.pool;
            TreeSet<PrioritisedPoolExecutorImpl> treeSet = queues = pool.queues;
            synchronized (treeSet) {
                if (!this.isQueued) {
                    if (newPriority != null) {
                        if (this.schedulingId == 0L) {
                            this.schedulingId = ++pool.schedulingIdGenerator;
                        }
                        this.scheduledPriority = newPriority;
                        if (!this.isHalted && this.concurrentExecutors < this.maximumExecutors) {
                            shouldNotifyHighPriority = newPriority.isHigherOrEqualPriority(PrioritisedExecutor.Priority.HIGH);
                            queues.add(this);
                            this.isQueued = true;
                        }
                    } else {
                        this.scheduledPriority = null;
                    }
                } else if (newPriority == null) {
                    queues.remove(this);
                    this.scheduledPriority = null;
                    this.isQueued = false;
                } else if (scheduledPriority != newPriority) {
                    queues.remove(this);
                    this.scheduledPriority = newPriority;
                    queues.add(this);
                    shouldNotifyHighPriority = (scheduledPriority == null || scheduledPriority.isLowerPriority(PrioritisedExecutor.Priority.HIGH)) && newPriority.isHigherOrEqualPriority(PrioritisedExecutor.Priority.HIGH);
                }
                executorsWanted = this.isQueued ? Math.min(this.maximumExecutors - this.concurrentExecutors, (int)totalQueuedTasks) : 0;
            }
            if (newPriority == null && shutdown) {
                treeSet = pool.activeQueues;
                synchronized (treeSet) {
                    pool.activeQueues.remove((Object)this);
                }
            }
            if (executorsWanted > 0 || shouldNotifyTasks | shouldNotifyHighPriority) {
                int notified = 0;
                for (PrioritisedThread thread : pool.threads) {
                    if ((shouldNotifyHighPriority ? thread.alertHighPriorityExecutor() : thread.notifyTasks()) && ++notified >= executorsWanted) break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shutdown() {
            TreeSet<PrioritisedPoolExecutorImpl> queues;
            boolean ret = super.shutdown();
            if (!ret) {
                return ret;
            }
            PrioritisedThreadPool pool = this.pool;
            ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet = pool.nonShutdownQueues;
            synchronized (referenceOpenHashSet) {
                pool.nonShutdownQueues.remove((Object)this);
            }
            TreeSet<PrioritisedPoolExecutorImpl> treeSet = queues = pool.queues;
            synchronized (treeSet) {
                if (this.scheduledPriority == null) {
                    ReferenceOpenHashSet<PrioritisedPoolExecutorImpl> referenceOpenHashSet2 = pool.activeQueues;
                    synchronized (referenceOpenHashSet2) {
                        pool.activeQueues.remove((Object)this);
                    }
                    return ret;
                }
                if (this.scheduledPriority.isHigherOrEqualPriority(PrioritisedExecutor.Priority.HIGHEST)) {
                    return ret;
                }
                if (this.isQueued) {
                    queues.remove(this);
                    this.scheduledPriority = PrioritisedExecutor.Priority.HIGHEST;
                    queues.add(this);
                } else {
                    this.scheduledPriority = PrioritisedExecutor.Priority.HIGHEST;
                }
            }
            return ret;
        }
    }

    protected static final class PrioritisedThread
    extends PrioritisedQueueExecutorThread {
        protected final PrioritisedThreadPool pool;
        protected final AtomicBoolean alertedHighPriority = new AtomicBoolean();

        public PrioritisedThread(PrioritisedThreadPool pool) {
            super((PrioritisedExecutor)null);
            this.pool = pool;
        }

        public boolean alertHighPriorityExecutor() {
            if (!this.notifyTasks()) {
                if (!this.alertedHighPriority.get()) {
                    this.alertedHighPriority.set(true);
                }
                return false;
            }
            return true;
        }

        private boolean isAlertedHighPriority() {
            return this.alertedHighPriority.get() && this.alertedHighPriority.getAndSet(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean pollTasks() {
            PrioritisedThreadPool pool = this.pool;
            TreeSet<PrioritisedPoolExecutorImpl> queues = this.pool.queues;
            boolean ret = false;
            while (!this.halted) {
                PrioritisedPoolExecutorImpl queue;
                TreeSet<PrioritisedPoolExecutorImpl> treeSet = queues;
                synchronized (treeSet) {
                    queue = queues.pollFirst();
                    if (queue == null) {
                        break;
                    }
                    queue.schedulingId = ++pool.schedulingIdGenerator;
                    if (++queue.concurrentExecutors < queue.maximumExecutors) {
                        queues.add(queue);
                        queue.isQueued = true;
                    } else {
                        queue.isQueued = false;
                    }
                }
                long start = System.nanoTime();
                long deadline = start + pool.queueMaxHoldTime;
                do {
                    try {
                        if (this.halted || !queue.executeTask()) break;
                        ret = true;
                    }
                    catch (ThreadDeath death) {
                        throw death;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("Exception thrown from thread '" + this.getName() + "' in queue '" + queue.toString() + "'", throwable);
                    }
                } while (!this.isAlertedHighPriority() && System.nanoTime() <= deadline);
                TreeSet<PrioritisedPoolExecutorImpl> treeSet2 = queues;
                synchronized (treeSet2) {
                    if (queue.isQueued) {
                        queues.remove(queue);
                        queue.isQueued = false;
                    }
                    if (--queue.concurrentExecutors == 0 && queue.scheduledPriority == null) {
                        queue.schedulingId = 0L;
                    }
                    if (!queue.isHalted && queue.scheduledPriority != null) {
                        queues.add(queue);
                        queue.isQueued = true;
                    }
                }
            }
            return ret;
        }
    }

    public static interface PrioritisedPoolExecutor
    extends PrioritisedExecutor {
        public void halt();

        public boolean isActive();
    }
}

