/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import net.minecraft.network.chat.IChatBaseComponent;

public final class V1458 {
    protected static final int VERSION = 1458;

    public static MapType<String> updateCustomName(MapType<String> data) {
        String customName = data.getString("CustomName", "");
        if (customName.isEmpty()) {
            data.remove("CustomName");
        } else {
            data.setString("CustomName", IChatBaseComponent.ChatSerializer.a(IChatBaseComponent.b(customName)));
        }
        return null;
    }

    public static void register() {
        MCTypeRegistry.PLAYER.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1458){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1458){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                if ("minecraft:commandblock_minecart".equals(data.getString("id"))) {
                    return null;
                }
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1458){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType tag = data.getMap("tag");
                if (tag == null) {
                    return null;
                }
                MapType display = tag.getMap("display");
                if (display == null) {
                    return null;
                }
                String name = display.getString("Name");
                if (name != null) {
                    display.setString("Name", IChatBaseComponent.ChatSerializer.a(IChatBaseComponent.b(name)));
                } else {
                    String localisedName = display.getString("LocName");
                    if (localisedName != null) {
                        display.setString("Name", IChatBaseComponent.ChatSerializer.a(IChatBaseComponent.c(localisedName)));
                        display.remove("LocName");
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1458){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                if ("minecraft:command_block".equals(data.getString("id"))) {
                    return null;
                }
                return V1458.updateCustomName(data);
            }
        });
    }

    private V1458() {
    }
}

