/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.advancements.ConverterCriteriaRename;
import ca.spottedleaf.dataconverter.minecraft.converters.entity.ConverterEntityVariantRename;
import ca.spottedleaf.dataconverter.minecraft.converters.poi.ConverterPoiDelete;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class V3097 {
    private static final int VERSION = 3097;

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> removeFilteredBookText = new DataConverter<MapType<String>, MapType<String>>(3097){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType tag = data.getMap("tag");
                if (tag == null) {
                    return null;
                }
                tag.remove("filtered_title");
                tag.remove("filtered_pages");
                return null;
            }
        };
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:writable_book", removeFilteredBookText);
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:written_book", removeFilteredBookText);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:sign", new DataConverter<MapType<String>, MapType<String>>(3097){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                data.remove("FilteredText1");
                data.remove("FilteredText2");
                data.remove("FilteredText3");
                data.remove("FilteredText4");
                return null;
            }
        });
        HashMap<String, String> britishRenamer = new HashMap<String, String>(Map.of("minecraft:british", "minecraft:british_shorthair"));
        HashSet<String> poiRemove = new HashSet<String>(Set.of("minecraft:unemployed", "minecraft:nitwit"));
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:cat", new ConverterEntityVariantRename(3097, britishRenamer::get));
        MCTypeRegistry.ADVANCEMENTS.addStructureConverter(new ConverterCriteriaRename(3097, "minecraft:husbandry/complete_catalogue", britishRenamer::get));
        MCTypeRegistry.POI_CHUNK.addStructureConverter(new ConverterPoiDelete(3097, poiRemove::contains));
    }
}

