/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.util;

import ca.spottedleaf.dataconverter.types.MapType;
import net.minecraft.resources.MinecraftKey;

public final class NamespaceUtil {
    private NamespaceUtil() {
    }

    public static void enforceForPath(MapType<String> data, String path) {
        String replace;
        if (data == null) {
            return;
        }
        String id = data.getString(path);
        if (id != null && (replace = NamespaceUtil.correctNamespaceOrNull(id)) != null) {
            data.setString(path, replace);
        }
    }

    public static String correctNamespace(String value) {
        if (value == null) {
            return null;
        }
        MinecraftKey resourceLocation = MinecraftKey.a(value);
        return resourceLocation != null ? resourceLocation.toString() : value;
    }

    public static String correctNamespaceOrNull(String value) {
        if (value == null) {
            return null;
        }
        String correct = NamespaceUtil.correctNamespace(value);
        return correct.equals(value) ? null : correct;
    }
}

