/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.loottable;

import com.destroystokyo.paper.loottable.LootableInventoryReplenishEvent;
import com.destroystokyo.paper.loottable.PaperLootableInventory;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DurationOrDisabled;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.entity.Player;
import org.bukkit.loot.LootTable;

public class PaperLootableInventoryData {
    private static final Random RANDOM = new Random();
    private long lastFill = -1L;
    private long nextRefill = -1L;
    private int numRefills = 0;
    private Map<UUID, Long> lootedPlayers;
    private final PaperLootableInventory lootable;

    public PaperLootableInventoryData(PaperLootableInventory lootable) {
        this.lootable = lootable;
    }

    long getLastFill() {
        return this.lastFill;
    }

    long getNextRefill() {
        return this.nextRefill;
    }

    long setNextRefill(long nextRefill) {
        long prev = this.nextRefill;
        this.nextRefill = nextRefill;
        return prev;
    }

    public boolean shouldReplenish(@Nullable EntityHuman player) {
        LootTable table = this.lootable.getLootTable();
        if (table == null) {
            return false;
        }
        if (this.lastFill == -1L || !this.lootable.getNMSWorld().paperConfig().lootables.autoReplenish) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (this.nextRefill == -1L) {
            return false;
        }
        WorldConfiguration paperConfig = this.lootable.getNMSWorld().paperConfig();
        if (paperConfig.lootables.maxRefills != -1 && this.numRefills >= paperConfig.lootables.maxRefills) {
            return false;
        }
        if (this.nextRefill > System.currentTimeMillis()) {
            return false;
        }
        Player bukkitPlayer = (Player)player.getBukkitEntity();
        LootableInventoryReplenishEvent event = new LootableInventoryReplenishEvent(bukkitPlayer, this.lootable.getAPILootableInventory());
        event.setCancelled(!this.canPlayerLoot(player.ct(), paperConfig));
        return event.callEvent();
    }

    public void processRefill(@Nullable EntityHuman player) {
        this.lastFill = System.currentTimeMillis();
        WorldConfiguration paperConfig = this.lootable.getNMSWorld().paperConfig();
        if (paperConfig.lootables.autoReplenish) {
            long min = paperConfig.lootables.refreshMin.seconds();
            long max = paperConfig.lootables.refreshMax.seconds();
            this.nextRefill = this.lastFill + (min + RANDOM.nextLong(max - min + 1L)) * 1000L;
            ++this.numRefills;
            if (paperConfig.lootables.resetSeedOnFill) {
                this.lootable.setSeed(0L);
            }
            if (player != null) {
                this.setPlayerLootedState(player.ct(), true);
            }
        } else {
            this.lootable.clearLootTable();
        }
    }

    public void loadNbt(NBTTagCompound base) {
        if (!base.b("Paper.LootableData", 10)) {
            return;
        }
        NBTTagCompound comp = base.p("Paper.LootableData");
        if (comp.e("lastFill")) {
            this.lastFill = comp.i("lastFill");
        }
        if (comp.e("nextRefill")) {
            this.nextRefill = comp.i("nextRefill");
        }
        if (comp.e("numRefills")) {
            this.numRefills = comp.h("numRefills");
        }
        if (comp.b("lootedPlayers", 9)) {
            NBTTagList list = comp.c("lootedPlayers", 10);
            int size = list.size();
            if (size > 0) {
                this.lootedPlayers = new HashMap<UUID, Long>(list.size());
            }
            for (int i2 = 0; i2 < size; ++i2) {
                NBTTagCompound cmp = list.a(i2);
                this.lootedPlayers.put(cmp.a("UUID"), cmp.i("Time"));
            }
        }
    }

    public void saveNbt(NBTTagCompound base) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.nextRefill != -1L) {
            comp.a("nextRefill", this.nextRefill);
        }
        if (this.lastFill != -1L) {
            comp.a("lastFill", this.lastFill);
        }
        if (this.numRefills != 0) {
            comp.a("numRefills", this.numRefills);
        }
        if (this.lootedPlayers != null && !this.lootedPlayers.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<UUID, Long> entry : this.lootedPlayers.entrySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                cmp.a("UUID", entry.getKey());
                cmp.a("Time", entry.getValue());
                list.add(cmp);
            }
            comp.a("lootedPlayers", list);
        }
        if (!comp.g()) {
            base.a("Paper.LootableData", comp);
        }
    }

    void setPlayerLootedState(UUID player, boolean looted) {
        if (looted && this.lootedPlayers == null) {
            this.lootedPlayers = new HashMap<UUID, Long>();
        }
        if (looted) {
            this.lootedPlayers.put(player, System.currentTimeMillis());
        } else if (this.lootedPlayers != null) {
            this.lootedPlayers.remove(player);
        }
    }

    boolean canPlayerLoot(UUID player, WorldConfiguration worldConfiguration) {
        Long lastLooted = this.getLastLooted(player);
        if (!worldConfiguration.lootables.restrictPlayerReloot || lastLooted == null) {
            return true;
        }
        DurationOrDisabled restrictPlayerRelootTime = worldConfiguration.lootables.restrictPlayerRelootTime;
        if (restrictPlayerRelootTime.value().isEmpty()) {
            return false;
        }
        return TimeUnit.SECONDS.toMillis(restrictPlayerRelootTime.value().get().seconds()) + lastLooted < System.currentTimeMillis();
    }

    boolean hasPlayerLooted(UUID player) {
        return this.lootedPlayers != null && this.lootedPlayers.containsKey(player);
    }

    Long getLastLooted(UUID player) {
        return this.lootedPlayers != null ? this.lootedPlayers.get(player) : null;
    }
}

