/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.proxy;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.player.ProfilePublicKey;

public class VelocityProxy {
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    public static final int MODERN_FORWARDING_WITH_KEY = 2;
    public static final int MODERN_FORWARDING_WITH_KEY_V2 = 3;
    public static final int MODERN_LAZY_SESSION = 4;
    public static final byte MAX_SUPPORTED_FORWARDING_VERSION = 4;
    public static final MinecraftKey PLAYER_INFO_CHANNEL = new MinecraftKey("velocity", "player_info");

    public static boolean checkIntegrity(PacketDataSerializer buf) {
        byte[] signature = new byte[32];
        buf.readBytes(signature);
        byte[] data = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(GlobalConfiguration.get().proxies.velocity.secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e2) {
            throw new AssertionError((Object)e2);
        }
        return true;
    }

    public static InetAddress readAddress(PacketDataSerializer buf) {
        return InetAddresses.forString((String)buf.e(Short.MAX_VALUE));
    }

    public static GameProfile createProfile(PacketDataSerializer buf) {
        GameProfile profile = new GameProfile(buf.o(), buf.e(16));
        VelocityProxy.readProperties(buf, profile);
        return profile;
    }

    private static void readProperties(PacketDataSerializer buf, GameProfile profile) {
        int properties = buf.m();
        for (int i1 = 0; i1 < properties; ++i1) {
            String name = buf.e(Short.MAX_VALUE);
            String value = buf.e(Short.MAX_VALUE);
            String signature = buf.readBoolean() ? buf.e(Short.MAX_VALUE) : null;
            profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
        }
    }

    public static ProfilePublicKey.a readForwardedKey(PacketDataSerializer buf) {
        return new ProfilePublicKey.a(buf);
    }

    public static UUID readSignerUuidOrElse(PacketDataSerializer buf, UUID orElse) {
        return buf.readBoolean() ? buf.o() : orElse;
    }
}

