/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.map;

import com.destroystokyo.paper.util.concurrent.WeakSeqLock;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;

public class QueuedChangesMapLong2Int {
    protected final Long2IntOpenHashMap updatingMap;
    protected final Long2IntOpenHashMap visibleMap;
    protected final Long2IntOpenHashMap queuedPuts;
    protected final LongOpenHashSet queuedRemove;
    protected int queuedDefaultReturnValue;
    protected final WeakSeqLock updatingMapSeqLock = new WeakSeqLock();

    public QueuedChangesMapLong2Int() {
        this(16, 0.75f);
    }

    public QueuedChangesMapLong2Int(int capacity, float loadFactor) {
        this.updatingMap = new Long2IntOpenHashMap(capacity, loadFactor);
        this.visibleMap = new Long2IntOpenHashMap(capacity, loadFactor);
        this.queuedPuts = new Long2IntOpenHashMap();
        this.queuedRemove = new LongOpenHashSet();
    }

    public void queueDefaultReturnValue(int dfl) {
        this.queuedDefaultReturnValue = dfl;
        this.updatingMap.defaultReturnValue(dfl);
    }

    public int queueUpdate(long k2, int v2) {
        this.queuedRemove.remove(k2);
        this.queuedPuts.put(k2, v2);
        return this.updatingMap.put(k2, v2);
    }

    public int queueRemove(long k2) {
        this.queuedPuts.remove(k2);
        this.queuedRemove.add(k2);
        return this.updatingMap.remove(k2);
    }

    public int getUpdating(long k2) {
        return this.updatingMap.get(k2);
    }

    public int getVisible(long k2) {
        return this.visibleMap.get(k2);
    }

    public int getVisibleAsync(long k2) {
        long readlock;
        int ret = 0;
        do {
            readlock = this.updatingMapSeqLock.acquireRead();
            try {
                ret = this.visibleMap.get(k2);
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) continue;
                throw (ThreadDeath)thr;
            }
        } while (!this.updatingMapSeqLock.tryReleaseRead(readlock));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performUpdates() {
        long key;
        this.updatingMapSeqLock.acquireWrite();
        this.visibleMap.defaultReturnValue(this.queuedDefaultReturnValue);
        this.updatingMapSeqLock.releaseWrite();
        if (this.queuedPuts.isEmpty() && this.queuedRemove.isEmpty()) {
            return false;
        }
        ObjectIterator iterator0 = this.queuedPuts.long2IntEntrySet().fastIterator();
        while (iterator0.hasNext()) {
            Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator0.next();
            key = entry.getLongKey();
            int val = entry.getIntValue();
            this.updatingMapSeqLock.acquireWrite();
            try {
                this.visibleMap.put(key, val);
            }
            finally {
                this.updatingMapSeqLock.releaseWrite();
            }
        }
        this.queuedPuts.clear();
        LongIterator iterator1 = this.queuedRemove.iterator();
        while (iterator1.hasNext()) {
            key = iterator1.nextLong();
            this.updatingMapSeqLock.acquireWrite();
            try {
                this.visibleMap.remove(key);
            }
            finally {
                this.updatingMapSeqLock.releaseWrite();
            }
        }
        this.queuedRemove.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performUpdatesLockMap() {
        this.updatingMapSeqLock.acquireWrite();
        try {
            long key;
            this.visibleMap.defaultReturnValue(this.queuedDefaultReturnValue);
            if (this.queuedPuts.isEmpty() && this.queuedRemove.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            ObjectIterator iterator0 = this.queuedPuts.long2IntEntrySet().fastIterator();
            while (iterator0.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator0.next();
                key = entry.getLongKey();
                int val = entry.getIntValue();
                this.visibleMap.put(key, val);
            }
            this.queuedPuts.clear();
            LongIterator iterator1 = this.queuedRemove.iterator();
            while (iterator1.hasNext()) {
                key = iterator1.nextLong();
                this.visibleMap.remove(key);
            }
            this.queuedRemove.clear();
            boolean bl = true;
            return bl;
        }
        finally {
            this.updatingMapSeqLock.releaseWrite();
        }
    }
}

