/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.misc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;

public class PooledLinkedHashSets<E> {
    protected final Object2ObjectOpenHashMap<PooledObjectLinkedOpenHashSet<E>, PooledObjectLinkedOpenHashSet<E>> mapPool = new Object2ObjectOpenHashMap(128, 0.25f);

    protected void decrementReferenceCount(PooledObjectLinkedOpenHashSet<E> current) {
        if (current.referenceCount == 0) {
            throw new IllegalStateException("Cannot decrement reference count for " + current);
        }
        if (current.referenceCount == -1 || --current.referenceCount > 0) {
            return;
        }
        this.mapPool.remove(current);
    }

    public PooledObjectLinkedOpenHashSet<E> findMapWith(PooledObjectLinkedOpenHashSet<E> current, E object) {
        PooledObjectLinkedOpenHashSet<E> cached = current.getAddCache(object);
        if (cached != null) {
            this.decrementReferenceCount(current);
            if (cached.referenceCount == 0) {
                PooledObjectLinkedOpenHashSet contending = (PooledObjectLinkedOpenHashSet)this.mapPool.putIfAbsent(cached, cached);
                if (contending != null) {
                    if (contending.referenceCount != -1) {
                        ++contending.referenceCount;
                    }
                    current.updateAddCache(object, contending);
                    return contending;
                }
                cached.referenceCount = 1;
            } else if (cached.referenceCount != -1) {
                ++cached.referenceCount;
            }
            return cached;
        }
        if (!current.add(object)) {
            return current;
        }
        PooledObjectLinkedOpenHashSet<E> ret = (PooledObjectLinkedOpenHashSet<E>)this.mapPool.get(current);
        if (ret == null) {
            ret = new PooledObjectLinkedOpenHashSet<E>(current);
            current.remove(object);
            this.mapPool.put(ret, ret);
            ret.referenceCount = 1;
        } else {
            if (ret.referenceCount != -1) {
                ++ret.referenceCount;
            }
            current.remove(object);
        }
        current.updateAddCache(object, ret);
        this.decrementReferenceCount(current);
        return ret;
    }

    public PooledObjectLinkedOpenHashSet<E> findMapWithout(PooledObjectLinkedOpenHashSet<E> current, E object) {
        if (current.set.size() == 1) {
            this.decrementReferenceCount(current);
            return null;
        }
        PooledObjectLinkedOpenHashSet<E> cached = current.getRemoveCache(object);
        if (cached != null) {
            this.decrementReferenceCount(current);
            if (cached.referenceCount == 0) {
                PooledObjectLinkedOpenHashSet contending = (PooledObjectLinkedOpenHashSet)this.mapPool.putIfAbsent(cached, cached);
                if (contending != null) {
                    if (contending.referenceCount != -1) {
                        ++contending.referenceCount;
                    }
                    current.updateRemoveCache(object, contending);
                    return contending;
                }
                cached.referenceCount = 1;
            } else if (cached.referenceCount != -1) {
                ++cached.referenceCount;
            }
            return cached;
        }
        if (!current.remove(object)) {
            return current;
        }
        PooledObjectLinkedOpenHashSet<E> ret = (PooledObjectLinkedOpenHashSet<E>)this.mapPool.get(current);
        if (ret == null) {
            ret = new PooledObjectLinkedOpenHashSet<E>(current);
            current.add(object);
            this.mapPool.put(ret, ret);
            ret.referenceCount = 1;
        } else {
            if (ret.referenceCount != -1) {
                ++ret.referenceCount;
            }
            current.add(object);
        }
        current.updateRemoveCache(object, ret);
        this.decrementReferenceCount(current);
        return ret;
    }

    public static final class PooledObjectLinkedOpenHashSet<E> {
        private static final WeakReference NULL_REFERENCE = new WeakReference<Object>(null);
        final RawSetObjectLinkedOpenHashSet<E> set;
        int referenceCount;
        int hash;
        WeakReference<E> lastAddObject = NULL_REFERENCE;
        WeakReference<PooledObjectLinkedOpenHashSet<E>> lastAddMap = NULL_REFERENCE;
        WeakReference<E> lastRemoveObject = NULL_REFERENCE;
        WeakReference<PooledObjectLinkedOpenHashSet<E>> lastRemoveMap = NULL_REFERENCE;

        public PooledObjectLinkedOpenHashSet(PooledLinkedHashSets<E> pooledSets) {
            this.set = new RawSetObjectLinkedOpenHashSet(2, 0.8f);
        }

        public PooledObjectLinkedOpenHashSet(E single) {
            this((PooledLinkedHashSets)null);
            this.referenceCount = -1;
            this.add((PooledLinkedHashSets)single);
        }

        public PooledObjectLinkedOpenHashSet(PooledObjectLinkedOpenHashSet<E> other) {
            this.set = other.set.clone();
            this.hash = other.hash;
        }

        private static int hash0(int x2) {
            x2 *= 915625301;
            x2 ^= x2 >>> 16;
            return x2;
        }

        PooledObjectLinkedOpenHashSet<E> getAddCache(E element) {
            Object currentAdd = this.lastAddObject.get();
            if (currentAdd == null || currentAdd != element && !currentAdd.equals(element)) {
                return null;
            }
            return (PooledObjectLinkedOpenHashSet)this.lastAddMap.get();
        }

        PooledObjectLinkedOpenHashSet<E> getRemoveCache(E element) {
            Object currentRemove = this.lastRemoveObject.get();
            if (currentRemove == null || currentRemove != element && !currentRemove.equals(element)) {
                return null;
            }
            return (PooledObjectLinkedOpenHashSet)this.lastRemoveMap.get();
        }

        void updateAddCache(E element, PooledObjectLinkedOpenHashSet<E> map) {
            this.lastAddObject = new WeakReference<E>(element);
            this.lastAddMap = new WeakReference<PooledObjectLinkedOpenHashSet<E>>(map);
        }

        void updateRemoveCache(E element, PooledObjectLinkedOpenHashSet<E> map) {
            this.lastRemoveObject = new WeakReference<E>(element);
            this.lastRemoveMap = new WeakReference<PooledObjectLinkedOpenHashSet<E>>(map);
        }

        boolean add(E element) {
            boolean added = this.set.add(element);
            if (added) {
                this.hash += PooledObjectLinkedOpenHashSet.hash0(element.hashCode());
            }
            return added;
        }

        boolean remove(Object element) {
            boolean removed = this.set.remove(element);
            if (removed) {
                this.hash -= PooledObjectLinkedOpenHashSet.hash0(element.hashCode());
            }
            return removed;
        }

        public boolean contains(Object element) {
            return this.set.contains(element);
        }

        public E[] getBackingSet() {
            return this.set.getRawSet();
        }

        public int size() {
            return this.set.size();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PooledObjectLinkedOpenHashSet)) {
                return false;
            }
            if (this.referenceCount == 0) {
                return other == this;
            }
            if (other == this) {
                return false;
            }
            return this.hash == ((PooledObjectLinkedOpenHashSet)other).hash && this.set.equals(((PooledObjectLinkedOpenHashSet)other).set);
        }

        public String toString() {
            return "PooledHashSet: size: " + this.set.size() + ", reference count: " + this.referenceCount + ", hash: " + this.hashCode() + ", identity: " + System.identityHashCode(this) + " map: " + this.set.toString();
        }
    }

    static final class RawSetObjectLinkedOpenHashSet<E>
    extends ObjectOpenHashSet<E> {
        public RawSetObjectLinkedOpenHashSet() {
        }

        public RawSetObjectLinkedOpenHashSet(int capacity) {
            super(capacity);
        }

        public RawSetObjectLinkedOpenHashSet(int capacity, float loadFactor) {
            super(capacity, loadFactor);
        }

        public RawSetObjectLinkedOpenHashSet<E> clone() {
            return (RawSetObjectLinkedOpenHashSet)super.clone();
        }

        public E[] getRawSet() {
            return this.key;
        }
    }
}

