/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Quaternionf;

public record GivensParameters(float a, float b) {
    private final float a;
    private final float b;

    public static GivensParameters a(float a2, float b2) {
        float f2 = Math.invsqrt((float)(a2 * a2 + b2 * b2));
        return new GivensParameters(f2 * a2, f2 * b2);
    }

    public static GivensParameters a(float radians) {
        float f2 = Math.sin((float)(radians / 2.0f));
        float g2 = Math.cosFromSin((float)f2, (float)(radians / 2.0f));
        return new GivensParameters(f2, g2);
    }

    public GivensParameters a() {
        return new GivensParameters(-this.a, this.b);
    }

    public Quaternionf a(Quaternionf quaternionf) {
        return quaternionf.set(this.a, 0.0f, 0.0f, this.b);
    }

    public Quaternionf b(Quaternionf quaternionf) {
        return quaternionf.set(0.0f, this.a, 0.0f, this.b);
    }

    public Quaternionf c(Quaternionf quaternionf) {
        return quaternionf.set(0.0f, 0.0f, this.a, this.b);
    }

    public float b() {
        return this.b * this.b - this.a * this.a;
    }

    public float c() {
        return 2.0f * this.a * this.b;
    }

    public Matrix3f a(Matrix3f matrix3f) {
        matrix3f.m01 = 0.0f;
        matrix3f.m02 = 0.0f;
        matrix3f.m10 = 0.0f;
        matrix3f.m20 = 0.0f;
        float f2 = this.b();
        float g2 = this.c();
        matrix3f.m11 = f2;
        matrix3f.m22 = f2;
        matrix3f.m12 = g2;
        matrix3f.m21 = -g2;
        matrix3f.m00 = 1.0f;
        return matrix3f;
    }

    public Matrix3f b(Matrix3f matrix3f) {
        matrix3f.m01 = 0.0f;
        matrix3f.m10 = 0.0f;
        matrix3f.m12 = 0.0f;
        matrix3f.m21 = 0.0f;
        float f2 = this.b();
        float g2 = this.c();
        matrix3f.m00 = f2;
        matrix3f.m22 = f2;
        matrix3f.m02 = -g2;
        matrix3f.m20 = g2;
        matrix3f.m11 = 1.0f;
        return matrix3f;
    }

    public Matrix3f c(Matrix3f matrix3f) {
        matrix3f.m02 = 0.0f;
        matrix3f.m12 = 0.0f;
        matrix3f.m20 = 0.0f;
        matrix3f.m21 = 0.0f;
        float f2 = this.b();
        float g2 = this.c();
        matrix3f.m00 = f2;
        matrix3f.m11 = f2;
        matrix3f.m01 = g2;
        matrix3f.m10 = -g2;
        matrix3f.m22 = 1.0f;
        return matrix3f;
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GivensParameters.class, "sinHalf;cosHalf", "a", "b"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GivensParameters.class, "sinHalf;cosHalf", "a", "b"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GivensParameters.class, "sinHalf;cosHalf", "a", "b"}, this, object);
    }

    public float d() {
        return this.a;
    }

    public float e() {
        return this.b;
    }
}

