/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.concurrentutil.map.SWMRLong2ObjectHashTable;
import co.aikar.timings.MinecraftTimings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.poi.PoiChunk;
import io.papermc.paper.chunk.system.scheduling.ChunkLoadTask;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkQueue;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.chunk.system.scheduling.ThreadedTicketLevelPropagator;
import io.papermc.paper.threadedregions.TickRegions;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public final class ChunkHolderManager {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    public static final int FULL_LOADED_TICKET_LEVEL = 33;
    public static final int BLOCK_TICKING_TICKET_LEVEL = 32;
    public static final int ENTITY_TICKING_TICKET_LEVEL = 31;
    public static final int MAX_TICKET_LEVEL = ChunkLevel.a;
    private static final long NO_TIMEOUT_MARKER = Long.MIN_VALUE;
    private static final long PROBE_MARKER = -9223372036854775807L;
    public final ReentrantAreaLock ticketLockArea = new ReentrantAreaLock(ChunkTaskScheduler.getChunkSystemLockShift());
    private final ConcurrentHashMap<RegionFileIOThread.ChunkCoordinate, ArraySetSorted<Ticket<?>>> tickets = new ConcurrentHashMap();
    private final ConcurrentHashMap<RegionFileIOThread.ChunkCoordinate, Long2IntOpenHashMap> sectionToChunkToExpireCount = new ConcurrentHashMap();
    final ChunkQueue unloadQueue;
    private final SWMRLong2ObjectHashTable<NewChunkHolder> chunkHolders = new SWMRLong2ObjectHashTable(16384, 0.25f);
    private final Long2ObjectOpenHashMap<Long2IntOpenHashMap> removeTickToChunkExpireTicketCount = new Long2ObjectOpenHashMap();
    private final WorldServer world;
    private final ChunkTaskScheduler taskScheduler;
    private long currentTick;
    private final ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = new ArrayDeque();
    private final ObjectRBTreeSet<NewChunkHolder> autoSaveQueue = new ObjectRBTreeSet((c1, c2) -> {
        long coord2;
        if (c1 == c2) {
            return 0;
        }
        int saveTickCompare = Long.compare(c1.lastAutoSave, c2.lastAutoSave);
        if (saveTickCompare != 0) {
            return saveTickCompare;
        }
        long coord1 = CoordinateUtils.getChunkKey(c1.chunkX, c1.chunkZ);
        if (coord1 == (coord2 = CoordinateUtils.getChunkKey(c2.chunkX, c2.chunkZ))) {
            throw new IllegalStateException("Duplicate chunkholder in auto save queue");
        }
        return Long.compare(coord1, coord2);
    });
    private final AtomicLong statusUpgradeId = new AtomicLong();
    protected final ThreadedTicketLevelPropagator ticketLevelPropagator = new ThreadedTicketLevelPropagator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processLevelUpdates(Long2ByteLinkedOpenHashMap updates) {
            ObjectBidirectionalIterator iterator = updates.long2ByteEntrySet().fastIterator();
            while (iterator.hasNext()) {
                int currentLevel;
                Long2ByteMap.Entry entry = (Long2ByteMap.Entry)iterator.next();
                long key = entry.getLongKey();
                int newLevel = ChunkHolderManager.convertBetweenTicketLevels(entry.getByteValue());
                NewChunkHolder current = ChunkHolderManager.this.chunkHolders.get(key);
                if (current == null && newLevel > MAX_TICKET_LEVEL) {
                    iterator.remove();
                    continue;
                }
                int n2 = currentLevel = current == null ? MAX_TICKET_LEVEL + 1 : current.getCurrentTicketLevel();
                if (currentLevel == newLevel) {
                    iterator.remove();
                    continue;
                }
                if (current == null) {
                    current = ChunkHolderManager.this.createChunkHolder(key);
                    SWMRLong2ObjectHashTable<NewChunkHolder> sWMRLong2ObjectHashTable = ChunkHolderManager.this.chunkHolders;
                    synchronized (sWMRLong2ObjectHashTable) {
                        ChunkHolderManager.this.chunkHolders.put(key, current);
                    }
                    current.updateTicketLevel(newLevel);
                    continue;
                }
                current.updateTicketLevel(newLevel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSchedulingUpdates(Long2ByteLinkedOpenHashMap updates, List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedFullStatus) {
            List<ChunkProgressionTask> prev = CURRENT_TICKET_UPDATE_SCHEDULING.get();
            CURRENT_TICKET_UPDATE_SCHEDULING.set(scheduledTasks);
            try {
                LongBidirectionalIterator iterator = updates.keySet().iterator();
                while (iterator.hasNext()) {
                    long key = iterator.nextLong();
                    NewChunkHolder current = ChunkHolderManager.this.chunkHolders.get(key);
                    if (current == null) {
                        throw new IllegalStateException("Expected chunk holder to be created");
                    }
                    current.processTicketLevelUpdate(scheduledTasks, changedFullStatus);
                }
            }
            finally {
                CURRENT_TICKET_UPDATE_SCHEDULING.set(prev);
            }
        }
    };
    private final AtomicLong entityLoadCounter = new AtomicLong();
    private final AtomicLong poiLoadCounter = new AtomicLong();
    private final ThreadLocal<Boolean> BLOCK_TICKET_UPDATES = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<List<ChunkProgressionTask>> CURRENT_TICKET_UPDATE_SCHEDULING = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTicketUpdates(int posX, int posZ) {
        boolean ret;
        int ticketShift = 6;
        int ticketMask = 63;
        ArrayList<ChunkProgressionTask> scheduledTasks = new ArrayList<ChunkProgressionTask>();
        ArrayList<NewChunkHolder> changedFullStatus = new ArrayList<NewChunkHolder>();
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock((posX >> 6) - 1 << 6, (posZ >> 6) - 1 << 6, (posX >> 6) + 1 << 6 | 0x3F, (posZ >> 6) + 1 << 6 | 0x3F);
        try {
            ret = this.processTicketUpdatesNoLock(posX >> 6, posZ >> 6, scheduledTasks, changedFullStatus);
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        this.addChangedStatuses(changedFullStatus);
        int len = scheduledTasks.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ((ChunkProgressionTask)scheduledTasks.get(i2)).schedule();
        }
        return ret;
    }

    private boolean processTicketUpdatesNoLock(int sectionX, int sectionZ, List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedFullStatus) {
        return this.ticketLevelPropagator.performUpdate(sectionX, sectionZ, this.taskScheduler.schedulingLockArea, scheduledTasks, changedFullStatus);
    }

    public ChunkHolderManager(WorldServer world, ChunkTaskScheduler taskScheduler) {
        this.world = world;
        this.taskScheduler = taskScheduler;
        this.unloadQueue = new ChunkQueue(TickRegions.getRegionChunkShift());
    }

    long getNextStatusUpgradeId() {
        return this.statusUpgradeId.incrementAndGet();
    }

    public List<PlayerChunk> getOldChunkHolders() {
        List<NewChunkHolder> holders = this.getChunkHolders();
        ArrayList<PlayerChunk> ret = new ArrayList<PlayerChunk>(holders.size());
        for (NewChunkHolder holder : holders) {
            ret.add(holder.vanillaChunkHolder);
        }
        return ret;
    }

    public List<NewChunkHolder> getChunkHolders() {
        ArrayList<NewChunkHolder> ret = new ArrayList<NewChunkHolder>(this.chunkHolders.size());
        this.chunkHolders.forEachValue(ret::add);
        return ret;
    }

    public int size() {
        return this.chunkHolders.size();
    }

    public void close(boolean save, boolean halt) {
        TickThread.ensureTickThread("Closing world off-main");
        if (halt) {
            LOGGER.info("Waiting 60s for chunk system to halt for world '" + this.world.getWorld().getName() + "'");
            if (!this.taskScheduler.halt(true, TimeUnit.SECONDS.toNanos(60L))) {
                LOGGER.warn("Failed to halt world generation/loading tasks for world '" + this.world.getWorld().getName() + "'");
            } else {
                LOGGER.info("Halted chunk system for world '" + this.world.getWorld().getName() + "'");
            }
        }
        if (save) {
            this.saveAllChunks(true, true, true);
        }
        if (this.world.chunkDataControllerNew.hasTasks() || this.world.entityDataControllerNew.hasTasks() || this.world.poiDataControllerNew.hasTasks()) {
            RegionFileIOThread.flush();
        }
        try {
            this.world.chunkDataControllerNew.getCache().close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close chunk regionfile cache for world '" + this.world.getWorld().getName() + "'", (Throwable)ex);
        }
        try {
            this.world.entityDataControllerNew.getCache().close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close entity regionfile cache for world '" + this.world.getWorld().getName() + "'", (Throwable)ex);
        }
        try {
            this.world.poiDataControllerNew.getCache().close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close poi regionfile cache for world '" + this.world.getWorld().getName() + "'", (Throwable)ex);
        }
    }

    void ensureInAutosave(NewChunkHolder holder) {
        if (!this.autoSaveQueue.contains((Object)holder)) {
            holder.lastAutoSave = MinecraftServer.currentTick;
            this.autoSaveQueue.add((Object)holder);
        }
    }

    public void autoSave() {
        ArrayList<NewChunkHolder> reschedule = new ArrayList<NewChunkHolder>();
        long currentTick = MinecraftServer.currentTickLong;
        long maxSaveTime = currentTick - (long)this.world.paperConfig().chunks.autoSaveInterval.value();
        int autoSaved = 0;
        while (autoSaved < this.world.paperConfig().chunks.maxAutoSaveChunksPerTick && !this.autoSaveQueue.isEmpty()) {
            NewChunkHolder holder = (NewChunkHolder)this.autoSaveQueue.first();
            if (holder.lastAutoSave > maxSaveTime) break;
            this.autoSaveQueue.remove((Object)holder);
            holder.lastAutoSave = currentTick;
            if (holder.save(false, false) != null) {
                ++autoSaved;
            }
            if (!holder.getChunkStatus().a(FullChunkStatus.b)) continue;
            reschedule.add(holder);
        }
        for (NewChunkHolder holder : reschedule) {
            if (!holder.getChunkStatus().a(FullChunkStatus.b)) continue;
            this.autoSaveQueue.add((Object)holder);
        }
    }

    public void saveAllChunks(boolean flush, boolean shutdown, boolean logProgress) {
        long start;
        List<NewChunkHolder> holders = this.getChunkHolders();
        if (logProgress) {
            LOGGER.info("Saving all chunkholders for world '" + this.world.getWorld().getName() + "'");
        }
        DecimalFormat format = new DecimalFormat("#0.00");
        int saved = 0;
        long lastLog = start = System.nanoTime();
        boolean needsFlush = false;
        int flushInterval = 50;
        int savedChunk = 0;
        int savedEntity = 0;
        int savedPoi = 0;
        int len = holders.size();
        for (int i2 = 0; i2 < len; ++i2) {
            long currTime;
            NewChunkHolder holder = holders.get(i2);
            try {
                NewChunkHolder.SaveStat saveStat = holder.save(shutdown, false);
                if (saveStat != null) {
                    ++saved;
                    needsFlush = flush;
                    if (saveStat.savedChunk()) {
                        ++savedChunk;
                    }
                    if (saveStat.savedEntityChunk()) {
                        ++savedEntity;
                    }
                    if (saveStat.savedPoiChunk()) {
                        ++savedPoi;
                    }
                }
            }
            catch (ThreadDeath thr) {
                throw thr;
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to save chunk (" + holder.chunkX + "," + holder.chunkZ + ") in world '" + this.world.getWorld().getName() + "'", thr);
            }
            if (needsFlush && saved % 50 == 0) {
                needsFlush = false;
                RegionFileIOThread.partialFlush(25);
            }
            if (!logProgress || (currTime = System.nanoTime()) - lastLog <= TimeUnit.SECONDS.toNanos(10L)) continue;
            lastLog = currTime;
            LOGGER.info("Saved " + saved + " chunks (" + format.format((double)(i2 + 1) / (double)len * 100.0) + "%) in world '" + this.world.getWorld().getName() + "'");
        }
        if (flush) {
            RegionFileIOThread.flush();
            if (this.world.paperConfig().chunks.flushRegionsOnSave) {
                try {
                    this.world.I.a.regionFileCache.a();
                }
                catch (IOException ex) {
                    LOGGER.error("Exception when flushing regions in world {}", (Object)this.world.getWorld().getName(), (Object)ex);
                }
            }
        }
        if (logProgress) {
            LOGGER.info("Saved " + savedChunk + " block chunks, " + savedEntity + " entity chunks, " + savedPoi + " poi chunks in world '" + this.world.getWorld().getName() + "' in " + format.format(1.0E-9 * (double)(System.nanoTime() - start)) + "s");
        }
    }

    public static int convertBetweenTicketLevels(int level) {
        return ChunkLevel.a - level + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTicketDebugString(long coordinate) {
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(coordinate), CoordinateUtils.getChunkZ(coordinate));
        try {
            ArraySetSorted<Ticket<?>> tickets = this.tickets.get(new RegionFileIOThread.ChunkCoordinate(coordinate));
            String string = tickets != null ? tickets.b().toString() : "no_ticket";
            return string;
        }
        finally {
            if (ticketLock != null) {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> getTicketsCopy() {
        Long2ObjectOpenHashMap ret = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap sections = new Long2ObjectOpenHashMap();
        int sectionShift = ChunkTaskScheduler.getChunkSystemLockShift();
        for (RegionFileIOThread.ChunkCoordinate coord : this.tickets.keySet()) {
            ((List)sections.computeIfAbsent(CoordinateUtils.getChunkKey(CoordinateUtils.getChunkX(coord.key) >> sectionShift, CoordinateUtils.getChunkZ(coord.key) >> sectionShift), keyInMap -> new ArrayList())).add(coord);
        }
        ObjectIterator iterator = sections.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long sectionKey = entry.getLongKey();
            List coordinates = (List)entry.getValue();
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(sectionKey) << sectionShift, CoordinateUtils.getChunkZ(sectionKey) << sectionShift);
            try {
                for (RegionFileIOThread.ChunkCoordinate coord : coordinates) {
                    ArraySetSorted<Ticket<?>> tickets = this.tickets.get(coord);
                    if (tickets == null) continue;
                    ret.put(coord.key, new ArraySetSorted(tickets));
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Plugin> getPluginChunkTickets(int x2, int z2) {
        ImmutableList.Builder ret;
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(x2, z2);
        try {
            long coordinate = CoordinateUtils.getChunkKey(x2, z2);
            ArraySetSorted<Ticket<?>> tickets = this.tickets.get(new RegionFileIOThread.ChunkCoordinate(coordinate));
            if (tickets == null) {
                List<Plugin> list = Collections.emptyList();
                return list;
            }
            ret = ImmutableList.builder();
            for (Ticket<?> ticket : tickets) {
                if (ticket.a() != TicketType.PLUGIN_TICKET) continue;
                ret.add((Object)((Plugin)ticket.c));
            }
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        return ret.build();
    }

    protected final void updateTicketLevel(long coordinate, int ticketLevel) {
        if (ticketLevel > ChunkLevel.a) {
            this.ticketLevelPropagator.removeSource(CoordinateUtils.getChunkX(coordinate), CoordinateUtils.getChunkZ(coordinate));
        } else {
            this.ticketLevelPropagator.setSource(CoordinateUtils.getChunkX(coordinate), CoordinateUtils.getChunkZ(coordinate), ChunkHolderManager.convertBetweenTicketLevels(ticketLevel));
        }
    }

    private static int getTicketLevelAt(ArraySetSorted<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.b().b() : MAX_TICKET_LEVEL + 1;
    }

    public <T> boolean addTicketAtLevel(TicketType<T> type, ChunkCoordIntPair chunkPos, int level, T identifier) {
        return this.addTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkPos), level, identifier);
    }

    public <T> boolean addTicketAtLevel(TicketType<T> type, int chunkX, int chunkZ, int level, T identifier) {
        return this.addTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkX, chunkZ), level, identifier);
    }

    private void addExpireCount(int chunkX, int chunkZ) {
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int sectionShift = TickRegions.getRegionChunkShift();
        RegionFileIOThread.ChunkCoordinate sectionKey = new RegionFileIOThread.ChunkCoordinate(CoordinateUtils.getChunkKey(chunkX >> sectionShift, chunkZ >> sectionShift));
        this.sectionToChunkToExpireCount.computeIfAbsent(sectionKey, keyInMap -> new Long2IntOpenHashMap()).addTo(chunkKey, 1);
    }

    private void removeExpireCount(int chunkX, int chunkZ) {
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int sectionShift = TickRegions.getRegionChunkShift();
        RegionFileIOThread.ChunkCoordinate sectionKey = new RegionFileIOThread.ChunkCoordinate(CoordinateUtils.getChunkKey(chunkX >> sectionShift, chunkZ >> sectionShift));
        Long2IntOpenHashMap removeCounts = this.sectionToChunkToExpireCount.get(sectionKey);
        int prevCount = removeCounts.addTo(chunkKey, -1);
        if (prevCount == 1) {
            removeCounts.remove(chunkKey);
            if (removeCounts.isEmpty()) {
                this.sectionToChunkToExpireCount.remove(sectionKey);
            }
        }
    }

    public <T> boolean addTicketAtLevel(TicketType<T> type, long chunk, int level, T identifier) {
        return this.addTicketAtLevel(type, chunk, level, identifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean addTicketAtLevel(TicketType<T> type, long chunk, int level, T identifier, boolean lock) {
        long removeDelay;
        long l2 = removeDelay = type.k <= 0L ? Long.MIN_VALUE : type.k;
        if (level > MAX_TICKET_LEVEL) {
            return false;
        }
        int chunkX = CoordinateUtils.getChunkX(chunk);
        int chunkZ = CoordinateUtils.getChunkZ(chunk);
        RegionFileIOThread.ChunkCoordinate chunkCoord = new RegionFileIOThread.ChunkCoordinate(chunk);
        Ticket<T> ticket = new Ticket<T>(type, level, identifier, removeDelay);
        ReentrantAreaLock.Node ticketLock = lock ? this.ticketLockArea.lock(chunkX, chunkZ) : null;
        try {
            ArraySetSorted ticketsAtChunk = this.tickets.computeIfAbsent(chunkCoord, keyInMap -> ArraySetSorted.a(4));
            int levelBefore = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            Ticket<T> current = ticketsAtChunk.replace(ticket);
            int levelAfter = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            if (current != ticket) {
                long oldRemoveDelay = current.removeDelay;
                if (removeDelay != oldRemoveDelay) {
                    if (oldRemoveDelay != Long.MIN_VALUE && removeDelay == Long.MIN_VALUE) {
                        this.removeExpireCount(chunkX, chunkZ);
                    } else if (oldRemoveDelay == Long.MIN_VALUE) {
                        this.addExpireCount(chunkX, chunkZ);
                    }
                }
            } else if (removeDelay != Long.MIN_VALUE) {
                this.addExpireCount(chunkX, chunkZ);
            }
            if (levelBefore != levelAfter) {
                this.updateTicketLevel(chunk, levelAfter);
            }
            boolean bl = current == ticket;
            return bl;
        }
        finally {
            if (ticketLock != null) {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    public <T> boolean removeTicketAtLevel(TicketType<T> type, ChunkCoordIntPair chunkPos, int level, T identifier) {
        return this.removeTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkPos), level, identifier);
    }

    public <T> boolean removeTicketAtLevel(TicketType<T> type, int chunkX, int chunkZ, int level, T identifier) {
        return this.removeTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkX, chunkZ), level, identifier);
    }

    public <T> boolean removeTicketAtLevel(TicketType<T> type, long chunk, int level, T identifier) {
        return this.removeTicketAtLevel(type, chunk, level, identifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean removeTicketAtLevel(TicketType<T> type, long chunk, int level, T identifier, boolean lock) {
        if (level > MAX_TICKET_LEVEL) {
            return false;
        }
        int chunkX = CoordinateUtils.getChunkX(chunk);
        int chunkZ = CoordinateUtils.getChunkZ(chunk);
        RegionFileIOThread.ChunkCoordinate chunkCoord = new RegionFileIOThread.ChunkCoordinate(chunk);
        Ticket<T> probe = new Ticket<T>(type, level, identifier, -9223372036854775807L);
        ReentrantAreaLock.Node ticketLock = lock ? this.ticketLockArea.lock(chunkX, chunkZ) : null;
        try {
            long removeDelay;
            ArraySetSorted<Ticket<?>> ticketsAtChunk = this.tickets.get(chunkCoord);
            if (ticketsAtChunk == null) {
                boolean bl = false;
                return bl;
            }
            int oldLevel = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            Ticket<T> ticket = ticketsAtChunk.removeAndGet(probe);
            if (ticket == null) {
                boolean bl = false;
                return bl;
            }
            int newLevel = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            if (oldLevel != newLevel) {
                long timeout;
                TicketType<ChunkCoordIntPair> toAdd;
                long delayTimeout = this.world.paperConfig().chunks.delayChunkUnloadsBy.ticks();
                if (type == RegionizedPlayerChunkLoader.REGION_PLAYER_TICKET && delayTimeout > 0L) {
                    toAdd = TicketType.DELAY_UNLOAD;
                    timeout = delayTimeout;
                } else {
                    toAdd = TicketType.h;
                    timeout = Math.max(1L, toAdd.k);
                }
                Ticket<ChunkCoordIntPair> unknownTicket = new Ticket<ChunkCoordIntPair>(toAdd, level, new ChunkCoordIntPair(chunk), timeout);
                if (ticketsAtChunk.add(unknownTicket)) {
                    this.addExpireCount(chunkX, chunkZ);
                } else {
                    throw new IllegalStateException("Should have been able to add " + unknownTicket + " to " + ticketsAtChunk);
                }
            }
            if ((removeDelay = ticket.removeDelay) != Long.MIN_VALUE) {
                this.removeExpireCount(chunkX, chunkZ);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (ticketLock != null) {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V> void addAndRemoveTickets(long chunk, TicketType<T> addType, int addLevel, T addIdentifier, TicketType<V> removeType, int removeLevel, V removeIdentifier) {
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(chunk), CoordinateUtils.getChunkZ(chunk));
        try {
            this.addTicketAtLevel(addType, chunk, addLevel, addIdentifier, false);
            this.removeTicketAtLevel(removeType, chunk, removeLevel, removeIdentifier, false);
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V> boolean addIfRemovedTicket(long chunk, TicketType<T> addType, int addLevel, T addIdentifier, TicketType<V> removeType, int removeLevel, V removeIdentifier) {
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(chunk), CoordinateUtils.getChunkZ(chunk));
        try {
            if (this.removeTicketAtLevel(removeType, chunk, removeLevel, removeIdentifier, false)) {
                this.addTicketAtLevel(addType, chunk, addLevel, addIdentifier, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        if (ticketLevel > MAX_TICKET_LEVEL) {
            return;
        }
        Long2ObjectOpenHashMap sections = new Long2ObjectOpenHashMap();
        int sectionShift = ChunkTaskScheduler.getChunkSystemLockShift();
        for (RegionFileIOThread.ChunkCoordinate coord : this.tickets.keySet()) {
            ((List)sections.computeIfAbsent(CoordinateUtils.getChunkKey(CoordinateUtils.getChunkX(coord.key) >> sectionShift, CoordinateUtils.getChunkZ(coord.key) >> sectionShift), keyInMap -> new ArrayList())).add(coord);
        }
        ObjectIterator iterator = sections.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long sectionKey = entry.getLongKey();
            List coordinates = (List)entry.getValue();
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(sectionKey) << sectionShift, CoordinateUtils.getChunkZ(sectionKey) << sectionShift);
            try {
                for (RegionFileIOThread.ChunkCoordinate coord : coordinates) {
                    this.removeTicketAtLevel(ticketType, coord.key, ticketLevel, ticketIdentifier, false);
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        int sectionShift = TickRegions.getRegionChunkShift();
        Predicate<Ticket> expireNow = ticket -> {
            if (ticket.removeDelay == Long.MIN_VALUE) {
                return false;
            }
            return --ticket.removeDelay <= 0L;
        };
        for (RegionFileIOThread.ChunkCoordinate section : this.sectionToChunkToExpireCount.keySet()) {
            long sectionKey = section.key;
            if (!this.sectionToChunkToExpireCount.containsKey(section)) continue;
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(sectionKey) << sectionShift, CoordinateUtils.getChunkZ(sectionKey) << sectionShift);
            try {
                Long2IntOpenHashMap chunkToExpireCount = this.sectionToChunkToExpireCount.get(section);
                if (chunkToExpireCount == null) continue;
                ObjectIterator iterator1 = chunkToExpireCount.long2IntEntrySet().fastIterator();
                while (iterator1.hasNext()) {
                    int newExpireCount;
                    Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator1.next();
                    long chunkKey = entry.getLongKey();
                    int expireCount = entry.getIntValue();
                    RegionFileIOThread.ChunkCoordinate chunk = new RegionFileIOThread.ChunkCoordinate(chunkKey);
                    ArraySetSorted<Ticket<?>> tickets = this.tickets.get(chunk);
                    int levelBefore = ChunkHolderManager.getTicketLevelAt(tickets);
                    int sizeBefore = tickets.size();
                    tickets.removeIf((Predicate<Ticket<?>>)expireNow);
                    int sizeAfter = tickets.size();
                    int levelAfter = ChunkHolderManager.getTicketLevelAt(tickets);
                    if (tickets.isEmpty()) {
                        this.tickets.remove(chunk);
                    }
                    if (levelBefore != levelAfter) {
                        this.updateTicketLevel(chunkKey, levelAfter);
                    }
                    if ((newExpireCount = expireCount - (sizeBefore - sizeAfter)) == expireCount) continue;
                    if (newExpireCount != 0) {
                        entry.setValue(newExpireCount);
                        continue;
                    }
                    iterator1.remove();
                }
                if (!chunkToExpireCount.isEmpty()) continue;
                this.sectionToChunkToExpireCount.remove(section);
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
        this.processTicketUpdates();
    }

    public NewChunkHolder getChunkHolder(int chunkX, int chunkZ) {
        return this.chunkHolders.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public NewChunkHolder getChunkHolder(long position) {
        return this.chunkHolders.get(position);
    }

    public void raisePriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x2, z2);
        if (chunkHolder != null) {
            chunkHolder.raisePriority(priority);
        }
    }

    public void setPriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x2, z2);
        if (chunkHolder != null) {
            chunkHolder.setPriority(priority);
        }
    }

    public void lowerPriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x2, z2);
        if (chunkHolder != null) {
            chunkHolder.lowerPriority(priority);
        }
    }

    private NewChunkHolder createChunkHolder(long position) {
        NewChunkHolder ret = new NewChunkHolder(this.world, CoordinateUtils.getChunkX(position), CoordinateUtils.getChunkZ(position), this.taskScheduler);
        ChunkSystem.onChunkHolderCreate(this.world, ret.vanillaChunkHolder);
        ret.vanillaChunkHolder.onChunkAdd();
        return ret;
    }

    private NewChunkHolder getOrCreateChunkHolder(int chunkX, int chunkZ) {
        return this.getOrCreateChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NewChunkHolder getOrCreateChunkHolder(long position) {
        int chunkZ;
        int chunkX = CoordinateUtils.getChunkX(position);
        if (!this.ticketLockArea.isHeldByCurrentThread(chunkX, chunkZ = CoordinateUtils.getChunkZ(position))) {
            throw new IllegalStateException("Must hold ticket level update lock!");
        }
        if (!this.taskScheduler.schedulingLockArea.isHeldByCurrentThread(chunkX, chunkZ)) {
            throw new IllegalStateException("Must hold scheduler lock!!");
        }
        NewChunkHolder current = this.chunkHolders.get(position);
        if (current != null) {
            return current;
        }
        current = this.createChunkHolder(position);
        SWMRLong2ObjectHashTable<NewChunkHolder> sWMRLong2ObjectHashTable = this.chunkHolders;
        synchronized (sWMRLong2ObjectHashTable) {
            this.chunkHolders.put(position, current);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkEntitySlices getOrCreateEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        ChunkEntitySlices ret;
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Cannot create entity chunk off-main");
        NewChunkHolder current = this.getChunkHolder(chunkX, chunkZ);
        if (current != null && (ret = current.getEntityChunk()) != null && (transientChunk || !ret.isTransient())) {
            return ret;
        }
        AtomicBoolean isCompleted = new AtomicBoolean();
        Thread waiter = Thread.currentThread();
        Long entityLoadId = this.entityLoadCounter.getAndIncrement();
        NewChunkHolder.GenericDataLoadTaskCallback loadTask = null;
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(chunkX, chunkZ);
        try {
            this.addTicketAtLevel(TicketType.ENTITY_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, entityLoadId);
            ReentrantAreaLock.Node schedulingLock = this.taskScheduler.schedulingLockArea.lock(chunkX, chunkZ);
            try {
                current = this.getOrCreateChunkHolder(chunkX, chunkZ);
                ret = current.getEntityChunk();
                if (ret != null && (transientChunk || !ret.isTransient())) {
                    this.removeTicketAtLevel(TicketType.ENTITY_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, entityLoadId);
                    ChunkEntitySlices chunkEntitySlices = ret;
                    return chunkEntitySlices;
                }
                if (current.isEntityChunkNBTLoaded()) {
                    isCompleted.setPlain(true);
                } else {
                    loadTask = current.getOrLoadEntityData(result -> {
                        if (!transientChunk) {
                            isCompleted.set(true);
                            LockSupport.unpark(waiter);
                        }
                    });
                    ChunkLoadTask.EntityDataLoadTask entityLoad = current.getEntityDataLoadTask();
                    if (entityLoad != null && !transientChunk) {
                        entityLoad.raisePriority(PrioritisedExecutor.Priority.BLOCKING);
                    }
                }
            }
            finally {
                this.taskScheduler.schedulingLockArea.unlock(schedulingLock);
            }
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        if (loadTask != null) {
            loadTask.schedule();
        }
        if (!transientChunk) {
            boolean interrupted = false;
            while (!isCompleted.get()) {
                interrupted |= Thread.interrupted();
                LockSupport.park();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        ret = current.loadInEntityChunk(transientChunk);
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        this.addAndRemoveTickets(chunkKey, TicketType.h, MAX_TICKET_LEVEL, new ChunkCoordIntPair(chunkX, chunkZ), TicketType.ENTITY_LOAD, MAX_TICKET_LEVEL, entityLoadId);
        return ret;
    }

    public PoiChunk getPoiChunkIfLoaded(int chunkX, int chunkZ, boolean checkLoadInCallback) {
        NewChunkHolder holder = this.getChunkHolder(chunkX, chunkZ);
        if (holder != null) {
            PoiChunk ret = holder.getPoiChunk();
            return ret == null || checkLoadInCallback && !ret.isLoaded() ? null : ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoiChunk loadPoiChunk(int chunkX, int chunkZ) {
        PoiChunk ret;
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Cannot create poi chunk off-main");
        NewChunkHolder current = this.getChunkHolder(chunkX, chunkZ);
        if (current != null && (ret = current.getPoiChunk()) != null) {
            if (!ret.isLoaded()) {
                ret.load();
            }
            return ret;
        }
        AtomicReference completed = new AtomicReference();
        AtomicBoolean isCompleted = new AtomicBoolean();
        Thread waiter = Thread.currentThread();
        Long poiLoadId = this.poiLoadCounter.getAndIncrement();
        NewChunkHolder.GenericDataLoadTaskCallback loadTask = null;
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(chunkX, chunkZ);
        try {
            this.addTicketAtLevel(TicketType.POI_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, poiLoadId);
            ReentrantAreaLock.Node schedulingLock = this.taskScheduler.schedulingLockArea.lock(chunkX, chunkZ);
            try {
                current = this.getOrCreateChunkHolder(chunkX, chunkZ);
                if (current.isPoiChunkLoaded()) {
                    this.removeTicketAtLevel(TicketType.POI_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, poiLoadId);
                    PoiChunk poiChunk = current.getPoiChunk();
                    return poiChunk;
                }
                loadTask = current.getOrLoadPoiData(result -> {
                    completed.setPlain((PoiChunk)result.left());
                    isCompleted.set(true);
                    LockSupport.unpark(waiter);
                });
                ChunkLoadTask.PoiDataLoadTask poiLoad = current.getPoiDataLoadTask();
                if (poiLoad != null) {
                    poiLoad.raisePriority(PrioritisedExecutor.Priority.BLOCKING);
                }
            }
            finally {
                this.taskScheduler.schedulingLockArea.unlock(schedulingLock);
            }
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        if (loadTask != null) {
            loadTask.schedule();
        }
        boolean interrupted = false;
        while (!isCompleted.get()) {
            interrupted |= Thread.interrupted();
            LockSupport.park();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        ret = (PoiChunk)completed.getPlain();
        ret.load();
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        this.addAndRemoveTickets(chunkKey, TicketType.h, MAX_TICKET_LEVEL, new ChunkCoordIntPair(chunkX, chunkZ), TicketType.POI_LOAD, MAX_TICKET_LEVEL, poiLoadId);
        return ret;
    }

    void addChangedStatuses(List<NewChunkHolder> changedFullStatus) {
        if (changedFullStatus.isEmpty()) {
            return;
        }
        if (!TickThread.isTickThread()) {
            this.taskScheduler.scheduleChunkTask(() -> {
                ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
                int len = changedFullStatus.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    pendingFullLoadUpdate.add((NewChunkHolder)changedFullStatus.get(i2));
                }
                this.processPendingFullUpdate();
            }, PrioritisedExecutor.Priority.HIGHEST);
        } else {
            ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
            int len = changedFullStatus.size();
            for (int i2 = 0; i2 < len; ++i2) {
                pendingFullLoadUpdate.add(changedFullStatus.get(i2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunkHolder(NewChunkHolder holder) {
        holder.killed = true;
        holder.vanillaChunkHolder.onChunkRemove();
        this.autoSaveQueue.remove((Object)holder);
        ChunkSystem.onChunkHolderDelete(this.world, holder.vanillaChunkHolder);
        SWMRLong2ObjectHashTable<NewChunkHolder> sWMRLong2ObjectHashTable = this.chunkHolders;
        synchronized (sWMRLong2ObjectHashTable) {
            this.chunkHolders.remove(CoordinateUtils.getChunkKey(holder.chunkX, holder.chunkZ));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUnloads() {
        TickThread.ensureTickThread("Cannot unload chunks off-main");
        if (this.BLOCK_TICKET_UPDATES.get() == Boolean.TRUE) {
            throw new IllegalStateException("Cannot unload chunks recursively");
        }
        int sectionShift = this.unloadQueue.coordinateShift;
        List<ChunkQueue.SectionToUnload> unloadSectionsForRegion = this.unloadQueue.retrieveForAllRegions();
        int unloadCountTentative = 0;
        for (ChunkQueue.SectionToUnload sectionRef : unloadSectionsForRegion) {
            ChunkQueue.UnloadSection section = this.unloadQueue.getSectionUnsynchronized(sectionRef.sectionX(), sectionRef.sectionZ());
            if (section == null) continue;
            unloadCountTentative += section.chunks.size();
        }
        if (unloadCountTentative <= 0) {
            return;
        }
        this.processTicketUpdates();
        int toUnloadCount = Math.max(50, (int)((double)unloadCountTentative * 0.05));
        int processedCount = 0;
        for (ChunkQueue.SectionToUnload sectionRef : unloadSectionsForRegion) {
            NewChunkHolder holder;
            int i2;
            int len;
            ArrayList<NewChunkHolder> stage1 = new ArrayList<NewChunkHolder>();
            ArrayList<NewChunkHolder.UnloadState> stage2 = new ArrayList<NewChunkHolder.UnloadState>();
            int sectionLowerX = sectionRef.sectionX() << sectionShift;
            int sectionLowerZ = sectionRef.sectionZ() << sectionShift;
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(sectionLowerX, sectionLowerZ);
            try {
                ReentrantAreaLock.Node scheduleLock = this.taskScheduler.schedulingLockArea.lock(sectionLowerX, sectionLowerZ);
                try {
                    ChunkQueue.UnloadSection section = this.unloadQueue.getSectionUnsynchronized(sectionRef.sectionX(), sectionRef.sectionZ());
                    if (section == null) continue;
                    int sectionCount = section.chunks.size();
                    if (sectionCount + processedCount <= toUnloadCount) {
                        LongListIterator iterator = section.chunks.iterator();
                        while (iterator.hasNext()) {
                            NewChunkHolder holder2 = this.chunkHolders.get(iterator.nextLong());
                            if (holder2 == null) {
                                throw new IllegalStateException();
                            }
                            stage1.add(holder2);
                        }
                        this.unloadQueue.removeSection(sectionRef.sectionX(), sectionRef.sectionZ());
                    } else {
                        len = toUnloadCount - processedCount;
                        for (i2 = 0; i2 < len; ++i2) {
                            holder = this.chunkHolders.get(section.chunks.removeFirstLong());
                            if (holder == null) {
                                throw new IllegalStateException();
                            }
                            stage1.add(holder);
                        }
                    }
                    int len2 = stage1.size();
                    for (i2 = 0; i2 < len2; ++i2) {
                        NewChunkHolder chunkHolder = (NewChunkHolder)stage1.get(i2);
                        if (chunkHolder.isSafeToUnload() != null) {
                            LOGGER.error("Chunkholder " + chunkHolder + " is not safe to unload but is inside the unload queue?");
                            continue;
                        }
                        NewChunkHolder.UnloadState state = chunkHolder.unloadStage1();
                        if (state == null) {
                            this.removeChunkHolder(chunkHolder);
                            continue;
                        }
                        stage2.add(state);
                    }
                }
                finally {
                    this.taskScheduler.schedulingLockArea.unlock(scheduleLock);
                    continue;
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
                continue;
            }
            ArrayList<NewChunkHolder> stage3 = new ArrayList<NewChunkHolder>(stage2.size());
            Boolean before = this.blockTicketUpdates();
            try {
                int len3 = stage2.size();
                for (int i3 = 0; i3 < len3; ++i3) {
                    NewChunkHolder.UnloadState state = (NewChunkHolder.UnloadState)stage2.get(i3);
                    holder = state.holder();
                    holder.unloadStage2(state);
                    stage3.add(holder);
                }
            }
            finally {
                this.unblockTicketUpdates(before);
            }
            ticketLock = this.ticketLockArea.lock(sectionLowerX, sectionLowerZ);
            try {
                ReentrantAreaLock.Node scheduleLock = this.taskScheduler.schedulingLockArea.lock(sectionLowerX, sectionLowerZ);
                try {
                    len = stage3.size();
                    for (i2 = 0; i2 < len; ++i2) {
                        holder = (NewChunkHolder)stage3.get(i2);
                        if (holder.unloadStage3()) {
                            this.removeChunkHolder(holder);
                            continue;
                        }
                        this.addTicketAtLevel(TicketType.UNLOAD_COOLDOWN, CoordinateUtils.getChunkKey(holder.chunkX, holder.chunkZ), MAX_TICKET_LEVEL, Unit.a, false);
                    }
                }
                finally {
                    this.taskScheduler.schedulingLockArea.unlock(scheduleLock);
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
            }
            if ((processedCount += stage1.size()) < toUnloadCount) continue;
            break;
        }
    }

    private boolean processTicketOp(TicketOperation operation) {
        boolean ret = false;
        switch (operation.op) {
            case ADD: {
                ret |= this.addTicketAtLevel(operation.ticketType, operation.chunkCoord, operation.ticketLevel, operation.identifier);
                break;
            }
            case REMOVE: {
                ret |= this.removeTicketAtLevel(operation.ticketType, operation.chunkCoord, operation.ticketLevel, operation.identifier);
                break;
            }
            case ADD_IF_REMOVED: {
                ret |= this.addIfRemovedTicket(operation.chunkCoord, operation.ticketType, operation.ticketLevel, operation.identifier, operation.ticketType2, operation.ticketLevel2, operation.identifier2);
                break;
            }
            case ADD_AND_REMOVE: {
                ret = true;
                this.addAndRemoveTickets(operation.chunkCoord, operation.ticketType, operation.ticketLevel, operation.identifier, operation.ticketType2, operation.ticketLevel2, operation.identifier2);
            }
        }
        return ret;
    }

    public void performTicketUpdates(Collection<TicketOperation<?, ?>> operations) {
        for (TicketOperation<?, ?> operation : operations) {
            this.processTicketOp(operation);
        }
    }

    public Boolean blockTicketUpdates() {
        Boolean ret = this.BLOCK_TICKET_UPDATES.get();
        this.BLOCK_TICKET_UPDATES.set(Boolean.TRUE);
        return ret;
    }

    public void unblockTicketUpdates(Boolean before) {
        this.BLOCK_TICKET_UPDATES.set(before);
    }

    public boolean processTicketUpdates() {
        MinecraftTimings.distanceManagerTick.startTiming();
        try {
            boolean bl = this.processTicketUpdates(true, true, null);
            return bl;
        }
        finally {
            MinecraftTimings.distanceManagerTick.stopTiming();
        }
    }

    static List<ChunkProgressionTask> getCurrentTicketUpdateScheduling() {
        return CURRENT_TICKET_UPDATE_SCHEDULING.get();
    }

    private boolean processTicketUpdates(boolean checkLocks, boolean processFullUpdates, List<ChunkProgressionTask> scheduledTasks) {
        boolean canProcessScheduling;
        TickThread.ensureTickThread("Cannot process ticket levels off-main");
        if (this.BLOCK_TICKET_UPDATES.get() == Boolean.TRUE) {
            throw new IllegalStateException("Cannot update ticket level while unloading chunks or updating entity manager");
        }
        ArrayList<NewChunkHolder> changedFullStatus = null;
        boolean isTickThread = TickThread.isTickThread();
        boolean ret = false;
        boolean canProcessFullUpdates = processFullUpdates & isTickThread;
        boolean bl = canProcessScheduling = scheduledTasks == null;
        if (this.ticketLevelPropagator.hasPendingUpdates()) {
            if (scheduledTasks == null) {
                scheduledTasks = new ArrayList<ChunkProgressionTask>();
            }
            changedFullStatus = new ArrayList<NewChunkHolder>();
            ret |= this.ticketLevelPropagator.performUpdates(this.ticketLockArea, this.taskScheduler.schedulingLockArea, scheduledTasks, changedFullStatus);
        }
        if (changedFullStatus != null) {
            this.addChangedStatuses(changedFullStatus);
        }
        if (canProcessScheduling && scheduledTasks != null) {
            int len = scheduledTasks.size();
            for (int i2 = 0; i2 < len; ++i2) {
                scheduledTasks.get(i2).schedule();
            }
        }
        if (canProcessFullUpdates) {
            ret |= this.processPendingFullUpdate();
        }
        return ret;
    }

    protected final boolean processPendingFullUpdate() {
        NewChunkHolder holder;
        ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
        boolean ret = false;
        ArrayList<NewChunkHolder> changedFullStatus = new ArrayList<NewChunkHolder>();
        while ((holder = pendingFullLoadUpdate.poll()) != null) {
            ret |= holder.handleFullStatusChange(changedFullStatus);
            if (changedFullStatus.isEmpty()) continue;
            int len = changedFullStatus.size();
            for (int i2 = 0; i2 < len; ++i2) {
                pendingFullLoadUpdate.add((NewChunkHolder)changedFullStatus.get(i2));
            }
            changedFullStatus.clear();
        }
        return ret;
    }

    public JsonObject getDebugJsonForWatchdog() {
        return this.getDebugJsonNoLock();
    }

    private JsonObject getDebugJsonNoLock() {
        JsonObject ret = new JsonObject();
        ret.addProperty("current_tick", (Number)this.currentTick);
        JsonArray unloadQueue = new JsonArray();
        ret.add("unload_queue", (JsonElement)unloadQueue);
        ret.addProperty("lock_shift", (Number)ChunkTaskScheduler.getChunkSystemLockShift());
        ret.addProperty("ticket_shift", (Number)6);
        ret.addProperty("region_shift", (Number)TickRegions.getRegionChunkShift());
        for (ChunkQueue.SectionToUnload section : this.unloadQueue.retrieveForAllRegions()) {
            JsonObject sectionJson = new JsonObject();
            unloadQueue.add((JsonElement)sectionJson);
            sectionJson.addProperty("sectionX", (Number)section.sectionX());
            sectionJson.addProperty("sectionZ", (Number)section.sectionX());
            sectionJson.addProperty("order", (Number)section.order());
            JsonArray coordinates = new JsonArray();
            sectionJson.add("coordinates", (JsonElement)coordinates);
            ChunkQueue.UnloadSection actualSection = this.unloadQueue.getSectionUnsynchronized(section.sectionX(), section.sectionZ());
            LongListIterator iterator = actualSection.chunks.iterator();
            while (iterator.hasNext()) {
                long coordinate = iterator.nextLong();
                JsonObject coordinateJson = new JsonObject();
                coordinates.add((JsonElement)coordinateJson);
                coordinateJson.addProperty("chunkX", (Number)CoordinateUtils.getChunkX(coordinate));
                coordinateJson.addProperty("chunkZ", (Number)CoordinateUtils.getChunkZ(coordinate));
            }
        }
        JsonArray holders = new JsonArray();
        ret.add("chunkholders", (JsonElement)holders);
        for (NewChunkHolder holder : this.getChunkHolders()) {
            holders.add((JsonElement)holder.getDebugJson());
        }
        return ret;
    }

    public JsonObject getDebugJson() {
        return this.getDebugJsonNoLock();
    }

    public record TicketOperation<T, V>(TicketOperationType op, long chunkCoord, TicketType<T> ticketType, int ticketLevel, T identifier, TicketType<V> ticketType2, int ticketLevel2, V identifier2) {
        private TicketOperation(TicketOperationType op, long chunkCoord, TicketType<T> ticketType, int ticketLevel, T identifier) {
            this(op, chunkCoord, ticketType, ticketLevel, identifier, null, 0, null);
        }

        public static <T> TicketOperation<T, T> addOp(ChunkCoordIntPair chunk, TicketType<T> type, int ticketLevel, T identifier) {
            return TicketOperation.addOp(CoordinateUtils.getChunkKey(chunk), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> addOp(int chunkX, int chunkZ, TicketType<T> type, int ticketLevel, T identifier) {
            return TicketOperation.addOp(CoordinateUtils.getChunkKey(chunkX, chunkZ), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> addOp(long chunk, TicketType<T> type, int ticketLevel, T identifier) {
            return new TicketOperation(TicketOperationType.ADD, chunk, type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> removeOp(ChunkCoordIntPair chunk, TicketType<T> type, int ticketLevel, T identifier) {
            return TicketOperation.removeOp(CoordinateUtils.getChunkKey(chunk), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> removeOp(int chunkX, int chunkZ, TicketType<T> type, int ticketLevel, T identifier) {
            return TicketOperation.removeOp(CoordinateUtils.getChunkKey(chunkX, chunkZ), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> removeOp(long chunk, TicketType<T> type, int ticketLevel, T identifier) {
            return new TicketOperation(TicketOperationType.REMOVE, chunk, type, ticketLevel, identifier);
        }

        public static <T, V> TicketOperation<T, V> addIfRemovedOp(long chunk, TicketType<T> addType, int addLevel, T addIdentifier, TicketType<V> removeType, int removeLevel, V removeIdentifier) {
            return new TicketOperation<T, V>(TicketOperationType.ADD_IF_REMOVED, chunk, addType, addLevel, addIdentifier, removeType, removeLevel, removeIdentifier);
        }

        public static <T, V> TicketOperation<T, V> addAndRemove(long chunk, TicketType<T> addType, int addLevel, T addIdentifier, TicketType<V> removeType, int removeLevel, V removeIdentifier) {
            return new TicketOperation<T, V>(TicketOperationType.ADD_AND_REMOVE, chunk, addType, addLevel, addIdentifier, removeType, removeLevel, removeIdentifier);
        }
    }

    public static enum TicketOperationType {
        ADD,
        REMOVE,
        ADD_IF_REMOVED,
        ADD_AND_REMOVE;

    }
}

