/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;

public abstract class ChunkProgressionTask {
    private final MultiThreadedQueue<BiConsumer<IChunkAccess, Throwable>> waiters = new MultiThreadedQueue();
    private IChunkAccess completedChunk;
    private Throwable completedThrowable;
    protected final ChunkTaskScheduler scheduler;
    protected final WorldServer world;
    protected final int chunkX;
    protected final int chunkZ;
    protected volatile boolean completed;
    protected static final VarHandle COMPLETED_HANDLE = ConcurrentUtil.getVarHandle(ChunkProgressionTask.class, "completed", Boolean.TYPE);

    protected ChunkProgressionTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ) {
        this.scheduler = scheduler;
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public abstract boolean isScheduled();

    public abstract ChunkStatus getTargetStatus();

    public abstract void schedule();

    public abstract void cancel();

    public abstract PrioritisedExecutor.Priority getPriority();

    public abstract void lowerPriority(PrioritisedExecutor.Priority var1);

    public abstract void setPriority(PrioritisedExecutor.Priority var1);

    public abstract void raisePriority(PrioritisedExecutor.Priority var1);

    public final void onComplete(BiConsumer<IChunkAccess, Throwable> onComplete) {
        block3: {
            if (!this.waiters.add(onComplete)) {
                try {
                    onComplete.accept(this.completedChunk, this.completedThrowable);
                }
                catch (Throwable throwable) {
                    this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Consumer", ChunkTaskScheduler.stringIfNull(onComplete), "Completed throwable", ChunkTaskScheduler.stringIfNull(this.completedThrowable)), throwable);
                    if (!(throwable instanceof ThreadDeath)) break block3;
                    throw (ThreadDeath)throwable;
                }
            }
        }
    }

    protected final void complete(IChunkAccess chunk, Throwable throwable) {
        block2: {
            try {
                this.complete0(chunk, throwable);
            }
            catch (Throwable thr2) {
                this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Completed throwable", ChunkTaskScheduler.stringIfNull(throwable)), thr2);
                if (!(thr2 instanceof ThreadDeath)) break block2;
                throw (ThreadDeath)thr2;
            }
        }
    }

    private void complete0(IChunkAccess chunk, Throwable throwable) {
        BiConsumer<IChunkAccess, Throwable> consumer;
        if (COMPLETED_HANDLE.getAndSet(this, true)) {
            throw new IllegalStateException("Already completed");
        }
        this.completedChunk = chunk;
        this.completedThrowable = throwable;
        while ((consumer = this.waiters.pollOrBlockAdds()) != null) {
            consumer.accept(chunk, throwable);
        }
    }

    public String toString() {
        return "ChunkProgressionTask{class: " + this.getClass().getName() + ", for world: " + this.world.getWorld().getName() + ", chunk: (" + this.chunkX + "," + this.chunkZ + "), hashcode: " + System.identityHashCode(this) + ", priority: " + this.getPriority() + ", status: " + this.getTargetStatus().toString() + ", scheduled: " + this.isScheduled() + "}";
    }
}

