/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.command.CommandUtil;
import io.papermc.paper.command.PaperSubcommand;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ChunkDebugCommand
implements PaperSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        switch (subCommand) {
            case "debug": {
                this.doDebug(sender, args);
                break;
            }
            case "chunkinfo": {
                this.doChunkInfo(sender, args);
                break;
            }
            case "holderinfo": {
                this.doHolderInfo(sender, args);
            }
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        switch (subCommand) {
            case "debug": {
                if (args.length != 1) break;
                return CommandUtil.getListMatchingLast(sender, args, "help", "chunks");
            }
            case "holderinfo": {
                ArrayList<String> worldNames = new ArrayList<String>();
                worldNames.add("*");
                for (World world : Bukkit.getWorlds()) {
                    worldNames.add(world.getName());
                }
                if (args.length != 1) break;
                return CommandUtil.getListMatchingLast(sender, args, worldNames);
            }
            case "chunkinfo": {
                ArrayList<String> worldNames = new ArrayList<String>();
                worldNames.add("*");
                for (World world : Bukkit.getWorlds()) {
                    worldNames.add(world.getName());
                }
                if (args.length != 1) break;
                return CommandUtil.getListMatchingLast(sender, args, worldNames);
            }
        }
        return Collections.emptyList();
    }

    private void doChunkInfo(CommandSender sender, String[] args) {
        ArrayList<World> worlds;
        if (args.length < 1 || args[0].equals("*")) {
            worlds = Bukkit.getWorlds();
        } else {
            worlds = new ArrayList<World>(args.length);
            for (String arg : args) {
                @Nullable World world = Bukkit.getWorld((String)arg);
                if (world == null) {
                    sender.sendMessage((Component)Component.text((String)("World '" + arg + "' is invalid"), (TextColor)NamedTextColor.RED));
                    return;
                }
                worlds.add(world);
            }
        }
        int accumulatedTotal = 0;
        int accumulatedInactive = 0;
        int accumulatedBorder = 0;
        int accumulatedTicking = 0;
        int accumulatedEntityTicking = 0;
        for (World bukkitWorld : worlds) {
            WorldServer world = ((CraftWorld)bukkitWorld).getHandle();
            int total = 0;
            int inactive = 0;
            int full = 0;
            int blockTicking = 0;
            int entityTicking = 0;
            for (PlayerChunk chunk : ChunkSystem.getVisibleChunkHolders(world)) {
                if (chunk.getFullChunkNowUnchecked() == null) continue;
                ++total;
                FullChunkStatus state = chunk.i();
                switch (state) {
                    case a: {
                        ++inactive;
                        break;
                    }
                    case b: {
                        ++full;
                        break;
                    }
                    case c: {
                        ++blockTicking;
                        break;
                    }
                    case d: {
                        ++entityTicking;
                    }
                }
            }
            accumulatedTotal += total;
            accumulatedInactive += inactive;
            accumulatedBorder += full;
            accumulatedTicking += blockTicking;
            accumulatedEntityTicking += entityTicking;
            sender.sendMessage((ComponentLike)Component.text().append(new Component[]{Component.text((String)"Chunks in ", (TextColor)NamedTextColor.BLUE), Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.GREEN), Component.text((String)":")}));
            sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Total: ", (TextColor)NamedTextColor.BLUE), Component.text((int)total), Component.text((String)" Inactive: ", (TextColor)NamedTextColor.BLUE), Component.text((int)inactive), Component.text((String)" Full: ", (TextColor)NamedTextColor.BLUE), Component.text((int)full), Component.text((String)" Block Ticking: ", (TextColor)NamedTextColor.BLUE), Component.text((int)blockTicking), Component.text((String)" Entity Ticking: ", (TextColor)NamedTextColor.BLUE), Component.text((int)entityTicking)}));
        }
        if (worlds.size() > 1) {
            sender.sendMessage((ComponentLike)Component.text().append(new Component[]{Component.text((String)"Chunks in ", (TextColor)NamedTextColor.BLUE), Component.text((String)"all listed worlds", (TextColor)NamedTextColor.GREEN), Component.text((String)":", (TextColor)NamedTextColor.DARK_AQUA)}));
            sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Total: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedTotal), Component.text((String)" Inactive: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedInactive), Component.text((String)" Full: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedBorder), Component.text((String)" Block Ticking: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedTicking), Component.text((String)" Entity Ticking: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedEntityTicking)}));
        }
    }

    private void doHolderInfo(CommandSender sender, String[] args) {
        ArrayList<World> worlds;
        if (args.length < 1 || args[0].equals("*")) {
            worlds = Bukkit.getWorlds();
        } else {
            worlds = new ArrayList<World>(args.length);
            for (String arg : args) {
                @Nullable World world = Bukkit.getWorld((String)arg);
                if (world == null) {
                    sender.sendMessage((Component)Component.text((String)("World '" + arg + "' is invalid"), (TextColor)NamedTextColor.RED));
                    return;
                }
                worlds.add(world);
            }
        }
        int accumulatedTotal = 0;
        int accumulatedCanUnload = 0;
        int accumulatedNull = 0;
        int accumulatedReadOnly = 0;
        int accumulatedProtoChunk = 0;
        int accumulatedFullChunk = 0;
        for (World bukkitWorld : worlds) {
            WorldServer world = ((CraftWorld)bukkitWorld).getHandle();
            int total = 0;
            int canUnload = 0;
            int nullChunks = 0;
            int readOnly = 0;
            int protoChunk = 0;
            int fullChunk = 0;
            for (PlayerChunk chunk : world.chunkTaskScheduler.chunkHolderManager.getOldChunkHolders()) {
                IChunkAccess lastChunk = chunk.getAvailableChunkNow();
                ++total;
                if (lastChunk == null) {
                    ++nullChunks;
                } else if (lastChunk instanceof ProtoChunkExtension) {
                    ++readOnly;
                } else if (lastChunk instanceof ProtoChunk) {
                    ++protoChunk;
                } else if (lastChunk instanceof Chunk) {
                    ++fullChunk;
                }
                if (chunk.newChunkHolder.isSafeToUnload() != null) continue;
                ++canUnload;
            }
            accumulatedTotal += total;
            accumulatedCanUnload += canUnload;
            accumulatedNull += nullChunks;
            accumulatedReadOnly += readOnly;
            accumulatedProtoChunk += protoChunk;
            accumulatedFullChunk += fullChunk;
            sender.sendMessage((ComponentLike)Component.text().append(new Component[]{Component.text((String)"Chunks in ", (TextColor)NamedTextColor.BLUE), Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.GREEN), Component.text((String)":")}));
            sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Total: ", (TextColor)NamedTextColor.BLUE), Component.text((int)total), Component.text((String)" Unloadable: ", (TextColor)NamedTextColor.BLUE), Component.text((int)canUnload), Component.text((String)" Null: ", (TextColor)NamedTextColor.BLUE), Component.text((int)nullChunks), Component.text((String)" ReadOnly: ", (TextColor)NamedTextColor.BLUE), Component.text((int)readOnly), Component.text((String)" Proto: ", (TextColor)NamedTextColor.BLUE), Component.text((int)protoChunk), Component.text((String)" Full: ", (TextColor)NamedTextColor.BLUE), Component.text((int)fullChunk)}));
        }
        if (worlds.size() > 1) {
            sender.sendMessage((ComponentLike)Component.text().append(new Component[]{Component.text((String)"Chunks in ", (TextColor)NamedTextColor.BLUE), Component.text((String)"all listed worlds", (TextColor)NamedTextColor.GREEN), Component.text((String)":", (TextColor)NamedTextColor.DARK_AQUA)}));
            sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Total: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedTotal), Component.text((String)" Unloadable: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedCanUnload), Component.text((String)" Null: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedNull), Component.text((String)" ReadOnly: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedReadOnly), Component.text((String)" Proto: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedProtoChunk), Component.text((String)" Full: ", (TextColor)NamedTextColor.BLUE), Component.text((int)accumulatedFullChunk)}));
        }
    }

    private void doDebug(CommandSender sender, String[] args) {
        String debugType;
        if (args.length < 1) {
            sender.sendMessage((Component)Component.text((String)"Use /paper debug [chunks] help for more information on a specific command", (TextColor)NamedTextColor.RED));
            return;
        }
        switch (debugType = args[0].toLowerCase(Locale.ENGLISH)) {
            case "chunks": {
                if (args.length >= 2 && args[1].toLowerCase(Locale.ENGLISH).equals("help")) {
                    sender.sendMessage((Component)Component.text((String)"Use /paper debug chunks [world] to dump loaded chunk information to a file", (TextColor)NamedTextColor.RED));
                    break;
                }
                File file = new File(new File(new File("."), "debug"), "chunks-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + ".txt");
                sender.sendMessage((Component)Component.text((String)("Writing chunk information dump to " + file), (TextColor)NamedTextColor.GREEN));
                try {
                    MCUtil.dumpChunks(file, false);
                    sender.sendMessage((Component)Component.text((String)"Successfully written chunk information!", (TextColor)NamedTextColor.GREEN));
                }
                catch (Throwable thr) {
                    MinecraftServer.n.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage((Component)Component.text((String)"Failed to dump chunk information, see console", (TextColor)NamedTextColor.RED));
                }
                break;
            }
            default: {
                sender.sendMessage((Component)Component.text((String)"Use /paper debug [chunks] help for more information on a specific command", (TextColor)NamedTextColor.RED));
            }
        }
    }
}

