/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration;

import io.leangen.geantyref.GenericTypeReflector;
import io.papermc.paper.configuration.ConfigurationPart;
import io.papermc.paper.configuration.Configurations;
import io.papermc.paper.configuration.MergeMap;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.configuration.WorldConfiguration;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedSupplier;

final class InnerClassFieldDiscoverer
implements FieldDiscoverer<Map<Field, Object>> {
    private final Map<Class<?>, Object> instanceMap = new HashMap();
    private final Map<Class<?>, Object> overrides;
    private final FieldDiscoverer<Map<Field, Object>> delegate = FieldDiscoverer.object(target -> {
        Class type = GenericTypeReflector.erase((Type)target.getType());
        if (this.overrides().containsKey(type)) {
            this.instanceMap.put(type, this.overrides().get(type));
            return () -> this.overrides().get(type);
        }
        if (ConfigurationPart.class.isAssignableFrom(type) && !this.instanceMap.containsKey(type)) {
            try {
                CheckedSupplier instanceSupplier;
                Constructor constructor;
                Object instance;
                if (type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
                    instance = this.instanceMap.get(type.getEnclosingClass());
                    if (instance == null) {
                        throw new SerializationException("Cannot create a new instance of an inner class " + type.getName() + " without an instance of its enclosing class " + type.getEnclosingClass().getName());
                    }
                    constructor = type.getDeclaredConstructor(type.getEnclosingClass());
                    instanceSupplier = () -> constructor.newInstance(instance);
                } else {
                    constructor = type.getDeclaredConstructor(new Class[0]);
                    instanceSupplier = () -> constructor.newInstance(new Object[0]);
                }
                constructor.setAccessible(true);
                instance = instanceSupplier.get();
                this.instanceMap.put(type, instance);
                return () -> instance;
            }
            catch (ReflectiveOperationException e2) {
                throw new SerializationException(ConfigurationPart.class, target + " must be a valid ConfigurationPart", (Throwable)e2);
            }
        }
        throw new SerializationException(target + " must be a valid ConfigurationPart");
    }, (String)"Object must be a unique ConfigurationPart");

    InnerClassFieldDiscoverer(Map<Class<?>, Object> overrides) {
        this.overrides = overrides;
    }

    public <V> // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FieldDiscoverer.InstanceFactory<Map<Field, Object>> discover(final AnnotatedType target, FieldDiscoverer.FieldCollector<Map<Field, Object>, V> collector) throws SerializationException {
        FieldDiscoverer.InstanceFactory instanceFactoryDelegate;
        Class clazz = GenericTypeReflector.erase((Type)target.getType());
        if (ConfigurationPart.class.isAssignableFrom(clazz) && (instanceFactoryDelegate = this.delegate.discover(target, (name, type, annotations, deserializer, serializer) -> {
            if (!GenericTypeReflector.erase((Type)type.getType()).equals(clazz.getEnclosingClass())) {
                collector.accept(name, type, annotations, deserializer, serializer);
            }
        })) instanceof FieldDiscoverer.MutableInstanceFactory) {
            final FieldDiscoverer.MutableInstanceFactory mutableInstanceFactoryDelegate = (FieldDiscoverer.MutableInstanceFactory)instanceFactoryDelegate;
            return new FieldDiscoverer.MutableInstanceFactory<Map<Field, Object>>(){

                public Map<Field, Object> begin() {
                    return (Map)mutableInstanceFactoryDelegate.begin();
                }

                public void complete(Object instance, Map<Field, Object> intermediate) throws SerializationException {
                    Iterator<Map.Entry<Field, Object>> iter = intermediate.entrySet().iterator();
                    try {
                        while (iter.hasNext()) {
                            Object object;
                            Map.Entry<Field, Object> entry = iter.next();
                            if (!entry.getKey().isAnnotationPresent(MergeMap.class) || !Map.class.isAssignableFrom(entry.getKey().getType()) || !((object = intermediate.get(entry.getKey())) instanceof Map)) continue;
                            Map map = (Map)object;
                            iter.remove();
                            @Nullable Map existingMap = (Map)entry.getKey().get(instance);
                            if (existingMap != null) {
                                existingMap.putAll(map);
                                continue;
                            }
                            entry.getKey().set(instance, entry.getValue());
                        }
                    }
                    catch (IllegalAccessException e2) {
                        throw new SerializationException(target.getType(), (Throwable)e2);
                    }
                    mutableInstanceFactoryDelegate.complete(instance, intermediate);
                }

                public Object complete(Map<Field, Object> intermediate) throws SerializationException {
                    @Nullable Object targetInstance = InnerClassFieldDiscoverer.this.instanceMap.get(GenericTypeReflector.erase((Type)target.getType()));
                    if (targetInstance != null) {
                        this.complete(targetInstance, intermediate);
                    } else {
                        targetInstance = mutableInstanceFactoryDelegate.complete(intermediate);
                    }
                    if (targetInstance instanceof ConfigurationPart.Post) {
                        ConfigurationPart.Post post = (ConfigurationPart.Post)targetInstance;
                        post.postProcess();
                    }
                    return targetInstance;
                }

                public boolean canCreateInstances() {
                    return mutableInstanceFactoryDelegate.canCreateInstances();
                }
            };
        }
        return null;
    }

    private Map<Class<?>, Object> overrides() {
        return this.overrides;
    }

    static FieldDiscoverer<?> worldConfig(Configurations.ContextMap contextMap) {
        Map<Class<?>, Object> overrides = Map.of(WorldConfiguration.class, new WorldConfiguration(contextMap.require(PaperConfigurations.SPIGOT_WORLD_CONFIG_CONTEXT_KEY).get(), contextMap.require(Configurations.WORLD_KEY)));
        return new InnerClassFieldDiscoverer(overrides);
    }

    static FieldDiscoverer<?> globalConfig() {
        return new InnerClassFieldDiscoverer(Collections.emptyMap());
    }
}

