/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader.group;

import io.papermc.paper.plugin.provider.classloader.ClassLoaderAccess;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LockingClassLoaderGroup
implements PluginClassLoaderGroup {
    private final PluginClassLoaderGroup parent;
    private final Map<String, ClassLockEntry> classLoadLock = new HashMap<String, ClassLockEntry>();

    public LockingClassLoaderGroup(PluginClassLoaderGroup parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> getClassByName(String name, boolean resolve, ConfiguredPluginClassLoader requester) {
        ClassLockEntry lock;
        Object object = this.classLoadLock;
        synchronized (object) {
            lock = this.classLoadLock.computeIfAbsent(name, x2 -> new ClassLockEntry(new AtomicInteger(0), new ReentrantReadWriteLock()));
            lock.count.incrementAndGet();
        }
        lock.reentrantReadWriteLock.writeLock().lock();
        try {
            object = this.parent.getClassByName(name, resolve, requester);
            return object;
        }
        finally {
            Map<String, ClassLockEntry> map = this.classLoadLock;
            synchronized (map) {
                lock.reentrantReadWriteLock.writeLock().unlock();
                if (lock.count.get() == 1) {
                    this.classLoadLock.remove(name);
                } else {
                    lock.count.decrementAndGet();
                }
            }
        }
    }

    public void remove(ConfiguredPluginClassLoader configuredPluginClassLoader) {
        this.parent.remove(configuredPluginClassLoader);
    }

    public void add(ConfiguredPluginClassLoader configuredPluginClassLoader) {
        this.parent.add(configuredPluginClassLoader);
    }

    public ClassLoaderAccess getAccess() {
        return this.parent.getAccess();
    }

    public PluginClassLoaderGroup getParent() {
        return this.parent;
    }

    public String toString() {
        return "LockingClassLoaderGroup{parent=" + this.parent + ", classLoadLock=" + this.classLoadLock + "}";
    }

    record ClassLockEntry(AtomicInteger count, ReentrantReadWriteLock reentrantReadWriteLock) {
    }
}

