/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader.group;

import io.papermc.paper.plugin.entrypoint.classloader.group.GlobalPluginClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.classloader.group.LockingClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.classloader.group.SpigotPluginClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.classloader.group.StaticPluginClassLoaderGroup;
import io.papermc.paper.plugin.provider.classloader.ClassLoaderAccess;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.plugin.java.PluginClassLoader;
import org.jetbrains.annotations.ApiStatus;

public final class PaperPluginClassLoaderStorage
implements PaperClassLoaderStorage {
    private final GlobalPluginClassLoaderGroup globalGroup = new GlobalPluginClassLoaderGroup();
    private final List<PluginClassLoaderGroup> groups = new CopyOnWriteArrayList<PluginClassLoaderGroup>();

    public PaperPluginClassLoaderStorage() {
        this.groups.add(this.globalGroup);
    }

    public PluginClassLoaderGroup registerSpigotGroup(PluginClassLoader pluginClassLoader) {
        return this.registerGroup((ConfiguredPluginClassLoader)pluginClassLoader, new SpigotPluginClassLoaderGroup(this.globalGroup, library -> pluginClassLoader.dependencyContext.isTransitiveDependency(pluginClassLoader.getConfiguration(), library.getConfiguration()), pluginClassLoader));
    }

    public PluginClassLoaderGroup registerOpenGroup(ConfiguredPluginClassLoader classLoader) {
        return this.registerGroup(classLoader, this.globalGroup);
    }

    public PluginClassLoaderGroup registerAccessBackedGroup(ConfiguredPluginClassLoader classLoader, ClassLoaderAccess access) {
        ArrayList<ConfiguredPluginClassLoader> allowedLoaders = new ArrayList<ConfiguredPluginClassLoader>();
        for (ConfiguredPluginClassLoader configuredPluginClassLoader : this.globalGroup.getClassLoaders()) {
            if (!access.canAccess(configuredPluginClassLoader)) continue;
            allowedLoaders.add(configuredPluginClassLoader);
        }
        return this.registerGroup(classLoader, new StaticPluginClassLoaderGroup(allowedLoaders, access, classLoader));
    }

    private PluginClassLoaderGroup registerGroup(ConfiguredPluginClassLoader classLoader, PluginClassLoaderGroup group) {
        for (PluginClassLoaderGroup loaderGroup : this.groups) {
            if (!loaderGroup.getAccess().canAccess(classLoader)) continue;
            loaderGroup.add(classLoader);
        }
        group = new LockingClassLoaderGroup(group);
        this.groups.add(group);
        return group;
    }

    public void unregisterClassloader(ConfiguredPluginClassLoader configuredPluginClassLoader) {
        this.globalGroup.remove(configuredPluginClassLoader);
        this.groups.remove(configuredPluginClassLoader.getGroup());
        for (PluginClassLoaderGroup group : this.groups) {
            group.remove(configuredPluginClassLoader);
        }
    }

    public boolean registerUnsafePlugin(ConfiguredPluginClassLoader pluginLoader) {
        if (this.globalGroup.getClassLoaders().contains(pluginLoader)) {
            return false;
        }
        this.globalGroup.add(pluginLoader);
        return true;
    }

    @ApiStatus.Internal
    public GlobalPluginClassLoaderGroup getGlobalGroup() {
        return this.globalGroup;
    }

    @ApiStatus.Internal
    public List<PluginClassLoaderGroup> getGroups() {
        return this.groups;
    }
}

