/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.dependency;

import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import java.util.Set;

public class GraphDependencyContext
implements DependencyContext {
    private final MutableGraph<String> dependencyGraph;

    public GraphDependencyContext(MutableGraph<String> dependencyGraph) {
        this.dependencyGraph = dependencyGraph;
    }

    public boolean isTransitiveDependency(PluginMeta plugin, PluginMeta depend) {
        String pluginIdentifier = plugin.getName();
        if (this.dependencyGraph.nodes().contains(pluginIdentifier)) {
            Set reachableNodes = Graphs.reachableNodes(this.dependencyGraph, (Object)pluginIdentifier);
            if (reachableNodes.contains(depend.getName())) {
                return true;
            }
            for (String provided : depend.getProvidedPlugins()) {
                if (!reachableNodes.contains(provided)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDependency(String pluginIdentifier) {
        return this.dependencyGraph.nodes().contains(pluginIdentifier);
    }

    public MutableGraph<String> getDependencyGraph() {
        return this.dependencyGraph;
    }

    public String toString() {
        return "GraphDependencyContext{dependencyGraph=" + this.dependencyGraph + "}";
    }
}

