/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.configuration.serializer;

import com.google.common.collect.ImmutableCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.util.CheckedConsumer;

public abstract class ImmutableCollectionSerializer<B extends ImmutableCollection.Builder<?>, T extends Collection<?>>
implements TypeSerializer<T> {
    protected ImmutableCollectionSerializer() {
    }

    public final T deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        if (node.isList()) {
            List values = node.childrenList();
            B builder = this.createNew(values.size());
            for (ConfigurationNode value : values) {
                try {
                    this.deserializeSingle(builder, entrySerial.deserialize(entryType, value));
                }
                catch (SerializationException ex) {
                    ex.initPath(() -> ((ConfigurationNode)value).path());
                    throw ex;
                }
            }
            return (T)builder.build();
        }
        @Nullable Object unwrappedVal = node.raw();
        if (unwrappedVal != null) {
            B builder = this.createNew(1);
            this.deserializeSingle(builder, entrySerial.deserialize(entryType, node));
            return (T)builder.build();
        }
        return (T)this.emptyValue(type, null);
    }

    public final void serialize(Type type, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        node.raw(Collections.emptyList());
        if (obj != null) {
            this.forEachElement(obj, (CheckedConsumer<Object, SerializationException>)((CheckedConsumer)el -> {
                ConfigurationNode child = node.appendListNode();
                try {
                    entrySerial.serialize(entryType, el, child);
                }
                catch (SerializationException ex) {
                    ex.initPath(() -> ((ConfigurationNode)child).path());
                    throw ex;
                }
            }));
        }
    }

    public @Nullable T emptyValue(Type specificType, ConfigurationOptions options) {
        return (T)this.createNew(0).build();
    }

    protected abstract Type elementType(Type var1) throws SerializationException;

    protected abstract B createNew(int var1);

    protected abstract void forEachElement(T var1, CheckedConsumer<Object, SerializationException> var2) throws SerializationException;

    protected abstract void deserializeSingle(B var1, @Nullable Object var2) throws SerializationException;
}

