/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;

public final class CoordinateUtils {
    static final int SECTION_X_BITS = 22;
    static final long SECTION_X_MASK = 0x3FFFFFL;
    static final int SECTION_Y_BITS = 20;
    static final long SECTION_Y_MASK = 1048575L;
    static final int SECTION_Z_BITS = 22;
    static final long SECTION_Z_MASK = 0x3FFFFFL;
    static final int SECTION_Y_SHIFT = 0;
    static final int SECTION_Z_SHIFT = 20;
    static final int SECTION_X_SHIFT = 42;
    static final int SECTION_TO_BLOCK_SHIFT = 4;

    public static int getNeighbourMappedIndex(int dx, int dz, int radius) {
        return dx + radius + (2 * radius + 1) * (dz + radius);
    }

    public static long getChunkKey(BlockPosition pos) {
        return (long)(pos.w() >> 4) << 32 | (long)(pos.u() >> 4) & 0xFFFFFFFFL;
    }

    public static long getChunkKey(Entity entity) {
        return MathHelper.b(entity.dt()) >> 4 << 32 | MathHelper.b(entity.dn()) >> 4 & 0xFFFFFFFFL;
    }

    public static long getChunkKey(ChunkCoordIntPair pos) {
        return (long)pos.f << 32 | (long)pos.e & 0xFFFFFFFFL;
    }

    public static long getChunkKey(SectionPosition pos) {
        return (long)pos.w() << 32 | (long)pos.u() & 0xFFFFFFFFL;
    }

    public static long getChunkKey(int x2, int z2) {
        return (long)z2 << 32 | (long)x2 & 0xFFFFFFFFL;
    }

    public static int getChunkX(long chunkKey) {
        return (int)chunkKey;
    }

    public static int getChunkZ(long chunkKey) {
        return (int)(chunkKey >>> 32);
    }

    public static int getChunkCoordinate(double blockCoordinate) {
        return MathHelper.a(blockCoordinate) >> 4;
    }

    public static long getChunkSectionKey(int x2, int y2, int z2) {
        return ((long)x2 & 0x3FFFFFL) << 42 | ((long)y2 & 0xFFFFFL) << 0 | ((long)z2 & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(SectionPosition pos) {
        return ((long)pos.u() & 0x3FFFFFL) << 42 | ((long)pos.v() & 0xFFFFFL) << 0 | ((long)pos.w() & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(ChunkCoordIntPair pos, int y2) {
        return ((long)pos.e & 0x3FFFFFL) << 42 | ((long)y2 & 0xFFFFFL) << 0 | ((long)pos.f & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(BlockPosition pos) {
        return (long)pos.u() << 38 & 0xFFFFFC0000000000L | (long)(pos.v() >> 4) & 0xFFFFFL | (long)pos.w() << 16 & 0x3FFFFF00000L;
    }

    public static long getChunkSectionKey(Entity entity) {
        return MathHelper.b(entity.dn()) << 38 & 0xFFFFFC0000000000L | MathHelper.b(entity.dp()) >> 4 & 0xFFFFFL | MathHelper.b(entity.dt()) << 16 & 0x3FFFFF00000L;
    }

    public static int getChunkSectionX(long key) {
        return (int)(key << 0 >> 42);
    }

    public static int getChunkSectionY(long key) {
        return (int)(key << 44 >> 44);
    }

    public static int getChunkSectionZ(long key) {
        return (int)(key << 22 >> 42);
    }

    public static int getBlockCoordinate(double blockCoordinate) {
        return MathHelper.a(blockCoordinate);
    }

    public static long getBlockKey(int x2, int y2, int z2) {
        return (long)x2 & 0x7FFFFFFL | ((long)z2 & 0x7FFFFFFL) << 27 | (long)y2 << 54;
    }

    public static long getBlockKey(BlockPosition pos) {
        return (long)pos.u() & 0x7FFFFFFL | ((long)pos.w() & 0x7FFFFFFL) << 27 | (long)pos.v() << 54;
    }

    public static long getBlockKey(Entity entity) {
        return (long)entity.dn() & 0x7FFFFFFL | ((long)entity.dt() & 0x7FFFFFFL) << 27 | (long)entity.dp() << 54;
    }

    private CoordinateUtils() {
        throw new RuntimeException();
    }
}

