/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum ObfHelper {
    INSTANCE;

    public static final String MOJANG_PLUS_YARN_NAMESPACE = "mojang+yarn";
    public static final String SPIGOT_NAMESPACE = "spigot";
    private final @Nullable Map<String, ClassMapping> mappingsByObfName;
    private final @Nullable Map<String, ClassMapping> mappingsByMojangName;

    private ObfHelper() {
        @Nullable Set<ClassMapping> maps = ObfHelper.loadMappingsIfPresent();
        if (maps != null) {
            this.mappingsByObfName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::obfName, map -> map));
            this.mappingsByMojangName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::mojangName, map -> map));
        } else {
            this.mappingsByObfName = null;
            this.mappingsByMojangName = null;
        }
    }

    public @Nullable Map<String, ClassMapping> mappingsByObfName() {
        return this.mappingsByObfName;
    }

    public @Nullable Map<String, ClassMapping> mappingsByMojangName() {
        return this.mappingsByMojangName;
    }

    public String reobfClassName(String fullyQualifiedMojangName) {
        if (this.mappingsByMojangName == null) {
            return fullyQualifiedMojangName;
        }
        ClassMapping map = this.mappingsByMojangName.get(fullyQualifiedMojangName);
        if (map == null) {
            return fullyQualifiedMojangName;
        }
        return map.obfName();
    }

    public String deobfClassName(String fullyQualifiedObfName) {
        if (this.mappingsByObfName == null) {
            return fullyQualifiedObfName;
        }
        ClassMapping map = this.mappingsByObfName.get(fullyQualifiedObfName);
        if (map == null) {
            return fullyQualifiedObfName;
        }
        return map.mojangName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable Set<ClassMapping> loadMappingsIfPresent() {
        try (@Nullable InputStream mappingsInputStream = ObfHelper.class.getClassLoader().getResourceAsStream("META-INF/mappings/reobf.tiny");){
            if (mappingsInputStream == null) {
                Set<ClassMapping> set2 = null;
                return set2;
            }
            MemoryMappingTree tree = new MemoryMappingTree();
            MappingReader.read((Reader)new InputStreamReader(mappingsInputStream, StandardCharsets.UTF_8), (MappingFormat)MappingFormat.TINY_2, (MappingVisitor)tree);
            HashSet<ClassMapping> classes = new HashSet<ClassMapping>();
            StringPool pool = new StringPool();
            for (MappingTree.ClassMapping cls : tree.getClasses()) {
                HashMap<String, String> methods = new HashMap<String, String>();
                for (MappingTree.MethodMapping methodMapping : cls.getMethods()) {
                    methods.put(pool.string(ObfHelper.methodKey(methodMapping.getName(SPIGOT_NAMESPACE), methodMapping.getDesc(SPIGOT_NAMESPACE))), pool.string(methodMapping.getName(MOJANG_PLUS_YARN_NAMESPACE)));
                }
                ClassMapping map = new ClassMapping(cls.getName(SPIGOT_NAMESPACE).replace('/', '.'), cls.getName(MOJANG_PLUS_YARN_NAMESPACE).replace('/', '.'), Map.copyOf(methods));
                classes.add(map);
            }
            Set set = Set.copyOf(classes);
            return set;
        }
        catch (IOException ex) {
            System.err.println("Failed to load mappings for stacktrace deobfuscation.");
            ex.printStackTrace();
            return null;
        }
    }

    public static String methodKey(String obfName, String obfDescriptor) {
        return obfName + obfDescriptor;
    }

    public record ClassMapping(String obfName, String mojangName, Map<String, String> methodsByObf) {
    }

    private static final class StringPool {
        private final Map<String, String> pool = new HashMap<String, String>();

        private StringPool() {
        }

        public String string(String string) {
            return this.pool.computeIfAbsent(string, Function.identity());
        }
    }
}

