/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ObfHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public enum StacktraceDeobfuscator {
    INSTANCE;

    private final Map<Class<?>, Map<String, IntList>> lineMapCache = Collections.synchronizedMap(new LinkedHashMap<Class<?>, Map<String, IntList>>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class<?>, Map<String, IntList>> eldest) {
            return this.size() > 127;
        }
    });

    public void deobfuscateThrowable(Throwable throwable) {
        if (GlobalConfiguration.get() != null && !GlobalConfiguration.get().logging.deobfuscateStacktraces) {
            return;
        }
        throwable.setStackTrace(this.deobfuscateStacktrace(throwable.getStackTrace()));
        Throwable cause = throwable.getCause();
        if (cause != null) {
            this.deobfuscateThrowable(cause);
        }
        for (Throwable suppressed : throwable.getSuppressed()) {
            this.deobfuscateThrowable(suppressed);
        }
    }

    public StackTraceElement[] deobfuscateStacktrace(StackTraceElement[] traceElements) {
        if (GlobalConfiguration.get() != null && !GlobalConfiguration.get().logging.deobfuscateStacktraces) {
            return traceElements;
        }
        @Nullable Map<String, ObfHelper.ClassMapping> mappings = ObfHelper.INSTANCE.mappingsByObfName();
        if (mappings == null || traceElements.length == 0) {
            return traceElements;
        }
        StackTraceElement[] result = new StackTraceElement[traceElements.length];
        for (int i2 = 0; i2 < traceElements.length; ++i2) {
            Class<?> clazz;
            StackTraceElement element = traceElements[i2];
            String className = element.getClassName();
            String methodName = element.getMethodName();
            ObfHelper.ClassMapping classMapping = mappings.get(className);
            if (classMapping == null) {
                result[i2] = element;
                continue;
            }
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            @Nullable String methodKey = this.determineMethodForLine(clazz, element.getLineNumber());
            @Nullable String mappedMethodName = methodKey == null ? null : classMapping.methodsByObf().get(methodKey);
            result[i2] = new StackTraceElement(element.getClassLoaderName(), element.getModuleName(), element.getModuleVersion(), classMapping.mojangName(), mappedMethodName != null ? mappedMethodName : methodName, StacktraceDeobfuscator.sourceFileName(classMapping.mojangName()), element.getLineNumber());
        }
        return result;
    }

    private @Nullable String determineMethodForLine(Class<?> clazz, int lineNumber) {
        Map lineMap = this.lineMapCache.computeIfAbsent(clazz, StacktraceDeobfuscator::buildLineMap);
        for (Map.Entry entry : lineMap.entrySet()) {
            String methodKey = (String)entry.getKey();
            IntList lines = (IntList)entry.getValue();
            int linesSize = lines.size();
            for (int i2 = 0; i2 < linesSize; ++i2) {
                int num = lines.getInt(i2);
                if (num != lineNumber) continue;
                return methodKey;
            }
        }
        return null;
    }

    private static String sourceFileName(String fullClassName) {
        int dot = fullClassName.lastIndexOf(46);
        String className = dot == -1 ? fullClassName : fullClassName.substring(dot + 1);
        String rootClassName = className.split("\\$")[0];
        return rootClassName + ".java";
    }

    private static Map<String, IntList> buildLineMap(Class<?> key) {
        final HashMap<String, IntList> lineMap = new HashMap<String, IntList>();
        ClassVisitor classVisitor = new ClassVisitor(589824){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                final class LineCollectingMethodVisitor
                extends MethodVisitor {
                    private final IntList lines;
                    private final String name;
                    private final String descriptor;
                    final /* synthetic */ Map val$lineMap;

                    LineCollectingMethodVisitor(String descriptor, String map) {
                        this.val$lineMap = map;
                        super(589824);
                        this.lines = new IntArrayList();
                        this.name = name;
                        this.descriptor = descriptor;
                    }

                    public void visitLineNumber(int line, Label start) {
                        super.visitLineNumber(line, start);
                        this.lines.add(line);
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        this.val$lineMap.put(ObfHelper.methodKey(this.name, this.descriptor), this.lines);
                    }
                }
                return new LineCollectingMethodVisitor(name, descriptor, lineMap);
            }
        };
        try {
            byte[] classData;
            @Nullable InputStream inputStream = StacktraceDeobfuscator.class.getClassLoader().getResourceAsStream(key.getName().replace('.', '/') + ".class");
            if (inputStream == null) {
                throw new IllegalStateException("Could not find class file: " + key.getName());
            }
            try (InputStream inputStream2 = inputStream;){
                classData = inputStream.readAllBytes();
            }
            ClassReader reader = new ClassReader(classData);
            reader.accept(classVisitor, 0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return lineMap;
    }
}

