/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class TickThread
extends Thread {
    public static final boolean STRICT_THREAD_CHECKS = Boolean.getBoolean("paper.strict-thread-checks");
    public final int id;
    private static final AtomicInteger ID_GENERATOR;

    @Deprecated
    public static void softEnsureTickThread(String reason) {
        if (!STRICT_THREAD_CHECKS) {
            return;
        }
        TickThread.ensureTickThread(reason);
    }

    @Deprecated
    public static void ensureTickThread(String reason) {
        if (!TickThread.isTickThread()) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(WorldServer world, BlockPosition pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(WorldServer world, ChunkCoordIntPair pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(WorldServer world, int chunkX, int chunkZ, String reason) {
        if (!TickThread.isTickThreadFor(world, chunkX, chunkZ)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Entity entity, String reason) {
        if (!TickThread.isTickThreadFor(entity)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(WorldServer world, AxisAlignedBB aabb, String reason) {
        if (!TickThread.isTickThreadFor(world, aabb)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(WorldServer world, double blockX, double blockZ, String reason) {
        if (!TickThread.isTickThreadFor(world, blockX, blockZ)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public TickThread(String name) {
        this((Runnable)null, name);
    }

    public TickThread(Runnable run, String name) {
        this(run, name, ID_GENERATOR.incrementAndGet());
    }

    private TickThread(Runnable run, String name, int id) {
        super(run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    public static boolean isTickThread() {
        return Thread.currentThread() instanceof TickThread;
    }

    public static boolean isShutdownThread() {
        return false;
    }

    public static boolean isTickThreadFor(WorldServer world, BlockPosition pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, ChunkCoordIntPair pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, Vec3D pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, int chunkX, int chunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, AxisAlignedBB aabb) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, double blockX, double blockZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, Vec3D position, Vec3D deltaMovement, int buffer) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, int fromChunkX, int fromChunkZ, int toChunkX, int toChunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(WorldServer world, int chunkX, int chunkZ, int radius) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Entity entity) {
        return TickThread.isTickThread();
    }

    static {
        if (STRICT_THREAD_CHECKS) {
            MinecraftServer.n.warn("Strict thread checks enabled - performance may suffer");
        }
        ID_GENERATOR = new AtomicInteger();
    }
}

