/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;

public class CriterionConditionItem {
    public static final CriterionConditionItem a = new CriterionConditionItem();
    @Nullable
    private final TagKey<Item> b;
    @Nullable
    private final Set<Item> c;
    private final CriterionConditionValue.IntegerRange d;
    private final CriterionConditionValue.IntegerRange e;
    private final CriterionConditionEnchantments[] f;
    private final CriterionConditionEnchantments[] g;
    @Nullable
    private final PotionRegistry h;
    private final CriterionConditionNBT i;

    public CriterionConditionItem() {
        this.b = null;
        this.c = null;
        this.h = null;
        this.d = CriterionConditionValue.IntegerRange.e;
        this.e = CriterionConditionValue.IntegerRange.e;
        this.f = CriterionConditionEnchantments.b;
        this.g = CriterionConditionEnchantments.b;
        this.i = CriterionConditionNBT.a;
    }

    public CriterionConditionItem(@Nullable TagKey<Item> tag, @Nullable Set<Item> items, CriterionConditionValue.IntegerRange count, CriterionConditionValue.IntegerRange durability, CriterionConditionEnchantments[] enchantments, CriterionConditionEnchantments[] storedEnchantments, @Nullable PotionRegistry potion, CriterionConditionNBT nbt) {
        this.b = tag;
        this.c = items;
        this.d = count;
        this.e = durability;
        this.f = enchantments;
        this.g = storedEnchantments;
        this.h = potion;
        this.i = nbt;
    }

    public boolean a(ItemStack stack) {
        if (this == a) {
            return true;
        }
        if (this.b != null && !stack.a(this.b)) {
            return false;
        }
        if (this.c != null && !this.c.contains(stack.d())) {
            return false;
        }
        if (!this.d.d(stack.L())) {
            return false;
        }
        if (!this.e.c() && !stack.i()) {
            return false;
        }
        if (!this.e.d(stack.l() - stack.k())) {
            return false;
        }
        if (!this.i.a(stack)) {
            return false;
        }
        if (this.f.length > 0) {
            Map<Enchantment, Integer> map = EnchantmentManager.a(stack.x());
            for (CriterionConditionEnchantments enchantmentPredicate : this.f) {
                if (enchantmentPredicate.a(map)) continue;
                return false;
            }
        }
        if (this.g.length > 0) {
            Map<Enchantment, Integer> map2 = EnchantmentManager.a(ItemEnchantedBook.d(stack));
            for (CriterionConditionEnchantments enchantmentPredicate2 : this.g) {
                if (enchantmentPredicate2.a(map2)) continue;
                return false;
            }
        }
        PotionRegistry potion = PotionUtil.d(stack);
        return this.h == null || this.h == potion;
    }

    public static CriterionConditionItem a(@Nullable JsonElement el) {
        if (el == null || el.isJsonNull()) {
            return a;
        }
        JsonObject jsonObject = ChatDeserializer.m(el, "item");
        CriterionConditionValue.IntegerRange ints = CriterionConditionValue.IntegerRange.a(jsonObject.get("count"));
        CriterionConditionValue.IntegerRange ints2 = CriterionConditionValue.IntegerRange.a(jsonObject.get("durability"));
        if (jsonObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        CriterionConditionNBT nbtPredicate = CriterionConditionNBT.a(jsonObject.get("nbt"));
        ImmutableSet set = null;
        JsonArray jsonArray = ChatDeserializer.a(jsonObject, "items", null);
        if (jsonArray != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (JsonElement jsonElement : jsonArray) {
                MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.a(jsonElement, "item"));
                builder.add((Object)((Item)BuiltInRegistries.i.b(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown item id '" + resourceLocation + "'"))));
            }
            set = builder.build();
        }
        TagKey<Item> tagKey = null;
        if (jsonObject.has("tag")) {
            MinecraftKey resourceLocation2 = new MinecraftKey(ChatDeserializer.i(jsonObject, "tag"));
            tagKey = TagKey.a(Registries.D, resourceLocation2);
        }
        PotionRegistry potion = null;
        if (jsonObject.has("potion")) {
            MinecraftKey resourceLocation3 = new MinecraftKey(ChatDeserializer.i(jsonObject, "potion"));
            potion = (PotionRegistry)BuiltInRegistries.j.b(resourceLocation3).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + resourceLocation3 + "'"));
        }
        CriterionConditionEnchantments[] enchantmentPredicates = CriterionConditionEnchantments.b(jsonObject.get("enchantments"));
        CriterionConditionEnchantments[] enchantmentPredicates2 = CriterionConditionEnchantments.b(jsonObject.get("stored_enchantments"));
        return new CriterionConditionItem(tagKey, (Set<Item>)set, ints, ints2, enchantmentPredicates, enchantmentPredicates2, potion, nbtPredicate);
    }

    public JsonElement a() {
        if (this == a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.c != null) {
            JsonArray jsonArray = new JsonArray();
            for (Item item : this.c) {
                jsonArray.add(BuiltInRegistries.i.b(item).toString());
            }
            jsonObject.add("items", (JsonElement)jsonArray);
        }
        if (this.b != null) {
            jsonObject.addProperty("tag", this.b.b().toString());
        }
        jsonObject.add("count", this.d.d());
        jsonObject.add("durability", this.e.d());
        jsonObject.add("nbt", this.i.a());
        if (this.f.length > 0) {
            JsonArray jsonArray2 = new JsonArray();
            for (CriterionConditionEnchantments enchantmentPredicate : this.f) {
                jsonArray2.add(enchantmentPredicate.a());
            }
            jsonObject.add("enchantments", (JsonElement)jsonArray2);
        }
        if (this.g.length > 0) {
            JsonArray jsonArray3 = new JsonArray();
            for (CriterionConditionEnchantments enchantmentPredicate2 : this.g) {
                jsonArray3.add(enchantmentPredicate2.a());
            }
            jsonObject.add("stored_enchantments", (JsonElement)jsonArray3);
        }
        if (this.h != null) {
            jsonObject.addProperty("potion", BuiltInRegistries.j.b(this.h).toString());
        }
        return jsonObject;
    }

    public static CriterionConditionItem[] b(@Nullable JsonElement el) {
        if (el == null || el.isJsonNull()) {
            return new CriterionConditionItem[0];
        }
        JsonArray jsonArray = ChatDeserializer.n(el, "items");
        CriterionConditionItem[] itemPredicates = new CriterionConditionItem[jsonArray.size()];
        for (int i2 = 0; i2 < itemPredicates.length; ++i2) {
            itemPredicates[i2] = CriterionConditionItem.a(jsonArray.get(i2));
        }
        return itemPredicates;
    }

    public static class a {
        private final List<CriterionConditionEnchantments> a = Lists.newArrayList();
        private final List<CriterionConditionEnchantments> b = Lists.newArrayList();
        @Nullable
        private Set<Item> c;
        @Nullable
        private TagKey<Item> d;
        private CriterionConditionValue.IntegerRange e = CriterionConditionValue.IntegerRange.e;
        private CriterionConditionValue.IntegerRange f = CriterionConditionValue.IntegerRange.e;
        @Nullable
        private PotionRegistry g;
        private CriterionConditionNBT h = CriterionConditionNBT.a;

        private a() {
        }

        public static a a() {
            return new a();
        }

        public a a(IMaterial ... items) {
            this.c = (Set)Stream.of(items).map(IMaterial::k).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public a a(TagKey<Item> tag) {
            this.d = tag;
            return this;
        }

        public a a(CriterionConditionValue.IntegerRange count) {
            this.e = count;
            return this;
        }

        public a b(CriterionConditionValue.IntegerRange durability) {
            this.f = durability;
            return this;
        }

        public a a(PotionRegistry potion) {
            this.g = potion;
            return this;
        }

        public a a(NBTTagCompound nbt) {
            this.h = new CriterionConditionNBT(nbt);
            return this;
        }

        public a a(CriterionConditionEnchantments enchantment) {
            this.a.add(enchantment);
            return this;
        }

        public a b(CriterionConditionEnchantments enchantment) {
            this.b.add(enchantment);
            return this;
        }

        public CriterionConditionItem b() {
            return new CriterionConditionItem(this.d, this.c, this.e, this.f, this.a.toArray(CriterionConditionEnchantments.b), this.b.toArray(CriterionConditionEnchantments.b), this.g, this.h);
        }
    }
}

