/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.IRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public class EntityVariantPredicate<V> {
    private static final String a = "variant";
    final Codec<V> b;
    final Function<Entity, Optional<V>> c;
    final EntitySubPredicate.a d;

    public static <V> EntityVariantPredicate<V> a(IRegistry<V> registry, Function<Entity, Optional<V>> variantGetter) {
        return new EntityVariantPredicate<V>(registry.q(), variantGetter);
    }

    public static <V> EntityVariantPredicate<V> a(Codec<V> codec, Function<Entity, Optional<V>> variantGetter) {
        return new EntityVariantPredicate<V>(codec, variantGetter);
    }

    private EntityVariantPredicate(Codec<V> codec, Function<Entity, Optional<V>> variantGetter) {
        this.b = codec;
        this.c = variantGetter;
        this.d = json -> {
            JsonElement jsonElement = json.get(a);
            if (jsonElement == null) {
                throw new JsonParseException("Missing variant field");
            }
            Object object = ((Pair)SystemUtils.a(codec.decode(new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement)), JsonParseException::new)).getFirst();
            return this.a(object);
        };
    }

    public EntitySubPredicate.a a() {
        return this.d;
    }

    public EntitySubPredicate a(final V variant) {
        return new EntitySubPredicate(){

            @Override
            @Override
            public boolean a(Entity entity, WorldServer world, @Nullable Vec3D pos) {
                return EntityVariantPredicate.this.c.apply(entity).filter(variant -> variant.equals(variant)).isPresent();
            }

            @Override
            @Override
            public JsonObject a() {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add(EntityVariantPredicate.a, (JsonElement)SystemUtils.a(EntityVariantPredicate.this.b.encodeStart((DynamicOps)JsonOps.INSTANCE, variant), (String string) -> new JsonParseException("Can't serialize variant " + variant + ", message " + string)));
                return jsonObject;
            }

            @Override
            @Override
            public EntitySubPredicate.a c() {
                return EntityVariantPredicate.this.d;
            }
        };
    }
}

