/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;

public class CustomFunction {
    private final c[] a;
    final MinecraftKey b;
    public Timing timing;

    public Timing getTiming() {
        if (this.timing == null) {
            this.timing = MinecraftTimings.getCommandFunctionTiming(this);
        }
        return this.timing;
    }

    public CustomFunction(MinecraftKey id, c[] elements) {
        this.b = id;
        this.a = elements;
    }

    public MinecraftKey a() {
        return this.b;
    }

    public c[] b() {
        return this.a;
    }

    public static CustomFunction a(MinecraftKey id, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher, CommandListenerWrapper source, List<String> lines) {
        ArrayList list = Lists.newArrayListWithCapacity((int)lines.size());
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            int j2 = i2 + 1;
            String string = lines.get(i2).trim();
            StringReader stringReader = new StringReader(string);
            if (!stringReader.canRead() || stringReader.peek() == '#') continue;
            if (stringReader.peek() == '/') {
                stringReader.skip();
                if (stringReader.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + j2 + " (if you intended to make a comment, use '#' not '//')");
                }
                String string2 = stringReader.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + j2 + " (did you mean '" + string2 + "'? Do not use a preceding forwards slash.)");
            }
            try {
                ParseResults<CommandListenerWrapper> parseResults = dispatcher.parse(stringReader, source);
                if (parseResults.getReader().canRead()) {
                    throw CommandDispatcher.a(parseResults);
                }
                list.add(new b(parseResults));
                continue;
            }
            catch (CommandSyntaxException var10) {
                throw new IllegalArgumentException("Whilst parsing command on line " + j2 + ": " + var10.getMessage());
            }
        }
        return new CustomFunction(id, list.toArray(new c[0]));
    }

    @FunctionalInterface
    public static interface c {
        public void execute(CustomFunctionData var1, CommandListenerWrapper var2, Deque<CustomFunctionData.QueuedCommand> var3, int var4, int var5, @Nullable CustomFunctionData.TraceCallbacks var6) throws CommandSyntaxException;
    }

    public static class b
    implements c {
        private final ParseResults<CommandListenerWrapper> a;

        public b(ParseResults<CommandListenerWrapper> parsed) {
            this.a = parsed;
        }

        @Override
        public void execute(CustomFunctionData manager, CommandListenerWrapper source, Deque<CustomFunctionData.QueuedCommand> entries, int maxChainLength, int depth, @Nullable CustomFunctionData.TraceCallbacks tracer) throws CommandSyntaxException {
            if (tracer != null) {
                String string = this.a.getReader().getString();
                tracer.a(depth, string);
                int i2 = this.a(manager, source);
                tracer.a(depth, string, i2);
            } else {
                this.a(manager, source);
            }
        }

        private int a(CustomFunctionData manager, CommandListenerWrapper source) throws CommandSyntaxException {
            return manager.b().execute(CommandDispatcher.a(this.a, currentSource -> source));
        }

        public String toString() {
            return this.a.getReader().getString();
        }
    }

    public static class d
    implements c {
        private final a a;

        public d(CustomFunction function) {
            this.a = new a(function);
        }

        @Override
        public void execute(CustomFunctionData manager, CommandListenerWrapper source, Deque<CustomFunctionData.QueuedCommand> entries, int maxChainLength, int depth, @Nullable CustomFunctionData.TraceCallbacks tracer) {
            SystemUtils.a(this.a.a(manager), f2 -> {
                c[] entrys = f2.b();
                if (tracer != null) {
                    tracer.a(depth, f2.a(), entrys.length);
                }
                int k2 = maxChainLength - entries.size();
                int l2 = Math.min(entrys.length, k2);
                for (int m2 = l2 - 1; m2 >= 0; --m2) {
                    entries.addFirst(new CustomFunctionData.QueuedCommand(source, depth + 1, entrys[m2]));
                }
            }, () -> {
                if (tracer != null) {
                    tracer.a(depth, this.a.a(), -1);
                }
            });
        }

        public String toString() {
            return "function " + this.a.a();
        }
    }

    public static class a {
        public static final a a = new a((MinecraftKey)null);
        @Nullable
        private final MinecraftKey b;
        private boolean c;
        private Optional<CustomFunction> d = Optional.empty();

        public a(@Nullable MinecraftKey id) {
            this.b = id;
        }

        public a(CustomFunction function) {
            this.c = true;
            this.b = null;
            this.d = Optional.of(function);
        }

        public Optional<CustomFunction> a(CustomFunctionData manager) {
            if (!this.c) {
                if (this.b != null) {
                    this.d = manager.a(this.b);
                }
                this.c = true;
            }
            return this.d;
        }

        @Nullable
        public MinecraftKey a() {
            return this.d.map(f2 -> f2.b).orElse(this.b);
        }
    }
}

