/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.scores.ScoreboardScore;

public class ArgumentMathOperation
implements ArgumentType<a> {
    private static final Collection<String> a = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.operation.invalid"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.operation.div0"));

    public static ArgumentMathOperation a() {
        return new ArgumentMathOperation();
    }

    public static a a(CommandContext<CommandListenerWrapper> context, String name) {
        return (a)context.getArgument(name, a.class);
    }

    public a a(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead()) {
            int i2 = stringReader.getCursor();
            while (stringReader.canRead() && stringReader.peek() != ' ') {
                stringReader.skip();
            }
            return ArgumentMathOperation.a(stringReader.getString().substring(i2, stringReader.getCursor()));
        }
        throw b.create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return ICompletionProvider.a(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return a;
    }

    private static a a(String operator) throws CommandSyntaxException {
        if (operator.equals("><")) {
            return (a2, b2) -> {
                int i2 = a2.b();
                a2.b(b2.b());
                b2.b(i2);
            };
        }
        return ArgumentMathOperation.b(operator);
    }

    private static b b(String operator) throws CommandSyntaxException {
        switch (operator) {
            case "=": {
                return (a2, b2) -> b2;
            }
            case "+=": {
                return (a2, b2) -> a2 + b2;
            }
            case "-=": {
                return (a2, b2) -> a2 - b2;
            }
            case "*=": {
                return (a2, b2) -> a2 * b2;
            }
            case "/=": {
                return (a2, b2) -> {
                    if (b2 == 0) {
                        throw c.create();
                    }
                    return MathHelper.a(a2, b2);
                };
            }
            case "%=": {
                return (a2, b2) -> {
                    if (b2 == 0) {
                        throw c.create();
                    }
                    return MathHelper.b(a2, b2);
                };
            }
            case "<": {
                return Math::min;
            }
            case ">": {
                return Math::max;
            }
        }
        throw b.create();
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    @FunctionalInterface
    public static interface a {
        public void apply(ScoreboardScore var1, ScoreboardScore var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface b
    extends a {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        @Override
        default public void apply(ScoreboardScore a2, ScoreboardScore b2) throws CommandSyntaxException {
            a2.b(this.apply(a2.b(), b2.b()));
        }
    }
}

