/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.c<T>> b();

    default public Stream<ResourceKey<T>> c() {
        return this.b().map(Holder.c::g);
    }

    public Stream<HolderSet.Named<T>> d();

    default public Stream<TagKey<T>> e() {
        return this.d().map(HolderSet.Named::f);
    }

    default public HolderLookup<T> a(final Predicate<T> filter) {
        return new a<T>(this){

            @Override
            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return this.c.a(key).filter(entry -> filter.test(entry.a()));
            }

            @Override
            @Override
            public Stream<Holder.c<T>> b() {
                return this.c.b().filter(entry -> filter.test(entry.a()));
            }
        };
    }

    public static interface b {
        public <T> Optional<c<T>> a(ResourceKey<? extends IRegistry<? extends T>> var1);

        default public <T> c<T> b(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
            return this.a(registryRef).orElseThrow(() -> new IllegalStateException("Registry " + registryRef.a() + " not found"));
        }

        default public HolderGetter.a a() {
            return new HolderGetter.a(){

                @Override
                @Override
                public <T> Optional<HolderGetter<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                    return this.a(registryRef).map(lookup -> lookup);
                }
            };
        }

        public static b a(Stream<c<?>> wrappers) {
            final Map<ResourceKey, c> map = wrappers.collect(Collectors.toUnmodifiableMap(c::f, wrapper -> wrapper));
            return new b(){

                @Override
                @Override
                public <T> Optional<c<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                    return Optional.ofNullable((c)map.get(registryRef));
                }
            };
        }
    }

    public static class a<T>
    implements HolderLookup<T> {
        protected final HolderLookup<T> c;

        public a(HolderLookup<T> baseWrapper) {
            this.c = baseWrapper;
        }

        @Override
        @Override
        public Optional<Holder.c<T>> a(ResourceKey<T> key) {
            return this.c.a(key);
        }

        @Override
        @Override
        public Stream<Holder.c<T>> b() {
            return this.c.b();
        }

        @Override
        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
            return this.c.a(tag);
        }

        @Override
        @Override
        public Stream<HolderSet.Named<T>> d() {
            return this.c.d();
        }
    }

    public static interface c<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends IRegistry<? extends T>> f();

        public Lifecycle g();

        default public HolderLookup<T> a(FeatureFlagSet enabledFeatures) {
            if (FeatureElement.bv.contains(this.f())) {
                return this.a((T feature) -> ((FeatureElement)feature).a(enabledFeatures));
            }
            return this;
        }

        public static abstract class a<T>
        implements c<T> {
            protected abstract c<T> a();

            @Override
            @Override
            public ResourceKey<? extends IRegistry<? extends T>> f() {
                return this.a().f();
            }

            @Override
            @Override
            public Lifecycle g() {
                return this.a().g();
            }

            @Override
            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return this.a().a(key);
            }

            @Override
            @Override
            public Stream<Holder.c<T>> b() {
                return this.a().b();
            }

            @Override
            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return this.a().a(tag);
            }

            @Override
            @Override
            public Stream<HolderSet.Named<T>> d() {
                return this.a().d();
            }
        }
    }
}

