/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.WorldVersion;
import net.minecraft.data.CachedOutput;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class HashCache {
    static final Logger a = LogUtils.getLogger();
    private static final String b = "// ";
    private final Path c;
    private final Path d;
    private final String e;
    private final Map<String, b> f;
    private final Set<String> g = new HashSet<String>();
    private final Set<Path> h = new HashSet<Path>();
    private final int i;
    private int j;

    private Path b(String providerName) {
        return this.d.resolve(Hashing.sha1().hashString((CharSequence)providerName, StandardCharsets.UTF_8).toString());
    }

    public HashCache(Path root, Collection<String> providerNames, WorldVersion gameVersion) throws IOException {
        this.e = gameVersion.c();
        this.c = root;
        this.d = root.resolve(".cache");
        Files.createDirectories(this.d, new FileAttribute[0]);
        HashMap<String, b> map = new HashMap<String, b>();
        int i2 = 0;
        for (String string : providerNames) {
            Path path = this.b(string);
            this.h.add(path);
            b providerCache = HashCache.a(root, path);
            map.put(string, providerCache);
            i2 += providerCache.a();
        }
        this.f = map;
        this.i = i2;
    }

    private static b a(Path root, Path dataProviderPath) {
        if (Files.isReadable(dataProviderPath)) {
            try {
                return net.minecraft.data.HashCache$b.a(root, dataProviderPath);
            }
            catch (Exception exception) {
                a.warn("Failed to parse cache {}, discarding", (Object)dataProviderPath, (Object)exception);
            }
        }
        return new b("unknown", (ImmutableMap<Path, HashCode>)ImmutableMap.of());
    }

    public boolean a(String providerName) {
        b providerCache = this.f.get(providerName);
        return providerCache == null || !providerCache.a.equals(this.e);
    }

    public CompletableFuture<e> a(String providerName, d runner) {
        b providerCache = this.f.get(providerName);
        if (providerCache == null) {
            throw new IllegalStateException("Provider not registered: " + providerName);
        }
        a cacheUpdater = new a(providerName, this.e, providerCache);
        return runner.update(cacheUpdater).thenApply(void_ -> cacheUpdater.a());
    }

    public void a(e runResult) {
        this.f.put(runResult.a(), runResult.b());
        this.g.add(runResult.a());
        this.j += runResult.c();
    }

    public void a() throws IOException {
        HashSet<Path> set = new HashSet<Path>();
        this.f.forEach((providerName, cachedData) -> {
            if (this.g.contains(providerName)) {
                Path path = this.b((String)providerName);
                cachedData.a(this.c, path, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + "\t" + providerName);
            }
            set.addAll((Collection<Path>)cachedData.c().keySet());
        });
        set.add(this.c.resolve("version.json"));
        MutableInt mutableInt = new MutableInt();
        MutableInt mutableInt2 = new MutableInt();
        try (Stream<Path> stream = Files.walk(this.c, new FileVisitOption[0]);){
            stream.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                if (this.h.contains(path)) {
                    return;
                }
                mutableInt.increment();
                if (set.contains(path)) {
                    return;
                }
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    a.warn("Failed to delete file {}", path, (Object)iOException);
                }
                mutableInt2.increment();
            });
        }
        a.info("Caching: total files: {}, old count: {}, new count: {}, removed stale: {}, written: {}", new Object[]{mutableInt, this.i, set.size(), mutableInt2, this.j});
    }

    record b(String a, ImmutableMap<Path, HashCode> b) {
        private final String a;
        private final ImmutableMap<Path, HashCode> b;

        @Nullable
        public HashCode a(Path path) {
            return (HashCode)this.b.get((Object)path);
        }

        public int a() {
            return this.b.size();
        }

        public static b a(Path root, Path dataProviderPath) throws IOException {
            try (BufferedReader bufferedReader = Files.newBufferedReader(dataProviderPath, StandardCharsets.UTF_8);){
                String string = bufferedReader.readLine();
                if (!string.startsWith(HashCache.b)) {
                    throw new IllegalStateException("Missing cache file header");
                }
                String[] strings = string.substring(HashCache.b.length()).split("\t", 2);
                String string2 = strings[0];
                ImmutableMap.Builder builder = ImmutableMap.builder();
                bufferedReader.lines().forEach(line -> {
                    int i2 = line.indexOf(32);
                    builder.put((Object)root.resolve(line.substring(i2 + 1)), (Object)HashCode.fromString((String)line.substring(0, i2)));
                });
                b b2 = new b(string2, (ImmutableMap<Path, HashCode>)builder.build());
                return b2;
            }
        }

        public void a(Path root, Path dataProviderPath, String description) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(dataProviderPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write(HashCache.b);
                bufferedWriter.write(this.a);
                bufferedWriter.write(9);
                bufferedWriter.write(description);
                bufferedWriter.newLine();
                for (Map.Entry entry : this.b.entrySet()) {
                    bufferedWriter.write(((HashCode)entry.getValue()).toString());
                    bufferedWriter.write(32);
                    bufferedWriter.write(root.relativize((Path)entry.getKey()).toString());
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException) {
                a.warn("Unable write cachefile {}: {}", (Object)dataProviderPath, (Object)iOException);
            }
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "version;data", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "version;data", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "version;data", "a", "b"}, this, object);
        }

        public String b() {
            return this.a;
        }

        public ImmutableMap<Path, HashCode> c() {
            return this.b;
        }
    }

    class a
    implements CachedOutput {
        private final String c;
        private final b d;
        private final c e;
        private final AtomicInteger f = new AtomicInteger();
        private volatile boolean g;

        a(String providerName, String version, b oldCache) {
            this.c = providerName;
            this.d = oldCache;
            this.e = new c(version);
        }

        private boolean a(Path path, HashCode hashCode) {
            return !Objects.equals(this.d.a(path), hashCode) || !Files.exists(path, new LinkOption[0]);
        }

        @Override
        @Override
        public void writeIfNeeded(Path path, byte[] data, HashCode hashCode) throws IOException {
            if (this.g) {
                throw new IllegalStateException("Cannot write to cache as it has already been closed");
            }
            if (this.a(path, hashCode)) {
                this.f.incrementAndGet();
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, data, new OpenOption[0]);
            }
            this.e.a(path, hashCode);
        }

        public e a() {
            this.g = true;
            return new e(this.c, this.e.a(), this.f.get());
        }
    }

    @FunctionalInterface
    public static interface d {
        public CompletableFuture<?> update(CachedOutput var1);
    }

    public record e(String a, b b, int c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "providerId;cache;writes", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "providerId;cache;writes", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "providerId;cache;writes", "a", "b", "c"}, this, object);
        }
    }

    record c(String a, ConcurrentMap<Path, HashCode> b) {
        private final String a;
        private final ConcurrentMap<Path, HashCode> b;

        c(String version) {
            this(version, new ConcurrentHashMap<Path, HashCode>());
        }

        public void a(Path path, HashCode hashCode) {
            this.b.put(path, hashCode);
        }

        public b a() {
            return new b(this.a, (ImmutableMap<Path, HashCode>)ImmutableMap.copyOf(this.b));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "version;data", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "version;data", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "version;data", "a", "b"}, this, object);
        }

        public String b() {
            return this.a;
        }

        public ConcurrentMap<Path, HashCode> c() {
            return this.b;
        }
    }
}

