/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.packs.BundleRecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @DontObfuscate
    public static void main(String[] args) throws IOException {
        SharedConstants.a();
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec optionSpec = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionSpec2 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder optionSpec3 = optionParser.accepts("client", "Include client generators");
        OptionSpecBuilder optionSpec4 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionSpec5 = optionParser.accepts("reports", "Include data reports");
        OptionSpecBuilder optionSpec6 = optionParser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionSpec7 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionSpec8 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionSpec9 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet optionSet = optionParser.parse(args);
        if (optionSet.has((OptionSpec)optionSpec) || !optionSet.hasOptions()) {
            optionParser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path path = Paths.get((String)optionSpec8.value(optionSet), new String[0]);
        boolean bl = optionSet.has((OptionSpec)optionSpec7);
        boolean bl2 = bl || optionSet.has((OptionSpec)optionSpec3);
        boolean bl3 = bl || optionSet.has((OptionSpec)optionSpec2);
        boolean bl4 = bl || optionSet.has((OptionSpec)optionSpec4);
        boolean bl5 = bl || optionSet.has((OptionSpec)optionSpec5);
        boolean bl6 = bl || optionSet.has((OptionSpec)optionSpec6);
        DataGenerator dataGenerator = Main.a(path, optionSet.valuesOf((OptionSpec)optionSpec9).stream().map(input -> Paths.get(input, new String[0])).collect(Collectors.toList()), bl2, bl3, bl4, bl5, bl6, SharedConstants.b(), true);
        dataGenerator.a();
    }

    private static <T extends DebugReportProvider> DebugReportProvider.a<T> a(BiFunction<PackOutput, CompletableFuture<HolderLookup.b>, T> baseFactory, CompletableFuture<HolderLookup.b> registryLookupFuture) {
        return output -> (DebugReportProvider)baseFactory.apply(output, registryLookupFuture);
    }

    public static DataGenerator a(Path output2, Collection<Path> inputs, boolean includeClient, boolean includeServer, boolean includeDev, boolean includeReports, boolean validate, WorldVersion gameVersion, boolean ignoreCache) {
        DataGenerator dataGenerator = new DataGenerator(output2, gameVersion, ignoreCache);
        DataGenerator.a packGenerator = dataGenerator.a(includeClient || includeServer);
        packGenerator.a(output -> new SnbtToNbt(output, inputs).a(new StructureUpdater()));
        CompletableFuture<HolderLookup.b> completableFuture = CompletableFuture.supplyAsync(VanillaRegistries::a, SystemUtils.f());
        DataGenerator.a packGenerator2 = dataGenerator.a(includeClient);
        packGenerator2.a(ModelProvider::new);
        DataGenerator.a packGenerator3 = dataGenerator.a(includeServer);
        packGenerator3.a(Main.a(RegistriesDatapackGenerator::new, completableFuture));
        packGenerator3.a(Main.a(VanillaAdvancementProvider::a, completableFuture));
        packGenerator3.a(VanillaLootTableProvider::a);
        packGenerator3.a(VanillaRecipeProvider::new);
        TagsProvider tagsProvider = packGenerator3.a(Main.a(VanillaBlockTagsProvider::new, completableFuture));
        TagsProvider tagsProvider2 = packGenerator3.a(output -> new VanillaItemTagsProvider(output, completableFuture, tagsProvider.c()));
        packGenerator3.a(Main.a(BannerPatternTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(BiomeTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(CatVariantTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(DamageTypeTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(EntityTypeTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(FlatLevelGeneratorPresetTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(FluidTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(GameEventTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(InstrumentTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(PaintingVariantTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(PoiTypeTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(StructureTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(WorldPresetTagsProvider::new, completableFuture));
        DataGenerator.a packGenerator4 = dataGenerator.a(includeDev);
        packGenerator4.a(output -> new DebugReportNBT(output, inputs));
        DataGenerator.a packGenerator5 = dataGenerator.a(includeReports);
        packGenerator5.a(Main.a(BiomeParametersDumpReport::new, completableFuture));
        packGenerator5.a(BlockListReport::new);
        packGenerator5.a(Main.a(CommandsReport::new, completableFuture));
        packGenerator5.a(RegistryDumpReport::new);
        DataGenerator.a packGenerator6 = dataGenerator.a(includeServer, "bundle");
        packGenerator6.a(BundleRecipeProvider::new);
        packGenerator6.a(output -> PackMetadataGenerator.a(output, IChatBaseComponent.c("dataPack.bundle.description"), FeatureFlagSet.a(FeatureFlags.b)));
        return dataGenerator;
    }
}

