/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.Items;

public class ItemModelGenerators {
    public static final MinecraftKey a = new MinecraftKey("trim_type");
    private static final List<a> b = List.of(new a("quartz", 0.1f, Map.of()), new a("iron", 0.2f, Map.of(EnumArmorMaterial.c, "iron_darker")), new a("netherite", 0.3f, Map.of(EnumArmorMaterial.g, "netherite_darker")), new a("redstone", 0.4f, Map.of()), new a("copper", 0.5f, Map.of()), new a("gold", 0.6f, Map.of(EnumArmorMaterial.d, "gold_darker")), new a("emerald", 0.7f, Map.of()), new a("diamond", 0.8f, Map.of(EnumArmorMaterial.e, "diamond_darker")), new a("lapis", 0.9f, Map.of()), new a("amethyst", 1.0f, Map.of()));
    private final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;

    public ItemModelGenerators(BiConsumer<MinecraftKey, Supplier<JsonElement>> writer) {
        this.c = writer;
    }

    private void a(Item item, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void a(Item item, String suffix, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item, suffix), TextureMapping.k(TextureMapping.a(item, suffix)), this.c);
    }

    private void a(Item item, Item texture, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(texture), this.c);
    }

    private void a(Item compass) {
        for (int i2 = 0; i2 < 32; ++i2) {
            if (i2 == 16) continue;
            this.a(compass, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bv);
        }
    }

    private void b(Item clock) {
        for (int i2 = 1; i2 < 64; ++i2) {
            this.a(clock, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bv);
        }
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1) {
        ModelTemplates.bz.a(id, TextureMapping.c(layer0, layer1), this.c);
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1, MinecraftKey layer2) {
        ModelTemplates.bA.a(id, TextureMapping.a(layer0, layer1, layer2), this.c);
    }

    private MinecraftKey a(MinecraftKey id, String trimMaterialName) {
        return id.e("_" + trimMaterialName + "_trim");
    }

    private JsonObject a(MinecraftKey id, Map<TextureSlot, MinecraftKey> textures, ArmorMaterial armorMaterial) {
        JsonObject jsonObject = ModelTemplates.bz.a(id, textures);
        JsonArray jsonArray = new JsonArray();
        for (a trimModelData : b) {
            JsonObject jsonObject2 = new JsonObject();
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty(a.a(), (Number)Float.valueOf(trimModelData.b()));
            jsonObject2.add("predicate", (JsonElement)jsonObject3);
            jsonObject2.addProperty("model", this.a(id, trimModelData.a(armorMaterial)).toString());
            jsonArray.add((JsonElement)jsonObject2);
        }
        jsonObject.add("overrides", (JsonElement)jsonArray);
        return jsonObject;
    }

    private void a(ItemArmor armor) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(armor);
        MinecraftKey resourceLocation2 = TextureMapping.c(armor);
        MinecraftKey resourceLocation3 = TextureMapping.a(armor, "_overlay");
        if (armor.d() == EnumArmorMaterial.a) {
            ModelTemplates.bz.a(resourceLocation, TextureMapping.c(resourceLocation2, resourceLocation3), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, armor.d()));
        } else {
            ModelTemplates.bv.a(resourceLocation, TextureMapping.k(resourceLocation2), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, armor.d()));
        }
        for (a trimModelData : b) {
            String string = trimModelData.a(armor.d());
            MinecraftKey resourceLocation4 = this.a(resourceLocation, string);
            String string2 = armor.b().b() + "_trim_" + string;
            MinecraftKey resourceLocation5 = new MinecraftKey(string2).d("trims/items/");
            if (armor.d() == EnumArmorMaterial.a) {
                this.a(resourceLocation4, resourceLocation2, resourceLocation3, resourceLocation5);
                continue;
            }
            this.a(resourceLocation4, resourceLocation2, resourceLocation5);
        }
    }

    public void a() {
        this.a(Items.nq, ModelTemplates.bv);
        this.a(Items.ns, ModelTemplates.bv);
        this.a(Items.nr, ModelTemplates.bv);
        this.a(Items.nt, ModelTemplates.bv);
        this.a(Items.nO, ModelTemplates.bv);
        this.a(Items.nF, ModelTemplates.bv);
        this.a(Items.tL, ModelTemplates.bv);
        this.a(Items.nH, ModelTemplates.bv);
        this.a(Items.tn, ModelTemplates.bv);
        this.a(Items.dv, ModelTemplates.bx);
        this.a(Items.rl, ModelTemplates.bv);
        this.a(Items.uq, ModelTemplates.bv);
        this.a(Items.us, ModelTemplates.bv);
        this.a(Items.nm, ModelTemplates.bv);
        this.a(Items.nn, ModelTemplates.bv);
        this.a(Items.qJ, ModelTemplates.bv);
        this.a(Items.rz, ModelTemplates.bv);
        this.a(Items.rr, ModelTemplates.bx);
        this.a(Items.qF, ModelTemplates.bv);
        this.a(Items.qK, ModelTemplates.bv);
        this.a(Items.qb, ModelTemplates.bv);
        this.a(Items.oC, ModelTemplates.bv);
        this.a(Items.oJ, ModelTemplates.bv);
        this.a(Items.pX, ModelTemplates.bv);
        this.a(Items.qG, ModelTemplates.bv);
        this.a(Items.pK, ModelTemplates.bv);
        this.a(Items.nf, ModelTemplates.by);
        this.a(Items.ng, ModelTemplates.by);
        this.a(Items.nJ, ModelTemplates.bv);
        this.a(Items.nb, ModelTemplates.bv);
        this.a(Items.rn, ModelTemplates.bv);
        this.a(Items.um, ModelTemplates.bv);
        this.a(Items.pY, ModelTemplates.bv);
        this.b(Items.qi);
        this.a(Items.nI, ModelTemplates.bv);
        this.a(Items.pT, ModelTemplates.bv);
        this.a(Items.tS, ModelTemplates.bv);
        this.a(Items.qe);
        this.a(Items.qf);
        this.a(Items.rm, ModelTemplates.bv);
        this.a(Items.ro, ModelTemplates.bv);
        this.a(Items.qp, ModelTemplates.bv);
        this.a(Items.tU, ModelTemplates.bv);
        this.a(Items.pk, ModelTemplates.bv);
        this.a(Items.tH, ModelTemplates.bv);
        this.a(Items.qq, ModelTemplates.bv);
        this.a(Items.re, ModelTemplates.bv);
        this.a(Items.nR, ModelTemplates.bv);
        this.a(Items.nS, ModelTemplates.bv);
        this.a(Items.vd, ModelTemplates.bv);
        this.a(Items.qD, ModelTemplates.bv);
        this.a(Items.nu, ModelTemplates.bv);
        this.a(Items.nv, ModelTemplates.bv);
        this.a(Items.nK, ModelTemplates.bv);
        this.a(Items.ou, ModelTemplates.bx);
        this.a(Items.ov, ModelTemplates.bx);
        this.a(Items.tO, ModelTemplates.bv);
        this.a(Items.ot, ModelTemplates.bx);
        this.a(Items.os, ModelTemplates.bx);
        this.a(Items.or, ModelTemplates.bx);
        this.a(Items.ut, ModelTemplates.bv);
        this.a(Items.ri, ModelTemplates.bv);
        this.a(Items.qd, ModelTemplates.bv);
        this.a(Items.nL, ModelTemplates.bv);
        this.a(Items.tC, ModelTemplates.bv);
        this.a(Items.rD, ModelTemplates.bv);
        this.a(Items.rq, ModelTemplates.bv);
        this.a(Items.ul, ModelTemplates.bv);
        this.a(Items.te, ModelTemplates.bv);
        this.a(Items.ry, ModelTemplates.bv);
        this.a(Items.tA, ModelTemplates.bv);
        this.a(Items.tf, ModelTemplates.bv);
        this.a(Items.pi, ModelTemplates.bv);
        this.a(Items.nE, ModelTemplates.bv);
        this.a(Items.vc, ModelTemplates.bv);
        this.a(Items.nc, ModelTemplates.bv);
        this.a(Items.rs, ModelTemplates.bv);
        this.a(Items.rw, ModelTemplates.bv);
        this.a(Items.rE, ModelTemplates.bv);
        this.a(Items.vg, ModelTemplates.bv);
        this.a(Items.vw, ModelTemplates.bv);
        this.a(Items.qk, ModelTemplates.bv);
        this.a(Items.qs, ModelTemplates.bv);
        this.a(Items.tj, ModelTemplates.bv);
        this.a(Items.nT, ModelTemplates.bv);
        this.a(Items.pm, ModelTemplates.bv);
        this.a(Items.ok, ModelTemplates.bx);
        this.a(Items.tq, ModelTemplates.bv);
        this.a(Items.ol, ModelTemplates.bx);
        this.a(Items.tN, ModelTemplates.bv);
        this.a(Items.oj, ModelTemplates.bx);
        this.a(Items.oi, ModelTemplates.bx);
        this.a(Items.oh, ModelTemplates.bx);
        this.a(Items.nU, ModelTemplates.bv);
        this.a(Items.rt, ModelTemplates.bv);
        this.a(Items.qB, ModelTemplates.bv);
        this.a(Items.qH, ModelTemplates.bv);
        this.a(Items.oG, ModelTemplates.bv);
        this.a(Items.uY, ModelTemplates.bv);
        this.a(Items.vA, ModelTemplates.bv);
        this.a(Items.vD, ModelTemplates.bv);
        this.a(Items.ne, ModelTemplates.bv);
        this.a(Items.qr, ModelTemplates.bv);
        this.a(Items.nP, ModelTemplates.bv);
        this.a(Items.op, ModelTemplates.bx);
        this.a(Items.oq, ModelTemplates.bx);
        this.a(Items.tM, ModelTemplates.bv);
        this.a(Items.nQ, ModelTemplates.bv);
        this.a(Items.uB, ModelTemplates.bv);
        this.a(Items.oo, ModelTemplates.bx);
        this.a(Items.on, ModelTemplates.bx);
        this.a(Items.om, ModelTemplates.bx);
        this.a(Items.ti, ModelTemplates.bv);
        this.a(Items.no, ModelTemplates.bv);
        this.a(Items.np, ModelTemplates.bv);
        this.a(Items.uC, ModelTemplates.bv);
        this.a(Items.nM, ModelTemplates.bv);
        this.a(Items.pM, ModelTemplates.bv);
        this.a(Items.pP, ModelTemplates.bv);
        this.a(Items.tP, ModelTemplates.bv);
        this.a(Items.qx, ModelTemplates.bv);
        this.a(Items.qC, ModelTemplates.bv);
        this.a(Items.qz, ModelTemplates.bv);
        this.a(Items.qw, ModelTemplates.bv);
        this.a(Items.rA, ModelTemplates.bv);
        this.a(Items.nw, ModelTemplates.bv);
        this.a(Items.nx, ModelTemplates.bv);
        this.a(Items.ny, ModelTemplates.bv);
        this.a(Items.nz, ModelTemplates.bv);
        this.a(Items.tp, ModelTemplates.bv);
        this.a(Items.rh, ModelTemplates.bv);
        this.a(Items.pQ, ModelTemplates.bv);
        this.a(Items.na, ModelTemplates.bv);
        this.a(Items.vf, ModelTemplates.bv);
        this.a(Items.oD, ModelTemplates.bv);
        this.a(Items.uU, ModelTemplates.bv);
        this.a(Items.uO, ModelTemplates.bw);
        this.a(Items.uE, ModelTemplates.bw);
        this.a(Items.uG, ModelTemplates.bw);
        this.a(Items.uF, ModelTemplates.bw);
        this.a(Items.uH, ModelTemplates.bw);
        this.a(Items.uI, ModelTemplates.bw);
        this.a(Items.uJ, ModelTemplates.bw);
        this.a(Items.uK, ModelTemplates.bw);
        this.a(Items.uT, ModelTemplates.bw);
        this.a(Items.uL, ModelTemplates.bw);
        this.a(Items.uM, ModelTemplates.bw);
        this.a(Items.uP, ModelTemplates.bw);
        this.a(Items.uN, ModelTemplates.bw);
        this.a(Items.uQ, ModelTemplates.bw);
        this.a(Items.uR, ModelTemplates.bw);
        this.a(Items.uS, ModelTemplates.bw);
        this.a(Items.tT, ModelTemplates.bv);
        this.a(Items.tR, ModelTemplates.bv);
        this.a(Items.uX, ModelTemplates.bv);
        this.a(Items.oz, ModelTemplates.bx);
        this.a(Items.oA, ModelTemplates.bx);
        this.a(Items.nV, ModelTemplates.bv);
        this.a(Items.oy, ModelTemplates.bx);
        this.a(Items.nW, ModelTemplates.bv);
        this.a(Items.ox, ModelTemplates.bx);
        this.a(Items.ow, ModelTemplates.bx);
        this.a(Items.tD, ModelTemplates.bv);
        this.a(Items.ty, ModelTemplates.bv);
        this.a(Items.ni, ModelTemplates.bv);
        this.a(Items.nj, ModelTemplates.bv);
        this.a(Items.qv, ModelTemplates.bv);
        this.a(Items.pl, ModelTemplates.bv);
        this.a(Items.qa, ModelTemplates.bv);
        this.a(Items.uW, ModelTemplates.bv);
        this.a(Items.vh, ModelTemplates.bv);
        this.a(Items.qA, ModelTemplates.bv);
        this.a(Items.to, ModelTemplates.bv);
        this.a(Items.un, ModelTemplates.bv);
        this.a(Items.pj, ModelTemplates.bv);
        this.a(Items.pN, ModelTemplates.bv);
        this.a(Items.tF, ModelTemplates.bv);
        this.a(Items.tE, ModelTemplates.bv);
        this.a(Items.qo, ModelTemplates.bv);
        this.a(Items.pR, ModelTemplates.bv);
        this.a(Items.tz, ModelTemplates.bv);
        this.a(Items.qE, ModelTemplates.bv);
        this.a(Items.nN, ModelTemplates.bv);
        this.a(Items.tG, ModelTemplates.bv);
        this.a(Items.tJ, ModelTemplates.bv);
        this.a(Items.tK, ModelTemplates.bv);
        this.a(Items.tI, ModelTemplates.bv);
        this.a(Items.qI, ModelTemplates.bv);
        this.a(Items.rp, ModelTemplates.bv);
        this.a(Items.mZ, ModelTemplates.bv);
        this.a(Items.qm, ModelTemplates.bv);
        this.a(Items.pS, ModelTemplates.bv);
        this.a(Items.nD, ModelTemplates.bv);
        this.a(Items.rg, ModelTemplates.bv);
        this.a(Items.uA, ModelTemplates.bv);
        this.a(Items.ve, ModelTemplates.bv);
        this.a(Items.qc, ModelTemplates.bv);
        this.a(Items.pO, ModelTemplates.bv);
        this.a(Items.wu, ModelTemplates.bv);
        this.a(Items.uv, ModelTemplates.bv);
        this.a(Items.rx, ModelTemplates.bv);
        this.a(Items.nk, ModelTemplates.bv);
        this.a(Items.nl, ModelTemplates.bv);
        this.a(Items.qj, ModelTemplates.bv);
        this.a(Items.oB, ModelTemplates.bx);
        this.a(Items.of, ModelTemplates.bx);
        this.a(Items.og, ModelTemplates.bx);
        this.a(Items.oe, ModelTemplates.bx);
        this.a(Items.od, ModelTemplates.bx);
        this.a(Items.oc, ModelTemplates.bx);
        this.a(Items.qM, ModelTemplates.bv);
        this.a(Items.va, ModelTemplates.bv);
        this.a(Items.nd, ModelTemplates.bv);
        this.a(Items.uz, ModelTemplates.bv);
        this.a(Items.uV, ModelTemplates.bv);
        this.a(Items.qn, ModelTemplates.bv);
        this.a(Items.pU, ModelTemplates.bv);
        this.a(Items.pV, ModelTemplates.bv);
        this.a(Items.pW, ModelTemplates.bv);
        this.a(Items.pL, ModelTemplates.bv);
        this.a(Items.oI, ModelTemplates.bv);
        this.a(Items.qu, ModelTemplates.bv);
        this.a(Items.oa, ModelTemplates.bx);
        this.a(Items.ob, ModelTemplates.bx);
        this.a(Items.nZ, ModelTemplates.bx);
        this.a(Items.nY, ModelTemplates.bx);
        this.a(Items.nX, ModelTemplates.bx);
        this.a(Items.tg, ModelTemplates.bv);
        this.a(Items.th, ModelTemplates.bv);
        this.a(Items.qy, ModelTemplates.bv);
        this.a(Items.ww, ModelTemplates.bv);
        this.a(Items.wx, ModelTemplates.bv);
        this.a(Items.wy, ModelTemplates.bv);
        this.a(Items.wz, ModelTemplates.bv);
        this.a(Items.wA, ModelTemplates.bv);
        this.a(Items.wB, ModelTemplates.bv);
        this.a(Items.wC, ModelTemplates.bv);
        this.a(Items.wD, ModelTemplates.bv);
        this.a(Items.wE, ModelTemplates.bv);
        this.a(Items.wF, ModelTemplates.bv);
        this.a(Items.wG, ModelTemplates.bv);
        this.a(Items.wH, ModelTemplates.bv);
        this.a(Items.wI, ModelTemplates.bv);
        this.a(Items.wJ, ModelTemplates.bv);
        this.a(Items.wK, ModelTemplates.bv);
        this.a(Items.wL, ModelTemplates.bv);
        this.a(Items.wM, ModelTemplates.bv);
        this.a(Items.uD, Items.oB, ModelTemplates.bx);
        this.a(Items.pn, Items.pm, ModelTemplates.bv);
        for (Item item : BuiltInRegistries.i) {
            if (!(item instanceof ItemArmor)) continue;
            ItemArmor armorItem = (ItemArmor)item;
            this.a(armorItem);
        }
        this.a(Items.wN, ModelTemplates.bv);
        this.a(Items.wO, ModelTemplates.bv);
        this.a(Items.wP, ModelTemplates.bv);
        this.a(Items.wQ, ModelTemplates.bv);
        this.a(Items.wR, ModelTemplates.bv);
        this.a(Items.wS, ModelTemplates.bv);
        this.a(Items.wT, ModelTemplates.bv);
        this.a(Items.wU, ModelTemplates.bv);
        this.a(Items.wV, ModelTemplates.bv);
        this.a(Items.wW, ModelTemplates.bv);
        this.a(Items.wX, ModelTemplates.bv);
        this.a(Items.wY, ModelTemplates.bv);
        this.a(Items.wZ, ModelTemplates.bv);
        this.a(Items.xa, ModelTemplates.bv);
        this.a(Items.xb, ModelTemplates.bv);
        this.a(Items.xc, ModelTemplates.bv);
        this.a(Items.xd, ModelTemplates.bv);
        this.a(Items.xe, ModelTemplates.bv);
        this.a(Items.xf, ModelTemplates.bv);
        this.a(Items.xg, ModelTemplates.bv);
    }

    record a(String a, float b, Map<ArmorMaterial, String> c) {
        public String a(ArmorMaterial armorMaterial) {
            return this.c.getOrDefault(armorMaterial, this.a);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this, object);
        }
    }
}

