/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.IMaterial;

public class ShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final Item c;
    private final int d;
    private final List<String> e = Lists.newArrayList();
    private final Map<Character, RecipeItemStack> f = Maps.newLinkedHashMap();
    private final Advancement.SerializedAdvancement g = Advancement.SerializedAdvancement.b();
    @Nullable
    private String h;
    private boolean i = true;

    public ShapedRecipeBuilder(RecipeCategory category, IMaterial output, int count) {
        this.b = category;
        this.c = output.k();
        this.d = count;
    }

    public static ShapedRecipeBuilder a(RecipeCategory category, IMaterial output) {
        return ShapedRecipeBuilder.a(category, output, 1);
    }

    public static ShapedRecipeBuilder a(RecipeCategory category, IMaterial output, int count) {
        return new ShapedRecipeBuilder(category, output, count);
    }

    public ShapedRecipeBuilder a(Character c2, TagKey<Item> tag) {
        return this.a(c2, RecipeItemStack.a(tag));
    }

    public ShapedRecipeBuilder a(Character c2, IMaterial itemProvider) {
        return this.a(c2, RecipeItemStack.a(itemProvider));
    }

    public ShapedRecipeBuilder a(Character c2, RecipeItemStack ingredient) {
        if (this.f.containsKey(c2)) {
            throw new IllegalArgumentException("Symbol '" + c2 + "' is already defined!");
        }
        if (c2.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.f.put(c2, ingredient);
        return this;
    }

    public ShapedRecipeBuilder b(String patternStr) {
        if (!this.e.isEmpty() && patternStr.length() != this.e.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.e.add(patternStr);
        return this;
    }

    @Override
    public ShapedRecipeBuilder b(String string, CriterionInstance criterionTriggerInstance) {
        this.g.a(string, criterionTriggerInstance);
        return this;
    }

    @Override
    public ShapedRecipeBuilder c(@Nullable String string) {
        this.h = string;
        return this;
    }

    public ShapedRecipeBuilder a(boolean showNotification) {
        this.i = showNotification;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.c;
    }

    @Override
    @Override
    public void a(Consumer<FinishedRecipe> exporter, MinecraftKey recipeId) {
        this.a(recipeId);
        this.g.a(a).a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeId)).a(AdvancementRewards.a.c(recipeId)).a(AdvancementRequirements.b);
        exporter.accept(new a(recipeId, this.c, this.d, this.h == null ? "" : this.h, ShapedRecipeBuilder.a(this.b), this.e, this.f, this.g, recipeId.d("recipes/" + this.b.a() + "/"), this.i));
    }

    private void a(MinecraftKey recipeId) {
        if (this.e.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + recipeId + "!");
        }
        HashSet set = Sets.newHashSet(this.f.keySet());
        set.remove(Character.valueOf(' '));
        for (String string : this.e) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (!this.f.containsKey(Character.valueOf(c2)) && c2 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + recipeId + " uses undefined symbol '" + c2 + "'");
                }
                set.remove(Character.valueOf(c2));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + recipeId);
        }
        if (this.e.size() == 1 && this.e.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + recipeId + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.g.d().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.c(group);
    }

    @Override
    public /* synthetic */ RecipeBuilder a(String name, CriterionInstance conditions) {
        return this.b(name, conditions);
    }

    static class a
    extends CraftingRecipeBuilder.a {
        private final MinecraftKey a;
        private final Item b;
        private final int c;
        private final String d;
        private final List<String> e;
        private final Map<Character, RecipeItemStack> f;
        private final Advancement.SerializedAdvancement g;
        private final MinecraftKey h;
        private final boolean i;

        public a(MinecraftKey recipeId, Item output, int resultCount, String group, CraftingBookCategory craftingCategory, List<String> pattern, Map<Character, RecipeItemStack> inputs, Advancement.SerializedAdvancement advancementBuilder, MinecraftKey advancementId, boolean showNotification) {
            super(craftingCategory);
            this.a = recipeId;
            this.b = output;
            this.c = resultCount;
            this.d = group;
            this.e = pattern;
            this.f = inputs;
            this.g = advancementBuilder;
            this.h = advancementId;
            this.i = showNotification;
        }

        @Override
        @Override
        public void a(JsonObject json) {
            super.a(json);
            if (!this.d.isEmpty()) {
                json.addProperty("group", this.d);
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : this.e) {
                jsonArray.add(string);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<Character, RecipeItemStack> entry : this.f.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), entry.getValue().c());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", BuiltInRegistries.i.b(this.b).toString());
            if (this.c > 1) {
                jsonObject2.addProperty("count", (Number)this.c);
            }
            json.add("result", (JsonElement)jsonObject2);
            json.addProperty("show_notification", Boolean.valueOf(this.i));
        }

        @Override
        @Override
        public RecipeSerializer<?> c() {
            return RecipeSerializer.a;
        }

        @Override
        @Override
        public MinecraftKey b() {
            return this.a;
        }

        @Override
        @Nullable
        @Override
        public JsonObject d() {
            return this.g.c();
        }

        @Override
        @Nullable
        @Override
        public MinecraftKey e() {
            return this.h;
        }
    }
}

